/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.entity;

import de.markusbordihn.scraptechworkshop.data.collectorstation.CollectorStationStatus;
import de.markusbordihn.scraptechworkshop.entity.robot.BaseRobotEntity;
import de.markusbordihn.scraptechworkshop.entity.robot.collectorstationrobot.CollectorStationRobotEntity;
import de.markusbordihn.scraptechworkshop.registry.entity.CollectorStationRobotEntityRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ClientCollectorStationRobotManager {
    private static final Map<BlockPos, CollectorStationRobotEntity> activeRobots = new HashMap<BlockPos, CollectorStationRobotEntity>();
    private static final Map<BlockPos, CollectorStationStatus> lastStatus = new HashMap<BlockPos, CollectorStationStatus>();

    public static void updateRobot(ClientLevel level, BlockPos blockPos, Direction facing, CollectorStationStatus status) {
        CollectorStationRobotEntity robot = activeRobots.get(blockPos);
        if (status.isRobotActive()) {
            if (robot == null || robot.m_213877_()) {
                if (robot != null) {
                    activeRobots.remove(blockPos);
                }
                if ((robot = ClientCollectorStationRobotManager.spawnRobot(level, blockPos, facing)) == null) {
                    return;
                }
                activeRobots.put(blockPos, robot);
            }
            robot.setStationPos(blockPos);
            robot.setFacing(facing);
            robot.setStatus(status);
            lastStatus.put(blockPos, status);
        } else if (robot != null) {
            ClientCollectorStationRobotManager.despawnRobot(level, blockPos);
            lastStatus.remove(blockPos);
        }
    }

    private static CollectorStationRobotEntity spawnRobot(ClientLevel level, BlockPos blockPos, Direction facing) {
        CollectorStationRobotEntity robot = new CollectorStationRobotEntity((EntityType<? extends BaseRobotEntity>)CollectorStationRobotEntityRegistry.COLLECTOR_STATION_ROBOT_ENTITY_TYPE, (Level)level);
        Vec3 spawnPos = new Vec3((double)blockPos.m_123341_() + 0.5 + (double)facing.m_122429_() * 1.0, (double)blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5 + (double)facing.m_122431_() * 1.0);
        robot.m_146884_(spawnPos);
        robot.m_146922_(facing.m_122435_());
        robot.registerClientSideGoals();
        int entityId = robot.m_19879_();
        level.m_104627_(entityId, (Entity)robot);
        return robot;
    }

    private static void despawnRobot(ClientLevel level, BlockPos blockPos) {
        CollectorStationRobotEntity robot = activeRobots.remove(blockPos);
        if (robot != null && !robot.m_213877_()) {
            robot.m_146870_();
        }
    }

    public static CollectorStationRobotEntity getRobot(BlockPos blockPos) {
        return activeRobots.get(blockPos);
    }
}

