/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.entity.robot.scraprobot;

import de.markusbordihn.scraptechworkshop.entity.robot.BaseRobotEntity;
import de.markusbordihn.scraptechworkshop.spawner.RobotSpawnConfig;
import de.markusbordihn.scraptechworkshop.tags.ModItemTags;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MixedScrapRobotEntity
extends BaseRobotEntity {
    public static final String ID = "mixed_scrap_robot";
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final RobotSpawnConfig SPAWN_CONFIG = RobotSpawnConfig.load("mixed_scrap_robot");

    public MixedScrapRobotEntity(EntityType<? extends BaseRobotEntity> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MixedScrapRobotEntity.createBaseAttributes();
    }

    public static boolean checkRobotSpawnRules(EntityType<MixedScrapRobotEntity> entityType, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos blockPos, RandomSource random) {
        double distanceFromCenter = Math.sqrt(blockPos.m_123341_() * blockPos.m_123341_() + blockPos.m_123343_() * blockPos.m_123343_());
        if (MixedScrapRobotEntity.SPAWN_CONFIG.minDistanceFromCenter > 0 && distanceFromCenter < (double)MixedScrapRobotEntity.SPAWN_CONFIG.minDistanceFromCenter) {
            return false;
        }
        log.debug("Mixed Scrap Robot check spawn rules at {} (distance from center: {})", (Object)blockPos, (Object)((int)distanceFromCenter));
        return true;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_204132_(ModItemTags.MIXED_SCRAP), false));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new FollowMobGoal((Mob)this, 1.0, 3.0f, 7.0f));
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_41619_()) {
            return super.m_6071_(player, hand);
        }
        boolean isValidFood = itemStack.m_204117_(ModItemTags.MIXED_SCRAP);
        if (!this.m_9236_().f_46443_ && isValidFood) {
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            this.m_5634_(2.0f);
        }
        if (isValidFood) {
            this.nodYes();
            this.m_5496_(SoundEvents.f_12321_, 1.0f, 1.0f);
        } else {
            this.shakeNo();
            this.m_5496_(SoundEvents.f_12507_, 1.0f, 1.0f);
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }
}

