/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.block.entity;

import de.markusbordihn.scraptechworkshop.block.RecyclerBlock;
import de.markusbordihn.scraptechworkshop.config.RecyclerConfig;
import de.markusbordihn.scraptechworkshop.data.recycler.RecyclerStatus;
import de.markusbordihn.scraptechworkshop.menu.RecyclerMenu;
import de.markusbordihn.scraptechworkshop.recipe.recycler.RecyclerRecipe;
import de.markusbordihn.scraptechworkshop.recipe.recycler.RecyclerRecipeSelector;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecyclerBlockEntity
extends BlockEntity
implements MenuProvider,
WorldlyContainer {
    public static final int INPUT_SLOTS = 1;
    public static final int OUTPUT_SLOTS = 9;
    public static final int UPGRADE_SLOTS = 2;
    public static final int TOTAL_SLOTS = 12;
    public static final int INPUT_SLOT = 0;
    public static final int FIRST_OUTPUT_SLOT = 1;
    public static final int LAST_OUTPUT_SLOT = 9;
    public static final String ID = "recycler";
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final String PROGRESS_TAG = "Progress";
    private static final String MAX_PROGRESS_TAG = "MaxProgress";
    private static final String NO_RECIPE_TIMER_TAG = "NoRecipeTimer";
    private static final String DONE_TIMER_TAG = "DoneTimer";
    private static final String ITEM_TAG_PREFIX = "Item";
    private static final int PROGRESS_DATA_INDEX = 0;
    private static final int MAX_PROGRESS_DATA_INDEX = 1;
    private static final String TRANSLATION_KEY = "container.scrap_tech_workshop.recycler";
    private static final int NO_RECIPE_COOLDOWN = 40;
    private static final int DONE_DISPLAY_TIME = 20;
    public static BlockEntityType<RecyclerBlockEntity> TYPE;
    private final ItemStack[] items = new ItemStack[12];
    private int progress = 0;
    private int maxProgress = RecyclerConfig.processTime;
    private final ContainerData containerData = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> RecyclerBlockEntity.this.progress;
                case 1 -> RecyclerBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    RecyclerBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    RecyclerBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private int noRecipeTimer = 0;
    private int doneTimer = 0;
    private RecyclerRecipe currentRecipe = null;
    private int tickCounter = 0;

    public RecyclerBlockEntity(BlockPos pos, BlockState blockState) {
        super(TYPE, pos, blockState);
        Arrays.fill(this.items, ItemStack.f_41583_);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, RecyclerBlockEntity blockEntity) {
        TickResult result;
        if (level.f_46443_) {
            return;
        }
        ++blockEntity.tickCounter;
        RecyclerStatus currentStatus = (RecyclerStatus)((Object)state.m_61143_(RecyclerBlock.STATUS));
        switch (currentStatus) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case NO_RECIPE: {
                TickResult tickResult = blockEntity.handleNoRecipeStatus();
                break;
            }
            case DONE: {
                TickResult tickResult = blockEntity.handleDoneStatus();
                break;
            }
            case IDLE: 
            case WORKING: 
            case ERROR: {
                TickResult tickResult = result = blockEntity.handleActiveStatus(level, pos, state);
            }
        }
        if (result.newStatus != currentStatus) {
            RecyclerBlock.updateStatus(level, pos, result.newStatus);
        }
        if (result.hasChanged && blockEntity.tickCounter % RecyclerConfig.progressUpdateInterval == 0) {
            blockEntity.m_6596_();
        }
    }

    private TickResult handleNoRecipeStatus() {
        --this.noRecipeTimer;
        if (this.noRecipeTimer <= 0) {
            return new TickResult(RecyclerStatus.IDLE, true);
        }
        return new TickResult(RecyclerStatus.NO_RECIPE, false);
    }

    private TickResult handleDoneStatus() {
        --this.doneTimer;
        if (this.doneTimer <= 0) {
            this.currentRecipe = this.findRecipe();
            if (this.currentRecipe != null && this.canProcessCurrentRecipe()) {
                this.progress = 0;
                return new TickResult(RecyclerStatus.WORKING, true);
            }
            return new TickResult(RecyclerStatus.IDLE, true);
        }
        return new TickResult(RecyclerStatus.DONE, false);
    }

    private TickResult handleActiveStatus(Level level, BlockPos pos, BlockState state) {
        boolean hasChanged = false;
        RecyclerStatus newStatus = (RecyclerStatus)((Object)state.m_61143_(RecyclerBlock.STATUS));
        if (this.currentRecipe == null || !this.canProcessCurrentRecipe()) {
            this.currentRecipe = this.findRecipe();
            if (this.currentRecipe == null && !this.getInputStack().m_41619_()) {
                this.ejectInputItem(level, pos, state);
                this.noRecipeTimer = 40;
                return new TickResult(RecyclerStatus.NO_RECIPE, true);
            }
            this.progress = 0;
            hasChanged = true;
        }
        if (this.currentRecipe != null && this.canProcessCurrentRecipe()) {
            ++this.progress;
            newStatus = RecyclerStatus.WORKING;
            hasChanged = true;
            if (this.progress >= this.maxProgress) {
                this.processRecipe();
                this.progress = 0;
                this.currentRecipe = null;
                newStatus = RecyclerStatus.DONE;
                this.doneTimer = 20;
            }
        } else if (this.currentRecipe != null && !this.canProcessCurrentRecipe()) {
            ItemStack inputStack = this.getInputStack();
            newStatus = !inputStack.m_41619_() && this.currentRecipe.matchesInput(inputStack) ? RecyclerStatus.ERROR : RecyclerStatus.IDLE;
            this.progress = 0;
            hasChanged = true;
        } else if (this.progress > 0) {
            if (this.findRecipe() == null) {
                newStatus = RecyclerStatus.IDLE;
            }
            this.progress = Math.max(0, this.progress - 2);
            hasChanged = true;
            if (this.progress == 0) {
                newStatus = RecyclerStatus.IDLE;
            }
        } else {
            newStatus = RecyclerStatus.IDLE;
        }
        return new TickResult(newStatus, hasChanged);
    }

    private RecyclerRecipe findRecipe() {
        if (this.f_58857_ == null || this.getInputStack().m_41619_()) {
            return null;
        }
        ItemStack inputStack = this.getInputStack();
        RecyclerRecipe recipe = RecyclerRecipeSelector.selectBestRecipe(this.f_58857_, inputStack).orElse(null);
        if (recipe == null) {
            log.debug("No recycler recipe found for item: {} ({})", (Object)inputStack.m_41720_(), (Object)inputStack.m_41720_().m_5524_());
        }
        return recipe;
    }

    private boolean canProcessCurrentRecipe() {
        if (this.currentRecipe == null) {
            return false;
        }
        ItemStack inputStack = this.getInputStack();
        if (inputStack.m_41619_()) {
            return false;
        }
        if (!this.currentRecipe.matchesInput(inputStack)) {
            return false;
        }
        return this.canInsertOutputs(this.currentRecipe.getOutputsForInput(inputStack));
    }

    private void processRecipe() {
        if (this.currentRecipe == null || this.f_58857_ == null) {
            return;
        }
        ItemStack inputStack = this.getInputStack();
        if (inputStack.m_41619_()) {
            return;
        }
        List<ItemStack> outputs = this.currentRecipe.getOutputsForInput(inputStack);
        outputs.forEach(this::insertOutput);
        inputStack.m_41774_(1);
        this.m_6596_();
        log.debug("Processed item with recipe: {} -> {} outputs", (Object)inputStack.m_41720_(), (Object)outputs.size());
    }

    private void ejectInputItem(Level level, BlockPos pos, BlockState state) {
        ItemStack inputStack = this.getInputStack();
        if (inputStack.m_41619_()) {
            return;
        }
        Direction backDirection = ((Direction)state.m_61143_((Property)RecyclerBlock.FACING)).m_122424_();
        BlockPos ejectPos = pos.m_121945_(backDirection);
        ItemStack itemToEject = inputStack.m_41777_();
        itemToEject.m_41764_(1);
        this.getInputStack().m_41774_(1);
        Containers.m_18992_((Level)level, (double)((double)ejectPos.m_123341_() + 0.5), (double)((double)ejectPos.m_123342_() + 0.5), (double)((double)ejectPos.m_123343_() + 0.5), (ItemStack)itemToEject);
        log.debug("Ejected item (no recipe): {} at position {}", (Object)itemToEject.m_41720_(), (Object)ejectPos);
        this.addEjectionFeedback(level, pos, ejectPos);
        this.m_6596_();
    }

    private void addEjectionFeedback(Level level, BlockPos recyclerPos, BlockPos ejectPos) {
        if (level.f_46443_) {
            return;
        }
        level.m_5594_(null, recyclerPos, SoundEvents.f_11797_, SoundSource.BLOCKS, 0.5f, 1.2f);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)ejectPos.m_123341_() + 0.5, (double)ejectPos.m_123342_() + 0.5, (double)ejectPos.m_123343_() + 0.5, 3, 0.2, 0.1, 0.2, 0.02);
        }
    }

    private ItemStack getInputStack() {
        return this.m_8020_(0);
    }

    private boolean canInsertOutputs(List<ItemStack> outputs) {
        ItemStack[] simulatedItems = new ItemStack[12];
        for (int i = 0; i < 12; ++i) {
            simulatedItems[i] = this.items[i].m_41777_();
        }
        for (ItemStack output : outputs) {
            if (this.tryInsertOutput(simulatedItems, output, true)) continue;
            return false;
        }
        return true;
    }

    private boolean tryInsertOutput(ItemStack[] itemArray, ItemStack output, boolean isSimulation) {
        ItemStack remaining = output.m_41777_();
        for (int i = 1; i <= 9 && !remaining.m_41619_(); ++i) {
            ItemStack slotStack = itemArray[i];
            if (slotStack.m_41619_()) {
                itemArray[i] = remaining.m_41777_();
                remaining = ItemStack.f_41583_;
                continue;
            }
            if (!ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)remaining)) continue;
            int maxStackSize = slotStack.m_41741_();
            int canAdd = maxStackSize - slotStack.m_41613_();
            int toAdd = Math.min(canAdd, remaining.m_41613_());
            if (isSimulation) {
                slotStack.m_41769_(toAdd);
            } else {
                slotStack.m_41769_(toAdd);
            }
            remaining.m_41774_(toAdd);
        }
        return remaining.m_41619_();
    }

    private void insertOutput(ItemStack output) {
        this.tryInsertOutput(this.items, output, false);
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        for (int i = 0; i < 12; ++i) {
            this.items[i] = compoundTag.m_128441_(ITEM_TAG_PREFIX + i) ? ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_(ITEM_TAG_PREFIX + i)) : ItemStack.f_41583_;
        }
        this.progress = compoundTag.m_128451_(PROGRESS_TAG);
        this.maxProgress = compoundTag.m_128451_(MAX_PROGRESS_TAG);
        this.noRecipeTimer = compoundTag.m_128451_(NO_RECIPE_TIMER_TAG);
        this.doneTimer = compoundTag.m_128451_(DONE_TIMER_TAG);
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        for (int i = 0; i < 12; ++i) {
            if (this.items[i].m_41619_()) continue;
            compoundTag.m_128365_(ITEM_TAG_PREFIX + i, (Tag)this.items[i].m_41739_(new CompoundTag()));
        }
        compoundTag.m_128405_(PROGRESS_TAG, this.progress);
        compoundTag.m_128405_(MAX_PROGRESS_TAG, this.maxProgress);
        compoundTag.m_128405_(NO_RECIPE_TIMER_TAG, this.noRecipeTimer);
        compoundTag.m_128405_(DONE_TIMER_TAG, this.doneTimer);
    }

    public int m_6643_() {
        return 12;
    }

    public boolean m_7983_() {
        for (ItemStack item : this.items) {
            if (item.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int slot) {
        if (slot < 0 || slot >= 12) {
            return ItemStack.f_41583_;
        }
        return this.items[slot];
    }

    public ItemStack m_7407_(int slot, int amount) {
        if (slot < 0 || slot >= 12 || this.items[slot].m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack result = this.items[slot].m_41620_(amount);
        if (this.items[slot].m_41619_()) {
            this.items[slot] = ItemStack.f_41583_;
        }
        this.m_6596_();
        return result;
    }

    public ItemStack m_8016_(int slot) {
        if (slot < 0 || slot >= 12) {
            return ItemStack.f_41583_;
        }
        ItemStack result = this.items[slot];
        this.items[slot] = ItemStack.f_41583_;
        return result;
    }

    public void m_6836_(int slot, ItemStack itemStack) {
        if (slot >= 0 && slot < 12) {
            this.items[slot] = itemStack;
            if (!itemStack.m_41619_() && itemStack.m_41613_() > this.m_6893_()) {
                itemStack.m_41764_(this.m_6893_());
            }
            this.m_6596_();
        }
    }

    public boolean m_6542_(Player player) {
        return Container.m_272074_((BlockEntity)this, (Player)player);
    }

    public boolean m_7013_(int slot, ItemStack itemStack) {
        return slot == 0;
    }

    public void m_6211_() {
        for (int i = 0; i < 12; ++i) {
            this.items[i] = ItemStack.f_41583_;
        }
        this.m_6596_();
    }

    public Component m_5446_() {
        return Component.m_237115_((String)TRANSLATION_KEY);
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new RecyclerMenu(windowId, playerInventory, this, this.containerData);
    }

    public int getRedstoneSignal() {
        if (this.maxProgress <= 0) {
            return 0;
        }
        return this.progress * 15 / this.maxProgress;
    }

    public ContainerData getContainerData() {
        return this.containerData;
    }

    private void syncToClient() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void m_6596_() {
        super.m_6596_();
        this.syncToClient();
    }

    public CompoundTag m_5995_() {
        CompoundTag compoundTag = new CompoundTag();
        this.m_183515_(compoundTag);
        return compoundTag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public int[] m_7071_(Direction direction) {
        if (direction == Direction.UP) {
            return new int[]{0};
        }
        if (direction == Direction.DOWN || direction == this.getBackDirection()) {
            return new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        }
        return new int[0];
    }

    public boolean m_7155_(int slot, ItemStack itemStack, Direction direction) {
        return slot == 0 && direction == Direction.UP;
    }

    public boolean m_7157_(int slot, ItemStack itemStack, Direction direction) {
        return slot >= 1 && slot <= 9 && (direction == Direction.DOWN || direction == this.getBackDirection());
    }

    private Direction getBackDirection() {
        if (this.m_58900_().m_60734_() instanceof RecyclerBlock) {
            return ((Direction)this.m_58900_().m_61143_((Property)RecyclerBlock.FACING)).m_122424_();
        }
        return Direction.NORTH;
    }

    private static class TickResult {
        final RecyclerStatus newStatus;
        final boolean hasChanged;

        TickResult(RecyclerStatus newStatus, boolean hasChanged) {
            this.newStatus = newStatus;
            this.hasChanged = hasChanged;
        }
    }
}

