/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.markusbordihn.scraptechworkshop.item.tool.ScrapMultitoolItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ScrapMultitoolRenderer {
    private static final Minecraft minecraft = Minecraft.m_91087_();

    public static void renderHologram(PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        LocalPlayer player = ScrapMultitoolRenderer.minecraft.f_91074_;
        if (player == null) {
            return;
        }
        ItemStack heldItem = player.m_21120_(InteractionHand.MAIN_HAND);
        Item item = heldItem.m_41720_();
        if (!(item instanceof ScrapMultitoolItem)) {
            return;
        }
        ScrapMultitoolItem multitool = (ScrapMultitoolItem)item;
        if (!multitool.hasEnergy(heldItem, 1)) {
            return;
        }
        HitResult hitResult = ScrapMultitoolRenderer.minecraft.f_91077_;
        if (hitResult == null) {
            return;
        }
        ScrapMultitoolItem.ToolMode mode = ScrapMultitoolItem.ToolMode.NONE;
        Vec3 renderPos = null;
        if (hitResult.m_6662_() == HitResult.Type.ENTITY && hitResult instanceof EntityHitResult) {
            EntityHitResult entityHit = (EntityHitResult)hitResult;
            if (entityHit.m_82443_() instanceof LivingEntity) {
                mode = ScrapMultitoolItem.ToolMode.SWORD;
                renderPos = entityHit.m_82450_();
            }
        } else if (hitResult.m_6662_() == HitResult.Type.BLOCK && hitResult instanceof BlockHitResult) {
            BlockHitResult blockHit = (BlockHitResult)hitResult;
            BlockState state = player.m_9236_().m_8055_(blockHit.m_82425_());
            mode = multitool.getToolModeForBlock(state);
            renderPos = Vec3.m_82512_((Vec3i)blockHit.m_82425_());
        }
        if (mode == ScrapMultitoolItem.ToolMode.NONE || renderPos == null) {
            return;
        }
        ScrapMultitoolRenderer.renderToolHologram(poseStack, bufferSource, renderPos, mode, multitool.getData(heldItem).hologramColor(), light);
    }

    private static void renderToolHologram(PoseStack poseStack, MultiBufferSource bufferSource, Vec3 pos, ScrapMultitoolItem.ToolMode mode, int color, int light) {
        poseStack.m_85836_();
        Vec3 cameraPos = ScrapMultitoolRenderer.minecraft.f_91063_.m_109153_().m_90583_();
        poseStack.m_85837_(pos.f_82479_ - cameraPos.f_82479_, pos.f_82480_ - cameraPos.f_82480_ + 0.5, pos.f_82481_ - cameraPos.f_82481_);
        poseStack.m_252781_(ScrapMultitoolRenderer.minecraft.f_91063_.m_109153_().m_253121_());
        float scale = 0.3f;
        poseStack.m_85841_(scale, scale, scale);
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110466_());
        ScrapMultitoolRenderer.renderModeIcon(poseStack, vertexConsumer, mode, color, light);
        poseStack.m_85849_();
    }

    private static void renderModeIcon(PoseStack poseStack, VertexConsumer consumer, ScrapMultitoolItem.ToolMode mode, int color, int light) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = 0.8f;
        float size = 0.5f;
        PoseStack.Pose pose = poseStack.m_85850_();
        consumer.m_252986_(pose.m_252922_(), -size, -size, 0.0f).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(0).m_85969_(light).m_252939_(pose.m_252943_(), 0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(pose.m_252922_(), size, -size, 0.0f).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_86008_(0).m_85969_(light).m_252939_(pose.m_252943_(), 0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(pose.m_252922_(), size, size, 0.0f).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_86008_(0).m_85969_(light).m_252939_(pose.m_252943_(), 0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(pose.m_252922_(), -size, size, 0.0f).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_86008_(0).m_85969_(light).m_252939_(pose.m_252943_(), 0.0f, 0.0f, 1.0f).m_5752_();
    }
}

