/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.markusbordihn.scraptechworkshop.client.screen.BaseContainerScreen;
import de.markusbordihn.scraptechworkshop.item.tool.ScrapMultitoolItem;
import de.markusbordihn.scraptechworkshop.menu.ScrapMultitoolMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ScrapMultitoolScreen
extends BaseContainerScreen<ScrapMultitoolMenu> {
    private static final ResourceLocation CUSTOM_ELEMENTS_TEXTURE = new ResourceLocation("scrap_tech_workshop", "textures/gui/scrap_multitool_elements.png");
    private static final int SCREEN_WIDTH = 176;
    private static final int SCREEN_HEIGHT = 220;
    private static final int TOOL_RENDER_X = 12;
    private static final int TOOL_RENDER_Y = 12;
    private static final float TOOL_RENDER_SCALE = 3.5f;
    private static final int ENERGY_BAR_X = 152;
    private static final int ENERGY_BAR_Y = 8;
    private static final int ENERGY_BAR_WIDTH = 16;
    private static final int ENERGY_BAR_HEIGHT = 68;
    private static final int BATTERY_SLOT_X = 100;
    private static final int BATTERY_SLOT_Y = 20;
    private static final int MODULE_SLOTS_X1 = 64;
    private static final int MODULE_SLOTS_X2 = 136;
    private static final int MODULE_SLOTS_Y = 50;
    private ItemRenderer itemRenderer;

    public ScrapMultitoolScreen(ScrapMultitoolMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
        this.f_97726_ = 176;
        this.f_97727_ = 220;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97728_ = (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2;
        this.f_97729_ = 6;
        this.f_97731_ = this.f_97727_ - 94;
        this.itemRenderer = this.f_96541_.m_91291_();
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = this.f_97735_;
        int y = this.f_97736_;
        this.renderDefaultBackground(guiGraphics, x, y, this.f_97726_, this.f_97727_);
        this.renderSlot(guiGraphics, x + 100, y + 20);
        for (int i = 0; i < 2; ++i) {
            this.renderSlot(guiGraphics, x + 64 + i * 18, y + 50);
            this.renderSlot(guiGraphics, x + 136 - 36 + i * 18, y + 50);
        }
        this.renderPlayerInventoryAt(guiGraphics, x, y, 137, 195);
        this.renderEnergyBar(guiGraphics, x, y);
        this.render3DMultitool(guiGraphics, x, y);
    }

    private void render3DMultitool(GuiGraphics guiGraphics, int x, int y) {
        ItemStack multitoolStack = ((ScrapMultitoolMenu)this.f_97732_).getMultitoolStack();
        if (!multitoolStack.m_41619_()) {
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_252880_((float)(x + 12 + 24), (float)(y + 12 + 34), 100.0f);
            poseStack.m_85841_(56.0f, 56.0f, 56.0f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(45.0f));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-20.0f));
            this.itemRenderer.m_269128_(multitoolStack, ItemDisplayContext.GUI, 0xF000F0, OverlayTexture.f_118083_, poseStack, (MultiBufferSource)guiGraphics.m_280091_(), (Level)this.f_96541_.f_91073_, 0);
            poseStack.m_85849_();
        }
    }

    private void renderEnergyBar(GuiGraphics guiGraphics, int x, int y) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)CUSTOM_ELEMENTS_TEXTURE);
        ItemStack multitoolStack = ((ScrapMultitoolMenu)this.f_97732_).getMultitoolStack();
        Item item = multitoolStack.m_41720_();
        if (item instanceof ScrapMultitoolItem) {
            ScrapMultitoolItem multitool = (ScrapMultitoolItem)item;
            int energy = multitool.getEnergy(multitoolStack);
            int maxEnergy = 10000;
            if (maxEnergy > 0) {
                guiGraphics.m_280218_(CUSTOM_ELEMENTS_TEXTURE, x + 152, y + 8, 0, 0, 16, 68);
                int energyBarHeight = (int)((float)energy / (float)maxEnergy * 68.0f);
                guiGraphics.m_280218_(CUSTOM_ELEMENTS_TEXTURE, x + 152, y + 8 + (68 - energyBarHeight), 16, 68 - energyBarHeight, 16, energyBarHeight);
            }
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_280072_(GuiGraphics guiGraphics, int x, int y) {
        MutableComponent tooltip;
        ItemStack multitoolStack;
        Item item;
        super.m_280072_(guiGraphics, x, y);
        int relativeX = x - this.f_97735_;
        int relativeY = y - this.f_97736_;
        if (relativeX >= 152 && relativeX <= 168 && relativeY >= 8 && relativeY <= 76 && (item = (multitoolStack = ((ScrapMultitoolMenu)this.f_97732_).getMultitoolStack()).m_41720_()) instanceof ScrapMultitoolItem) {
            ScrapMultitoolItem multitool = (ScrapMultitoolItem)item;
            int energy = multitool.getEnergy(multitoolStack);
            int maxEnergy = 10000;
            int percentage = (int)((float)energy / (float)maxEnergy * 100.0f);
            MutableComponent tooltip2 = Component.m_237110_((String)"gui.scrap_tech_workshop.scrap_multitool.energy", (Object[])new Object[]{energy, maxEnergy, percentage});
            guiGraphics.m_280557_(this.f_96547_, (Component)tooltip2, x, y);
        }
        if (relativeX >= 99 && relativeX <= 117 && relativeY >= 19 && relativeY <= 37) {
            tooltip = Component.m_237115_((String)"gui.scrap_tech_workshop.scrap_multitool.battery_slot");
            guiGraphics.m_280557_(this.f_96547_, (Component)tooltip, x, y);
        }
        if (relativeX >= 64 && relativeX <= 136 && relativeY >= 49 && relativeY <= 67) {
            tooltip = Component.m_237115_((String)"gui.scrap_tech_workshop.scrap_multitool.module_slots");
            guiGraphics.m_280557_(this.f_96547_, (Component)tooltip, x, y);
        }
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, 0x404040, false);
        guiGraphics.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_, 0x404040, false);
        ItemStack multitoolStack = ((ScrapMultitoolMenu)this.f_97732_).getMultitoolStack();
        Item item = multitoolStack.m_41720_();
        if (item instanceof ScrapMultitoolItem) {
            ScrapMultitoolItem multitool = (ScrapMultitoolItem)item;
            int energy = multitool.getEnergy(multitoolStack);
            String energyText = energy + " Energy";
            int textWidth = this.f_96547_.m_92895_(energyText);
            guiGraphics.m_280056_(this.f_96547_, energyText, 152 + (16 - textWidth) / 2, 78, 0x404040, false);
        }
    }
}

