/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.data;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public record ScrapMultitoolData(ItemStack battery, ItemStack[] modules, int hologramColor, boolean hudEnabled, String toolPriority) {
    public static final int MODULE_SLOTS = 4;

    public static ScrapMultitoolData createDefault() {
        return new ScrapMultitoolData(ItemStack.f_41583_, new ItemStack[4], 65535, true, "auto");
    }

    public static ScrapMultitoolData fromNBT(CompoundTag tag) {
        ItemStack battery = ItemStack.f_41583_;
        if (tag.m_128441_("Battery")) {
            battery = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Battery"));
        }
        ItemStack[] modules = new ItemStack[4];
        if (tag.m_128441_("Modules")) {
            ListTag modulesTag = tag.m_128437_("Modules", 10);
            for (int i = 0; i < Math.min(modulesTag.size(), 4); ++i) {
                modules[i] = ItemStack.m_41712_((CompoundTag)modulesTag.m_128728_(i));
            }
        }
        return new ScrapMultitoolData(battery, modules, tag.m_128451_("HologramColor"), tag.m_128471_("HudEnabled"), tag.m_128461_("ToolPriority"));
    }

    public boolean hasBattery() {
        return !this.battery.m_41619_();
    }

    public CompoundTag toNBT() {
        CompoundTag compoundTag = new CompoundTag();
        if (!this.battery.m_41619_()) {
            compoundTag.m_128365_("Battery", (Tag)this.battery.m_41739_(new CompoundTag()));
        }
        ListTag modulesTag = new ListTag();
        for (ItemStack module : this.modules) {
            if (module != null && !module.m_41619_()) {
                modulesTag.add((Object)module.m_41739_(new CompoundTag()));
                continue;
            }
            modulesTag.add((Object)new CompoundTag());
        }
        compoundTag.m_128365_("Modules", (Tag)modulesTag);
        compoundTag.m_128405_("HologramColor", this.hologramColor);
        compoundTag.m_128379_("HudEnabled", this.hudEnabled);
        compoundTag.m_128359_("ToolPriority", this.toolPriority);
        return compoundTag;
    }

    public ScrapMultitoolData withBattery(ItemStack newBattery) {
        return new ScrapMultitoolData(newBattery, this.modules, this.hologramColor, this.hudEnabled, this.toolPriority);
    }

    public ScrapMultitoolData withModule(int slot, ItemStack module) {
        if (slot < 0 || slot >= 4) {
            return this;
        }
        ItemStack[] newModules = (ItemStack[])this.modules.clone();
        newModules[slot] = module;
        return new ScrapMultitoolData(this.battery, newModules, this.hologramColor, this.hudEnabled, this.toolPriority);
    }
}

