/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.item.tool;

import de.markusbordihn.scraptechworkshop.Constants;
import de.markusbordihn.scraptechworkshop.data.ScrapMultitoolData;
import de.markusbordihn.scraptechworkshop.item.ModItems;
import de.markusbordihn.scraptechworkshop.item.component.EnergyCellItem;
import de.markusbordihn.scraptechworkshop.menu.ScrapMultitoolMenu;
import de.markusbordihn.scraptechworkshop.menu.ScrapMultitoolMenuProvider;
import java.lang.reflect.Proxy;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScrapMultitoolItem
extends DiggerItem {
    public static final String ID = "scrap_multitool";
    public static final int ENERGY_MAX = 10000;
    public static final int ENERGY_PER_USE = 1;
    public static final int ENERGY_PER_BLOCK = 2;
    public static final int ENERGY_PER_ATTACK = 5;
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");

    public ScrapMultitoolItem(Item.Properties properties) {
        super(4.0f, -2.0f, (Tier)Tiers.IRON, BlockTags.f_144282_, properties.m_41503_(10000).m_41497_(Rarity.RARE));
    }

    public static ItemStack createWithBattery() {
        ItemStack battery = new ItemStack((ItemLike)ModItems.SLIGHTLY_DAMAGED_ENERGY_CELL.get());
        Item item = battery.m_41720_();
        if (item instanceof EnergyCellItem) {
            EnergyCellItem energyCell = (EnergyCellItem)item;
            energyCell.setEnergy(battery, 2500);
        }
        ItemStack multitool = new ItemStack((ItemLike)ModItems.SCRAP_MULTITOOL.get());
        ScrapMultitoolData data = ScrapMultitoolData.createDefault().withBattery(battery);
        ((ScrapMultitoolItem)multitool.m_41720_()).setData(multitool, data);
        ((ScrapMultitoolItem)multitool.m_41720_()).syncEnergyFromBattery(multitool);
        return multitool;
    }

    public void m_7836_(ItemStack itemStack, Level level, Player player) {
        super.m_7836_(itemStack, level, player);
        ScrapMultitoolData data = this.getData(itemStack);
        if (!data.hasBattery()) {
            ItemStack battery = new ItemStack((ItemLike)ModItems.SLIGHTLY_DAMAGED_ENERGY_CELL.get());
            Item item = battery.m_41720_();
            if (item instanceof EnergyCellItem) {
                EnergyCellItem energyCell = (EnergyCellItem)item;
                energyCell.setEnergy(battery, 2500);
            }
            this.setData(itemStack, data.withBattery(battery));
            this.syncEnergyFromBattery(itemStack);
        }
    }

    public float m_8102_(ItemStack itemStack, BlockState state) {
        if (!this.hasEnergy(itemStack, 2)) {
            return 1.0f;
        }
        ToolMode mode = this.getToolModeForBlock(state);
        if (mode != ToolMode.NONE) {
            return this.getPoweredSpeed(mode);
        }
        return super.m_8102_(itemStack, state);
    }

    public boolean m_7579_(ItemStack itemStack, LivingEntity target, LivingEntity attacker) {
        if (this.hasEnergy(itemStack, 5)) {
            this.consumeEnergy(itemStack, 5);
            return true;
        }
        return false;
    }

    public boolean m_6813_(ItemStack itemStack, Level level, BlockState state, BlockPos pos, LivingEntity entity) {
        if (this.hasEnergy(itemStack, 2)) {
            this.consumeEnergy(itemStack, 2);
            return true;
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (player.m_6144_() && !level.f_46443_) {
            this.openMultitoolScreen(player, itemStack, hand);
            return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.f_46443_);
        }
        if (!level.f_46443_ && this.hasEnergy(itemStack, 1)) {
            Vec3 playerPos = player.m_20182_().m_82520_(0.0, 1.0, 0.0);
            Vec3 lookDirection = player.m_20154_();
            Vec3 particlePos = playerPos.m_82549_(lookDirection.m_82490_(1.5));
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123810_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 5, 0.2, 0.2, 0.2, 0.05);
            }
            level.m_5594_(null, player.m_20183_(), SoundEvents.f_11739_, SoundSource.PLAYERS, 0.5f, 1.2f);
            this.consumeEnergy(itemStack, 1);
        }
        return InteractionResultHolder.m_19098_((Object)itemStack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43723_() != null && context.m_43723_().m_6144_()) {
            return InteractionResult.PASS;
        }
        return super.m_6225_(context);
    }

    public boolean hasEnergy(ItemStack itemStack, int amount) {
        return this.getEnergy(itemStack) >= amount;
    }

    public int getEnergy(ItemStack itemStack) {
        return 10000 - itemStack.m_41773_();
    }

    public float getEnergyPercentage(ItemStack itemStack) {
        int energy = this.getEnergy(itemStack);
        if (energy <= 1) {
            return 0.0f;
        }
        return (float)energy / 10000.0f;
    }

    public int getDisplayEnergy(ItemStack itemStack) {
        float percentage = this.getEnergyPercentage(itemStack);
        return Math.round(percentage * 100.0f);
    }

    public int getTotalEnergy(ItemStack itemStack) {
        ItemStack battery;
        Item item;
        int toolEnergy = this.getEnergy(itemStack);
        ScrapMultitoolData data = this.getData(itemStack);
        if (data.hasBattery() && (item = (battery = data.battery()).m_41720_()) instanceof EnergyCellItem) {
            EnergyCellItem batteryItem = (EnergyCellItem)item;
            return toolEnergy + batteryItem.getEnergy(battery);
        }
        return toolEnergy;
    }

    public void syncEnergyFromBattery(ItemStack itemStack) {
        ScrapMultitoolData data = this.getData(itemStack);
        if (data.hasBattery()) {
            ItemStack battery = data.battery();
            Item item = battery.m_41720_();
            if (item instanceof EnergyCellItem) {
                EnergyCellItem batteryItem = (EnergyCellItem)item;
                float batteryPercentage = batteryItem.getEnergyPercentage(battery);
                int newEnergy = Math.round(10000.0f * batteryPercentage);
                this.setEnergy(itemStack, newEnergy);
            }
        } else {
            this.setEnergy(itemStack, 1);
        }
        this.updateDisplayModel(itemStack, data);
    }

    public BatteryLevel getBatteryLevel(ItemStack itemStack) {
        ScrapMultitoolData data = this.getData(itemStack);
        if (!data.hasBattery()) {
            return BatteryLevel.BATTERY_LEVEL_0;
        }
        ItemStack battery = data.battery();
        Item item = battery.m_41720_();
        if (item instanceof EnergyCellItem) {
            EnergyCellItem batteryItem = (EnergyCellItem)item;
            float percentage = batteryItem.getEnergyPercentage(battery);
            if (percentage >= 1.0f) {
                return BatteryLevel.BATTERY_LEVEL_100;
            }
            if (percentage >= 0.75f) {
                return BatteryLevel.BATTERY_LEVEL_75;
            }
            if (percentage >= 0.5f) {
                return BatteryLevel.BATTERY_LEVEL_50;
            }
            if (percentage >= 0.25f) {
                return BatteryLevel.BATTERY_LEVEL_25;
            }
        }
        return BatteryLevel.BATTERY_LEVEL_0;
    }

    public void setEnergy(ItemStack itemStack, int energy) {
        itemStack.m_41721_(10000 - Math.max(1, Math.min(energy, 10000)));
    }

    public void consumeEnergy(ItemStack itemStack, int amount) {
        ItemStack battery;
        Item item;
        ScrapMultitoolData data = this.getData(itemStack);
        if (data.hasBattery() && (item = (battery = data.battery()).m_41720_()) instanceof EnergyCellItem) {
            EnergyCellItem batteryItem = (EnergyCellItem)item;
            int batteryEnergy = batteryItem.getEnergy(battery);
            if (batteryEnergy > amount) {
                batteryItem.consumeEnergy(battery, amount);
                this.syncEnergyFromBattery(itemStack);
                return;
            }
            ItemStack emptyBattery = batteryItem.createEmptyBattery();
            ScrapMultitoolData newData = new ScrapMultitoolData(emptyBattery, data.modules(), data.hologramColor(), data.hudEnabled(), data.toolPriority());
            this.setData(itemStack, newData);
            this.syncEnergyFromBattery(itemStack);
            return;
        }
        int currentEnergy = this.getEnergy(itemStack);
        this.setEnergy(itemStack, Math.max(1, currentEnergy - amount));
    }

    public void addEnergy(ItemStack itemStack, int amount) {
        int currentEnergy = this.getEnergy(itemStack);
        this.setEnergy(itemStack, Math.min(10000, currentEnergy + amount));
    }

    public ToolMode getToolModeForBlock(BlockState state) {
        if (state.m_204336_(BlockTags.f_144280_)) {
            return ToolMode.AXE;
        }
        if (state.m_204336_(BlockTags.f_144283_)) {
            return ToolMode.SHOVEL;
        }
        if (state.m_204336_(BlockTags.f_144282_)) {
            return ToolMode.PICKAXE;
        }
        return ToolMode.NONE;
    }

    public ToolMode getToolModeForEntity(LivingEntity entity) {
        return entity != null ? ToolMode.SWORD : ToolMode.NONE;
    }

    private float getPoweredSpeed(ToolMode mode) {
        return switch (mode) {
            case ToolMode.PICKAXE -> 8.0f;
            case ToolMode.AXE -> 9.0f;
            case ToolMode.SHOVEL -> 7.0f;
            default -> 6.0f;
        };
    }

    public ScrapMultitoolData getData(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41784_();
        if (tag.m_128441_("MultitoolData")) {
            return ScrapMultitoolData.fromNBT(tag.m_128469_("MultitoolData"));
        }
        return ScrapMultitoolData.createDefault();
    }

    public void setData(ItemStack itemStack, ScrapMultitoolData data) {
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128365_("MultitoolData", (Tag)data.toNBT());
        this.updateDisplayModel(itemStack, data);
    }

    private void updateDisplayModel(ItemStack itemStack, ScrapMultitoolData data) {
        BatteryLevel level = this.getBatteryLevel(itemStack);
        int customModelData = switch (level) {
            default -> throw new IncompatibleClassChangeError();
            case BatteryLevel.BATTERY_LEVEL_0 -> 1;
            case BatteryLevel.BATTERY_LEVEL_25 -> 2;
            case BatteryLevel.BATTERY_LEVEL_50 -> 3;
            case BatteryLevel.BATTERY_LEVEL_75 -> 4;
            case BatteryLevel.BATTERY_LEVEL_100 -> 5;
        };
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128405_("CustomModelData", customModelData);
    }

    private void openMultitoolScreen(Player player, ItemStack stack, InteractionHand hand) {
        if (Constants.IS_FABRIC) {
            try {
                Class<?> menuFactoryInterface = Class.forName("de.markusbordihn.scraptechworkshop.menu.ItemBaseScreenHandler$MenuFactory");
                Object menuFactory = Proxy.newProxyInstance(menuFactoryInterface.getClassLoader(), new Class[]{menuFactoryInterface}, (proxy, method, args) -> {
                    if ("create".equals(method.getName())) {
                        int windowId = (Integer)args[0];
                        Inventory playerInventory = (Inventory)args[1];
                        ItemStack itemStack = (ItemStack)args[2];
                        InteractionHand h = (InteractionHand)args[3];
                        int slotIndex = (Integer)args[4];
                        return new ScrapMultitoolMenu(windowId, playerInventory, itemStack, h, slotIndex);
                    }
                    return null;
                });
                Class<?> fabricFactoryClass = Class.forName("de.markusbordihn.scraptechworkshop.menu.ItemBaseScreenHandler");
                Object fabricFactory = fabricFactoryClass.getConstructor(ItemStack.class, InteractionHand.class, menuFactoryInterface).newInstance(stack, hand, menuFactory);
                player.m_5893_((MenuProvider)fabricFactory);
            }
            catch (Exception e) {
                log.error("Failed to open Multitool menu on Fabric: {}", (Object)e.getMessage(), (Object)e);
                player.m_5893_((MenuProvider)new ScrapMultitoolMenuProvider(stack, hand));
            }
        } else {
            player.m_5893_((MenuProvider)new ScrapMultitoolMenuProvider(stack, hand));
        }
    }

    public boolean m_142522_(ItemStack itemStack) {
        return true;
    }

    public int m_142159_(ItemStack itemStack) {
        float energyRatio = this.getEnergyPercentage(itemStack);
        return energyRatio > 0.6f ? 65280 : (energyRatio > 0.3f ? 0xFFFF00 : 0xFF0000);
    }

    public void m_7373_(ItemStack itemStack, Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)Component.m_237115_((String)"item.scrap_tech_workshop.scrap_multitool.description"));
        int displayEnergy = this.getDisplayEnergy(itemStack);
        tooltipComponents.add((Component)Component.m_237113_((String)("Energy: " + displayEnergy + "%")).m_130938_(style -> style.m_178520_(this.m_142159_(itemStack))));
        ScrapMultitoolData data = this.getData(itemStack);
        if (data.hasBattery()) {
            tooltipComponents.add((Component)Component.m_237113_((String)"Battery: Installed").m_130938_(style -> style.m_178520_(65280)));
        }
        tooltipComponents.add((Component)Component.m_237113_((String)"Shift + Right-click to configure").m_130938_(style -> style.m_131155_(Boolean.valueOf(true))));
        super.m_7373_(itemStack, level, tooltipComponents, isAdvanced);
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public boolean m_8120_(ItemStack itemStack) {
        return false;
    }

    public static enum ToolMode {
        NONE,
        PICKAXE,
        AXE,
        SHOVEL,
        SWORD;

    }

    public static enum BatteryLevel {
        BATTERY_LEVEL_0(0.0f),
        BATTERY_LEVEL_25(0.25f),
        BATTERY_LEVEL_50(0.5f),
        BATTERY_LEVEL_75(0.75f),
        BATTERY_LEVEL_100(1.0f);

        private final float percentage;

        private BatteryLevel(float percentage) {
            this.percentage = percentage;
        }

        public float getPercentage() {
            return this.percentage;
        }
    }
}

