/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.menu;

import de.markusbordihn.scraptechworkshop.data.ScrapMultitoolData;
import de.markusbordihn.scraptechworkshop.item.component.EnergyCellItem;
import de.markusbordihn.scraptechworkshop.item.tool.ScrapMultitoolItem;
import de.markusbordihn.scraptechworkshop.menu.slots.MultitoolBatterySlot;
import de.markusbordihn.scraptechworkshop.menu.slots.MultitoolModuleSlot;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ScrapMultitoolMenu
extends AbstractContainerMenu {
    public static final int BATTERY_SLOT_X = 100;
    public static final int BATTERY_SLOT_Y = 20;
    public static final int SLOT_SPACING = 18;
    public static final int MODULE_SLOTS_START_X = 64;
    public static final int MODULE_SLOTS_Y = 50;
    public static final int MODULE_SLOTS_COUNT = 4;
    public static final int PLAYER_INVENTORY_START_X = 8;
    public static final int PLAYER_INVENTORY_START_Y = 138;
    public static final int PLAYER_INVENTORY_ROWS = 3;
    public static final int PLAYER_INVENTORY_COLUMNS = 9;
    public static final int PLAYER_HOTBAR_START_X = 8;
    public static final int PLAYER_HOTBAR_Y = 196;
    public static final int PLAYER_HOTBAR_SLOTS = 9;
    public static final int TOTAL_TOOL_SLOTS = 5;
    public static MenuType<ScrapMultitoolMenu> TYPE;
    private final ItemStack multitoolStack;
    private final SimpleContainer toolContainer;
    private final int toolSlotIndex;
    private final InteractionHand hand;
    private boolean initialized = false;

    public ScrapMultitoolMenu(int windowId, Inventory playerInventory, FriendlyByteBuf additionalData) {
        this(windowId, playerInventory, additionalData != null ? additionalData.m_130267_() : playerInventory.f_35978_.m_21205_(), additionalData != null ? (InteractionHand)additionalData.m_130066_(InteractionHand.class) : InteractionHand.MAIN_HAND, additionalData != null ? additionalData.readInt() : playerInventory.f_35977_);
    }

    public ScrapMultitoolMenu(int windowId, Inventory playerInventory, ItemStack multitoolStack, InteractionHand hand, int slotIndex) {
        super(TYPE, windowId);
        this.multitoolStack = multitoolStack;
        this.hand = hand;
        this.toolSlotIndex = slotIndex;
        Item item = multitoolStack.m_41720_();
        if (!(item instanceof ScrapMultitoolItem)) {
            throw new IllegalArgumentException("Invalid multitool ItemStack");
        }
        ScrapMultitoolItem multitool = (ScrapMultitoolItem)item;
        this.toolContainer = this.createToolContainer(multitool);
        this.addToolSlots();
        this.addPlayerInventory(playerInventory);
        this.addPlayerHotbar(playerInventory);
    }

    private SimpleContainer createToolContainer(ScrapMultitoolItem multitool) {
        ScrapMultitoolData data = multitool.getData(this.multitoolStack);
        SimpleContainer container = new SimpleContainer(5){

            public void m_6596_() {
                super.m_6596_();
                if (ScrapMultitoolMenu.this.initialized) {
                    ScrapMultitoolMenu.this.saveToMultitool();
                }
            }
        };
        container.m_6836_(0, data.battery());
        for (int i = 0; i < data.modules().length; ++i) {
            ItemStack module = data.modules()[i];
            if (module == null) continue;
            container.m_6836_(i + 1, module);
        }
        this.initialized = true;
        return container;
    }

    private void addToolSlots() {
        this.m_38897_(new MultitoolBatterySlot((Container)this.toolContainer, 0, 100, 20));
        for (int i = 0; i < 4; ++i) {
            int slotIndex = i + 1;
            int x = 64 + i * 18;
            this.m_38897_(new MultitoolModuleSlot((Container)this.toolContainer, slotIndex, x, 50));
        }
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 138 + row * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        int col = 0;
        while (col < 9) {
            int x = 8 + col * 18;
            int index = col++;
            this.m_38897_(new Slot((Container)playerInventory, index, x, 196){

                public boolean m_8010_(Player player) {
                    return this.f_40219_ != ScrapMultitoolMenu.this.toolSlotIndex;
                }
            });
        }
    }

    private void saveToMultitool() {
        Item item = this.multitoolStack.m_41720_();
        if (item instanceof ScrapMultitoolItem) {
            ScrapMultitoolItem multitool = (ScrapMultitoolItem)item;
            if (this.toolContainer != null) {
                ItemStack[] modules = new ItemStack[4];
                for (int i = 0; i < modules.length; ++i) {
                    modules[i] = this.toolContainer.m_8020_(i + 1);
                }
                ScrapMultitoolData currentData = multitool.getData(this.multitoolStack);
                ScrapMultitoolData newData = new ScrapMultitoolData(this.toolContainer.m_8020_(0), modules, currentData.hologramColor(), currentData.hudEnabled(), currentData.toolPriority());
                multitool.setData(this.multitoolStack, newData);
                multitool.syncEnergyFromBattery(this.multitoolStack);
            }
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemStack = slotStack.m_41777_();
            int playerInventoryEnd = 32;
            int playerHotbarEnd = playerInventoryEnd + 9;
            if (index < 5 ? !this.m_38903_(slotStack, 5, playerHotbarEnd, true) : (index < playerInventoryEnd ? (slotStack.m_41720_() instanceof EnergyCellItem ? !this.m_38903_(slotStack, 0, 1, false) && !this.m_38903_(slotStack, playerInventoryEnd, playerHotbarEnd, false) : (this.isValidModule(slotStack) ? !this.m_38903_(slotStack, 1, 5, false) && !this.m_38903_(slotStack, playerInventoryEnd, playerHotbarEnd, false) : !this.m_38903_(slotStack, playerInventoryEnd, playerHotbarEnd, false))) : index < playerHotbarEnd && (slotStack.m_41720_() instanceof EnergyCellItem ? !this.m_38903_(slotStack, 0, 1, false) && !this.m_38903_(slotStack, 5, playerInventoryEnd, false) : (this.isValidModule(slotStack) ? !this.m_38903_(slotStack, 1, 5, false) && !this.m_38903_(slotStack, 5, playerInventoryEnd, false) : !this.m_38903_(slotStack, 5, playerInventoryEnd, false))))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemStack;
    }

    private boolean isValidModule(ItemStack stack) {
        return stack.m_41720_().toString().contains("module") || stack.m_41720_().toString().contains("upgrade");
    }

    public boolean m_6875_(Player player) {
        return !this.multitoolStack.m_41619_() && player.m_150109_().m_36063_(this.multitoolStack);
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.saveToMultitool();
    }

    public ItemStack getMultitoolStack() {
        return this.multitoolStack;
    }

    public InteractionHand getHand() {
        return this.hand;
    }
}

