/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.recipe.recycler;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import de.markusbordihn.scraptechworkshop.recipe.recycler.RecyclerRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class RecyclerRecipeSerializer
implements RecipeSerializer<RecyclerRecipe> {
    public static final RecyclerRecipeSerializer INSTANCE = new RecyclerRecipeSerializer();
    private static final String MATCH_FIELD = "match";
    private static final String PRIMARY_OUTPUT_FIELD = "primary_output";
    private static final String BYPRODUCTS_FIELD = "byproducts";
    private static final String PROCESS_TIME_FIELD = "process_time";
    private static final String WEIGHT_FIELD = "weight";
    private static final String ITEM_FIELD = "item";
    private static final String TAG_FIELD = "tag";
    private static final String COUNT_FIELD = "count";
    private static final String MIN_FIELD = "min";
    private static final String MAX_FIELD = "max";
    private static final String DURABILITY_SCALING_FIELD = "durability_scaling";
    private static final String CHANCE_FIELD = "chance";
    private static final int DEFAULT_WEIGHT = 0;
    private static final int DEFAULT_MIN_COUNT = 1;
    private static final int DEFAULT_MAX_COUNT = 3;
    private static final int DEFAULT_PROCESS_TIME_SECONDS = 10;
    private static final double DEFAULT_CHANCE = 0.0;
    private static final boolean DEFAULT_DURABILITY_SCALING = false;

    private RecyclerRecipeSerializer() {
    }

    public RecyclerRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
        JsonObject matchJson = GsonHelper.m_13930_((JsonObject)json, (String)MATCH_FIELD);
        RecyclerRecipe.RecyclerMatch match = this.parseMatch(matchJson);
        JsonObject primaryOutputJson = GsonHelper.m_13930_((JsonObject)json, (String)PRIMARY_OUTPUT_FIELD);
        RecyclerRecipe.RecyclerOutput primaryOutput = this.parseOutput(primaryOutputJson);
        ArrayList<RecyclerRecipe.RecyclerByproduct> byproducts = new ArrayList<RecyclerRecipe.RecyclerByproduct>();
        if (json.has(BYPRODUCTS_FIELD)) {
            JsonArray byproductsArray = GsonHelper.m_13933_((JsonObject)json, (String)BYPRODUCTS_FIELD);
            for (int i = 0; i < byproductsArray.size(); ++i) {
                JsonObject byproductJson = byproductsArray.get(i).getAsJsonObject();
                byproducts.add(this.parseByproduct(byproductJson));
            }
        }
        int processTime = GsonHelper.m_13824_((JsonObject)json, (String)PROCESS_TIME_FIELD, (int)10) * 20;
        int weight = GsonHelper.m_13824_((JsonObject)json, (String)WEIGHT_FIELD, (int)0);
        return new RecyclerRecipe(recipeId, match, primaryOutput, byproducts, processTime, weight);
    }

    private RecyclerRecipe.RecyclerMatch parseMatch(JsonObject matchJson) {
        if (matchJson.has(ITEM_FIELD)) {
            String itemId = GsonHelper.m_13906_((JsonObject)matchJson, (String)ITEM_FIELD);
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(itemId));
            return new RecyclerRecipe.RecyclerMatch(item);
        }
        if (matchJson.has(TAG_FIELD)) {
            String tagId = GsonHelper.m_13906_((JsonObject)matchJson, (String)TAG_FIELD);
            TagKey tag = TagKey.m_203882_((ResourceKey)BuiltInRegistries.f_257033_.m_123023_(), (ResourceLocation)new ResourceLocation(tagId));
            return new RecyclerRecipe.RecyclerMatch((TagKey<Item>)tag);
        }
        throw new IllegalArgumentException("Match must have either 'item' or 'tag'");
    }

    private RecyclerRecipe.RecyclerOutput parseOutput(JsonObject outputJson) {
        String itemId = GsonHelper.m_13906_((JsonObject)outputJson, (String)ITEM_FIELD);
        Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(itemId));
        int minCount = 1;
        int maxCount = 3;
        if (outputJson.has(COUNT_FIELD)) {
            minCount = maxCount = GsonHelper.m_13927_((JsonObject)outputJson, (String)COUNT_FIELD);
        } else if (outputJson.has(MIN_FIELD) || outputJson.has(MAX_FIELD)) {
            minCount = GsonHelper.m_13824_((JsonObject)outputJson, (String)MIN_FIELD, (int)1);
            maxCount = GsonHelper.m_13824_((JsonObject)outputJson, (String)MAX_FIELD, (int)3);
        }
        boolean durabilityScaling = GsonHelper.m_13855_((JsonObject)outputJson, (String)DURABILITY_SCALING_FIELD, (boolean)false);
        return new RecyclerRecipe.RecyclerOutput(item, minCount, maxCount, durabilityScaling);
    }

    private RecyclerRecipe.RecyclerByproduct parseByproduct(JsonObject byproductJson) {
        String itemId = GsonHelper.m_13906_((JsonObject)byproductJson, (String)ITEM_FIELD);
        Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(itemId));
        double chance = GsonHelper.m_144742_((JsonObject)byproductJson, (String)CHANCE_FIELD, (double)0.0);
        int minCount = 1;
        int maxCount = 1;
        if (byproductJson.has(COUNT_FIELD)) {
            minCount = maxCount = GsonHelper.m_13927_((JsonObject)byproductJson, (String)COUNT_FIELD);
        } else if (byproductJson.has(MIN_FIELD) || byproductJson.has(MAX_FIELD)) {
            minCount = GsonHelper.m_13824_((JsonObject)byproductJson, (String)MIN_FIELD, (int)1);
            maxCount = GsonHelper.m_13824_((JsonObject)byproductJson, (String)MAX_FIELD, (int)minCount);
        }
        return new RecyclerRecipe.RecyclerByproduct(item, chance, minCount, maxCount);
    }

    public RecyclerRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        RecyclerRecipe.RecyclerMatch match;
        boolean isItemMatch = buffer.readBoolean();
        if (isItemMatch) {
            Item item = (Item)buffer.m_236816_((IdMap)BuiltInRegistries.f_257033_);
            match = new RecyclerRecipe.RecyclerMatch(item);
        } else {
            ResourceLocation tagId = buffer.m_130281_();
            TagKey tag = TagKey.m_203882_((ResourceKey)BuiltInRegistries.f_257033_.m_123023_(), (ResourceLocation)tagId);
            match = new RecyclerRecipe.RecyclerMatch((TagKey<Item>)tag);
        }
        Item primaryItem = (Item)buffer.m_236816_((IdMap)BuiltInRegistries.f_257033_);
        int minCount = buffer.m_130242_();
        int maxCount = buffer.m_130242_();
        boolean durabilityScaling = buffer.readBoolean();
        RecyclerRecipe.RecyclerOutput primaryOutput = new RecyclerRecipe.RecyclerOutput(primaryItem, minCount, maxCount, durabilityScaling);
        int byproductCount = buffer.m_130242_();
        ArrayList<RecyclerRecipe.RecyclerByproduct> byproducts = new ArrayList<RecyclerRecipe.RecyclerByproduct>();
        for (int i = 0; i < byproductCount; ++i) {
            Item byproductItem = (Item)buffer.m_236816_((IdMap)BuiltInRegistries.f_257033_);
            double chance = buffer.readDouble();
            int byproductMin = buffer.m_130242_();
            int byproductMax = buffer.m_130242_();
            byproducts.add(new RecyclerRecipe.RecyclerByproduct(byproductItem, chance, byproductMin, byproductMax));
        }
        int processTime = buffer.m_130242_();
        int weight = buffer.m_130242_();
        return new RecyclerRecipe(recipeId, match, primaryOutput, byproducts, processTime, weight);
    }

    public void toNetwork(FriendlyByteBuf buffer, RecyclerRecipe recipe) {
        RecyclerRecipe.RecyclerMatch match = recipe.match();
        buffer.writeBoolean(match.isItemMatch());
        if (match.isItemMatch()) {
            buffer.m_236818_((IdMap)BuiltInRegistries.f_257033_, (Object)match.getItem());
        } else {
            buffer.m_130085_(match.getTag().f_203868_());
        }
        RecyclerRecipe.RecyclerOutput primaryOutput = recipe.primaryOutput();
        buffer.m_236818_((IdMap)BuiltInRegistries.f_257033_, (Object)primaryOutput.getItem());
        buffer.m_130130_(primaryOutput.getMinCount());
        buffer.m_130130_(primaryOutput.getMaxCount());
        buffer.writeBoolean(primaryOutput.isDurabilityScaling());
        List<RecyclerRecipe.RecyclerByproduct> byproducts = recipe.byproducts();
        buffer.m_130130_(byproducts.size());
        for (RecyclerRecipe.RecyclerByproduct byproduct : byproducts) {
            buffer.m_236818_((IdMap)BuiltInRegistries.f_257033_, (Object)byproduct.getItem());
            buffer.writeDouble(byproduct.getChance());
            buffer.m_130130_(byproduct.getMinCount());
            buffer.m_130130_(byproduct.getMaxCount());
        }
        buffer.m_130130_(recipe.processTime());
        buffer.m_130130_(recipe.weight());
    }
}

