/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.spawner;

import de.markusbordihn.scraptechworkshop.block.ScrapPileBlock;
import de.markusbordihn.scraptechworkshop.config.ScrapPileConfig;
import de.markusbordihn.scraptechworkshop.data.ScrapPileVariant;
import de.markusbordihn.scraptechworkshop.registry.block.ScrapPileBlockRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScrapPileSpawner {
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final Map<ChunkPos, Integer> chunkScrapCounts = new ConcurrentHashMap<ChunkPos, Integer>();
    private static final Map<ChunkPos, Long> chunkCountTimestamps = new ConcurrentHashMap<ChunkPos, Long>();
    private static final Map<ChunkPos, Long> chunkPlayerActivity = new ConcurrentHashMap<ChunkPos, Long>();
    private static final long CACHE_VALIDITY_MS = 30000L;
    private static final long ACTIVITY_VALIDITY_MS = 300000L;
    private static int tickCounter = 0;

    protected ScrapPileSpawner() {
    }

    public static void tick(MinecraftServer minecraftServer) {
        if (ScrapPileConfig.spawnIntervalTicks <= 0) {
            return;
        }
        if (++tickCounter >= ScrapPileConfig.spawnIntervalTicks) {
            tickCounter = 0;
            ScrapPileSpawner.cleanupExpiredCache();
            for (ServerLevel level : minecraftServer.m_129785_()) {
                try {
                    ScrapPileSpawner.tick(level);
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void tick(ServerLevel level) {
        if (!ScrapPileConfig.spawnEnabled || level.m_6907_().isEmpty()) {
            return;
        }
        int attemptsThisTick = ScrapPileSpawner.getAdaptiveSpawnAttempts(level);
        for (int i = 0; i < attemptsThisTick; ++i) {
            try {
                ScrapPileSpawner.trySpawnScrapPile(level);
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
    }

    private static void cleanupExpiredCache() {
        long currentTime = System.currentTimeMillis();
        chunkCountTimestamps.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > 30000L);
        chunkScrapCounts.keySet().removeIf(chunkPos -> !chunkCountTimestamps.containsKey(chunkPos));
        chunkPlayerActivity.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > 300000L);
    }

    private static int getAdaptiveSpawnAttempts(ServerLevel level) {
        int baseAttempts = ScrapPileConfig.spawnAttemptsPerTick;
        double mspt = level.m_7654_().m_129903_();
        if (mspt > 40.0) {
            return Math.max(1, baseAttempts / 4);
        }
        if (mspt > 30.0) {
            return Math.max(1, baseAttempts / 2);
        }
        if (mspt > 20.0) {
            return Math.max(1, baseAttempts * 3 / 4);
        }
        return baseAttempts;
    }

    private static void trySpawnScrapPile(ServerLevel level) {
        BlockPos spawnPos;
        ChunkPos targetChunk;
        int offsetZ;
        int offsetX;
        int attempts;
        if (level.m_6907_().isEmpty()) {
            return;
        }
        ServerPlayer randomPlayer = (ServerPlayer)level.m_6907_().get(level.f_46441_.m_188503_(level.m_6907_().size()));
        ChunkPos playerChunk = new ChunkPos(randomPlayer.m_20183_());
        for (attempts = 0; attempts < 3; ++attempts) {
            offsetX = level.f_46441_.m_188503_(17) - 8;
            offsetZ = level.f_46441_.m_188503_(17) - 8;
            targetChunk = new ChunkPos(playerChunk.f_45578_ + offsetX, playerChunk.f_45579_ + offsetZ);
            if (!level.m_7232_(targetChunk.f_45578_, targetChunk.f_45579_) || ScrapPileSpawner.getCachedScrapPileCount(level, targetChunk) >= ScrapPileConfig.spawnChunkCap || !ScrapPileSpawner.hasRecentPlayerActivity(targetChunk) || (spawnPos = ScrapPileSpawner.findSuitableSpawnLocation(level, targetChunk)) == null) continue;
            ScrapPileSpawner.spawnScrapPile(level, spawnPos);
            ScrapPileSpawner.incrementChunkCount(targetChunk);
            return;
        }
        for (attempts = 0; attempts < 3; ++attempts) {
            offsetX = level.f_46441_.m_188503_(17) - 8;
            offsetZ = level.f_46441_.m_188503_(17) - 8;
            targetChunk = new ChunkPos(playerChunk.f_45578_ + offsetX, playerChunk.f_45579_ + offsetZ);
            if (!level.m_7232_(targetChunk.f_45578_, targetChunk.f_45579_) || ScrapPileSpawner.getCachedScrapPileCount(level, targetChunk) >= ScrapPileConfig.spawnChunkCap || (spawnPos = ScrapPileSpawner.findSuitableSpawnLocation(level, targetChunk)) == null) continue;
            ScrapPileSpawner.spawnScrapPile(level, spawnPos);
            ScrapPileSpawner.incrementChunkCount(targetChunk);
            return;
        }
    }

    private static int getCachedScrapPileCount(ServerLevel level, ChunkPos chunkPos) {
        long currentTime = System.currentTimeMillis();
        Long cacheTime = chunkCountTimestamps.get(chunkPos);
        if (cacheTime != null && currentTime - cacheTime < 30000L) {
            return chunkScrapCounts.getOrDefault(chunkPos, 0);
        }
        int count = ScrapPileSpawner.countScrapPilesInChunk(level, chunkPos);
        chunkScrapCounts.put(chunkPos, count);
        chunkCountTimestamps.put(chunkPos, currentTime);
        return count;
    }

    private static void incrementChunkCount(ChunkPos chunkPos) {
        chunkScrapCounts.merge(chunkPos, 1, Integer::sum);
        chunkCountTimestamps.put(chunkPos, System.currentTimeMillis());
    }

    public static void decrementChunkCount(ChunkPos chunkPos) {
        Integer current = chunkScrapCounts.get(chunkPos);
        if (current != null && current > 0) {
            chunkScrapCounts.put(chunkPos, current - 1);
            chunkCountTimestamps.put(chunkPos, System.currentTimeMillis());
        }
    }

    public static void recordPlayerActivity(ChunkPos chunkPos) {
        chunkPlayerActivity.put(chunkPos, System.currentTimeMillis());
    }

    private static boolean hasRecentPlayerActivity(ChunkPos chunkPos) {
        Long lastActivity = chunkPlayerActivity.get(chunkPos);
        if (lastActivity == null) {
            return false;
        }
        return System.currentTimeMillis() - lastActivity < 300000L;
    }

    private static int countScrapPilesInChunk(ServerLevel level, ChunkPos chunkPos) {
        if (!level.m_7232_(chunkPos.f_45578_, chunkPos.f_45579_)) {
            return 0;
        }
        int count = 0;
        int startX = chunkPos.m_45604_();
        int startZ = chunkPos.m_45605_();
        int endX = chunkPos.m_45608_();
        int endZ = chunkPos.m_45609_();
        try {
            for (int x = startX; x <= endX; x += 8) {
                for (int z = startZ; z <= endZ; z += 8) {
                    for (int y = level.m_141937_(); y <= ScrapPileConfig.spawnYMax; y += 8) {
                        BlockPos pos = new BlockPos(x, y, z);
                        if (!(level.m_8055_(pos).m_60734_() instanceof ScrapPileBlock)) continue;
                        ++count;
                    }
                }
            }
        }
        catch (Exception e) {
            return 0;
        }
        return count;
    }

    private static BlockPos findSuitableSpawnLocation(ServerLevel level, ChunkPos chunkPos) {
        RandomSource random = level.f_46441_;
        for (int attempt = 0; attempt < 6; ++attempt) {
            int startY;
            int x = chunkPos.m_45604_() + random.m_188503_(16);
            int z = chunkPos.m_45605_() + random.m_188503_(16);
            int maxY = Math.min(ScrapPileConfig.spawnYMax, level.m_151558_() - 1);
            for (int y = startY = random.m_188503_(Math.max(1, maxY - level.m_141937_())) + level.m_141937_(); y <= maxY; ++y) {
                BlockPos pos = new BlockPos(x, y, z);
                try {
                    if (!ScrapPileSpawner.isSuitableSpawnLocation(level, pos)) continue;
                    return pos;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private static boolean isSuitableSpawnLocation(ServerLevel level, BlockPos blockPos) {
        try {
            BlockState groundState = level.m_8055_(blockPos.m_7495_());
            BlockState airState = level.m_8055_(blockPos);
            if (!groundState.m_204336_(BlockTags.f_13061_) && !groundState.m_204336_(BlockTags.f_144267_)) {
                return false;
            }
            if (!airState.m_60795_() && airState.m_60819_().m_76152_() != Fluids.f_76193_) {
                return false;
            }
            if (blockPos.m_123342_() > ScrapPileConfig.spawnYMax) {
                return false;
            }
            if (ScrapPileConfig.spawnDarknessRequired && level.m_45517_(LightLayer.BLOCK, blockPos) > 7) {
                return false;
            }
            return level.m_6907_().stream().noneMatch(player -> player.m_20275_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()) < 196.0);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void spawnScrapPile(ServerLevel level, BlockPos blockPos) {
        try {
            RandomSource random = level.f_46441_;
            ScrapPileVariant variant = ScrapPileSpawner.getRandomVariant(random, level, blockPos);
            int size = random.m_188501_() < 0.75f ? 1 : (random.m_188501_() < 0.8f ? 2 : 3);
            boolean waterlogged = level.m_8055_(blockPos).m_60819_().m_76152_() == Fluids.f_76193_;
            BlockState scrapPileState = (BlockState)((BlockState)((BlockState)ScrapPileBlockRegistry.SCRAP_PILE_BLOCK.m_49966_().m_61124_((Property)ScrapPileBlock.SIZE, (Comparable)Integer.valueOf(size))).m_61124_(ScrapPileBlock.VARIANT, (Comparable)((Object)variant))).m_61124_((Property)ScrapPileBlock.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
            level.m_7731_(blockPos, scrapPileState, 3);
            if (log.isDebugEnabled()) {
                log.debug("Spawned scrap pile at {} in dimension {} - Size: {}, Variant: {}, Waterlogged: {}", (Object)blockPos, (Object)level.m_46472_().m_135782_(), (Object)size, (Object)variant, (Object)waterlogged);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static ScrapPileVariant getRandomVariant(RandomSource random, ServerLevel serverLevel, BlockPos blockPos) {
        int depth = blockPos.m_123342_();
        if (depth < -32) {
            float rand = random.m_188501_();
            if (rand < 0.2f) {
                return ScrapPileVariant.MIXED;
            }
            if (rand < 0.4f) {
                return ScrapPileVariant.METAL;
            }
            return ScrapPileVariant.TECH;
        }
        if (depth < 0) {
            float rand = random.m_188501_();
            if (rand < 0.3f) {
                return ScrapPileVariant.MIXED;
            }
            if (rand < 0.7f) {
                return ScrapPileVariant.METAL;
            }
            return ScrapPileVariant.TECH;
        }
        float rand = random.m_188501_();
        if (rand < 0.6f) {
            return ScrapPileVariant.MIXED;
        }
        if (rand < 0.85f) {
            return ScrapPileVariant.METAL;
        }
        return ScrapPileVariant.TECH;
    }
}

