/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.data.scrap;

import de.markusbordihn.scraptechworkshop.data.scrap.ScrapType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public enum ScrapSoundType {
    STONE(SoundEvents.f_12442_),
    METAL(SoundEvents.f_144117_),
    CRYSTAL(SoundEvents.f_144050_),
    CHAIN(SoundEvents.f_11794_),
    ANVIL(SoundEvents.f_11668_),
    IRON(SoundEvents.f_12011_),
    GLASS(SoundEvents.f_11983_),
    SOFT(SoundEvents.f_12639_),
    ELECTRONIC(SoundEvents.f_12374_),
    WOOD(SoundEvents.f_12630_),
    SLIME(SoundEvents.f_12389_);

    private static final Map<ScrapType, ScrapSoundType> SCRAP_TYPE_TO_SOUND_MAP;
    private final SoundEvent soundEvent;

    private ScrapSoundType(SoundEvent soundEvent) {
        this.soundEvent = soundEvent;
    }

    public static ScrapSoundType forScrapType(ScrapType scrapType) {
        return SCRAP_TYPE_TO_SOUND_MAP.get((Object)scrapType);
    }

    public SoundEvent getSoundEvent() {
        return this.soundEvent;
    }

    static {
        HashMap<ScrapType, ScrapSoundType> map = new HashMap<ScrapType, ScrapSoundType>();
        map.put(ScrapType.BIO, SOFT);
        map.put(ScrapType.CERAMIC, STONE);
        map.put(ScrapType.COPPER, METAL);
        map.put(ScrapType.CRYSTAL, CRYSTAL);
        map.put(ScrapType.FASTENER, CHAIN);
        map.put(ScrapType.FIBER, SOFT);
        map.put(ScrapType.GLASS, GLASS);
        map.put(ScrapType.GOLD, ANVIL);
        map.put(ScrapType.IRON, IRON);
        map.put(ScrapType.LUMINOUS, GLASS);
        map.put(ScrapType.METAL, METAL);
        map.put(ScrapType.MINERAL, STONE);
        map.put(ScrapType.PLASTIC, SOFT);
        map.put(ScrapType.RUBBER, SLIME);
        map.put(ScrapType.TECH, ELECTRONIC);
        map.put(ScrapType.WOOD, WOOD);
        SCRAP_TYPE_TO_SOUND_MAP = Map.copyOf(map);
    }
}

