/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.item;

import de.markusbordihn.scraptechworkshop.block.ForgeModBlocks;
import de.markusbordihn.scraptechworkshop.data.ScrapPileVariant;
import de.markusbordihn.scraptechworkshop.item.CollectorStationBlockItem;
import de.markusbordihn.scraptechworkshop.item.FloatingScrapCollectorBlockItem;
import de.markusbordihn.scraptechworkshop.item.ModBlockItems;
import de.markusbordihn.scraptechworkshop.item.RechargeStationBlockItem;
import de.markusbordihn.scraptechworkshop.item.RecyclerBlockItem;
import de.markusbordihn.scraptechworkshop.item.ScrapPileBlockItem;
import de.markusbordihn.scraptechworkshop.registry.item.hololog.HoloLogItemRegistry;
import de.markusbordihn.scraptechworkshop.registry.item.hololog.HoloLogRegistry;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ForgeModBlockItems {
    public static final DeferredRegister<Item> BLOCK_ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"scrap_tech_workshop");
    public static final RegistryObject<BlockItem> RECYCLER_BLOCK_ITEM = BLOCK_ITEMS.register("recycler", () -> new RecyclerBlockItem((Block)ForgeModBlocks.RECYCLER_BLOCK.get(), new Item.Properties()));
    public static final RegistryObject<BlockItem> RECHARGE_STATION_BLOCK_ITEM = BLOCK_ITEMS.register("recharge_station", () -> new RechargeStationBlockItem((Block)ForgeModBlocks.RECHARGE_STATION_BLOCK.get(), new Item.Properties()));
    public static final RegistryObject<BlockItem> BASIC_SCRAP_COLLECTOR_STATION_BLOCK_ITEM = BLOCK_ITEMS.register("basic_scrap_collector_station", () -> new CollectorStationBlockItem((Block)ForgeModBlocks.BASIC_SCRAP_COLLECTOR_STATION_BLOCK.get(), new Item.Properties()));
    public static final RegistryObject<BlockItem> FLOATING_SCRAP_COLLECTOR_BLOCK_ITEM = BLOCK_ITEMS.register("floating_scrap_collector", () -> new FloatingScrapCollectorBlockItem((Block)ForgeModBlocks.FLOATING_SCRAP_COLLECTOR_BLOCK.get(), new Item.Properties()));
    public static final RegistryObject<BlockItem> NEON_TUBE_BLOCK_ITEM = BLOCK_ITEMS.register("neon_tube", () -> new BlockItem((Block)ForgeModBlocks.NEON_TUBE_BLOCK.get(), new Item.Properties()));
    public static final RegistryObject<BlockItem> MIXED_SCRAP_PILE_BLOCK_ITEM = BLOCK_ITEMS.register("mixed_scrap_pile", () -> new ScrapPileBlockItem((Block)ForgeModBlocks.SCRAP_PILE_BLOCK.get(), new Item.Properties(), ScrapPileVariant.MIXED));
    public static final RegistryObject<BlockItem> METAL_SCRAP_PILE_BLOCK_ITEM = BLOCK_ITEMS.register("metal_scrap_pile", () -> new ScrapPileBlockItem((Block)ForgeModBlocks.SCRAP_PILE_BLOCK.get(), new Item.Properties(), ScrapPileVariant.METAL));
    public static final RegistryObject<BlockItem> TECH_SCRAP_PILE_BLOCK_ITEM = BLOCK_ITEMS.register("tech_scrap_pile", () -> new ScrapPileBlockItem((Block)ForgeModBlocks.SCRAP_PILE_BLOCK.get(), new Item.Properties(), ScrapPileVariant.TECH));
    private static final Map<String, RegistryObject<BlockItem>> HOLO_CUBE_REGISTRY_OBJECTS = new LinkedHashMap<String, RegistryObject<BlockItem>>();

    private ForgeModBlockItems() {
    }

    public static void register(IEventBus eventBus) {
        BLOCK_ITEMS.register(eventBus);
        ModBlockItems.RECYCLER = RECYCLER_BLOCK_ITEM;
        ModBlockItems.RECHARGE_STATION = RECHARGE_STATION_BLOCK_ITEM;
        ModBlockItems.BASIC_SCRAP_COLLECTOR_STATION = BASIC_SCRAP_COLLECTOR_STATION_BLOCK_ITEM;
        ModBlockItems.FLOATING_SCRAP_COLLECTOR = FLOATING_SCRAP_COLLECTOR_BLOCK_ITEM;
        ModBlockItems.NEON_TUBE = NEON_TUBE_BLOCK_ITEM;
        ModBlockItems.MIXED_SCRAP_PILE = MIXED_SCRAP_PILE_BLOCK_ITEM;
        ModBlockItems.METAL_SCRAP_PILE = METAL_SCRAP_PILE_BLOCK_ITEM;
        ModBlockItems.TECH_SCRAP_PILE = TECH_SCRAP_PILE_BLOCK_ITEM;
        if (!HOLO_CUBE_REGISTRY_OBJECTS.isEmpty()) {
            ModBlockItems.HOLO_CUBE = (Supplier)HOLO_CUBE_REGISTRY_OBJECTS.values().iterator().next();
        }
    }

    static {
        for (Map.Entry<String, ResourceLocation> entry : HoloLogRegistry.getHoloCubeRegistry().entrySet()) {
            String itemId = entry.getKey();
            ResourceLocation holoLogId = entry.getValue();
            RegistryObject registryObject = BLOCK_ITEMS.register("holo_cube_" + itemId, HoloLogItemRegistry.createHoloCubeSupplier(itemId, holoLogId));
            HOLO_CUBE_REGISTRY_OBJECTS.put(itemId, (RegistryObject<BlockItem>)registryObject);
        }
    }
}

