/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.block.entity;

import de.markusbordihn.scraptechworkshop.block.hololog.HoloCubeBlock;
import de.markusbordihn.scraptechworkshop.client.hololog.HolologPlayer;
import de.markusbordihn.scraptechworkshop.data.hololog.HolologData;
import de.markusbordihn.scraptechworkshop.data.hololog.HolologParser;
import de.markusbordihn.scraptechworkshop.data.hololog.HolologPlaybackContext;
import de.markusbordihn.scraptechworkshop.data.hololog.HolologStatus;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HoloCubeBlockEntity
extends class_2586 {
    public static final String ID = "holocube";
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final String CUBE_UUID_TAG = "CubeUUID";
    private static final String HOLOLOG_ID_TAG = "HolologId";
    private static final String PLAYER_UUID_TAG = "PlayerUUID";
    private static final String LAST_STATUS_TAG = "LastStatus";
    private static final String ENDED_TICK_TAG = "EndedTick";
    private static final class_2960 DEFAULT_HOLOLOG = new class_2960("scrap_tech_workshop", "holologs/intro/introduction");
    private static final double MAX_PLAYER_DISTANCE = 32.0;
    private static final int AUTO_RESET_TICKS = 20;
    public static class_2591<HoloCubeBlockEntity> TYPE;
    private UUID cubeUUID;
    private class_2960 holologId;
    private UUID playerUUID;
    private UUID currentPlayerId;
    private HolologStatus lastKnownStatus = HolologStatus.READY;
    private long endedAtTick = -1L;

    public HoloCubeBlockEntity(class_2338 pos, class_2680 state) {
        super(TYPE, pos, state);
        this.cubeUUID = UUID.randomUUID();
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, HoloCubeBlockEntity blockEntity) {
        if (!level.field_9236) {
            return;
        }
        HolologStatus status = (HolologStatus)((Object)state.method_11654(HoloCubeBlock.STATUS));
        class_2960 holologId = blockEntity.getHolologId();
        if (holologId == null) {
            if (status != HolologStatus.READY) {
                log.warn("[{}] Hololog ID is null but status is {}, resetting to READY", (Object)blockEntity.cubeUUID, (Object)status);
                HoloCubeBlock.updateStatus(level, pos, HolologStatus.READY);
            }
            return;
        }
        if (status == HolologStatus.ENDED) {
            if (blockEntity.endedAtTick < 0L) {
                blockEntity.endedAtTick = level.method_8510();
            } else if (level.method_8510() - blockEntity.endedAtTick > 20L) {
                log.debug("[{}] Auto-resetting from ENDED to READY", (Object)blockEntity.cubeUUID);
                HoloCubeBlock.updateStatus(level, pos, HolologStatus.READY);
                blockEntity.endedAtTick = -1L;
                blockEntity.stopPlayback();
            }
            return;
        }
        blockEntity.endedAtTick = -1L;
        boolean playerInRange = HoloCubeBlockEntity.hasNonSpectatorPlayerInRange(level, pos);
        if (status == HolologStatus.PLAYING) {
            log.trace("[{}] PLAYING - currentPlayerId: {}, playerInRange: {}", (Object)blockEntity.cubeUUID, (Object)blockEntity.currentPlayerId, (Object)playerInRange);
            if (!playerInRange && blockEntity.currentPlayerId != null) {
                log.debug("[{}] No player in range, stopping playback", (Object)blockEntity.cubeUUID);
                HoloCubeBlock.updateStatus(level, pos, HolologStatus.READY);
                blockEntity.stopPlayback();
                return;
            }
            if (blockEntity.currentPlayerId == null && playerInRange) {
                log.info("[{}] Starting playback for hololog: {}", (Object)blockEntity.cubeUUID, (Object)holologId);
                blockEntity.startPlayback(level, pos, holologId);
            }
        } else if (status == HolologStatus.READY && blockEntity.currentPlayerId != null) {
            blockEntity.stopPlayback();
        }
        blockEntity.lastKnownStatus = status;
    }

    private static boolean hasNonSpectatorPlayerInRange(class_1937 level, class_2338 pos) {
        return level.method_18456().stream().filter(player -> !player.method_7325()).anyMatch(player -> {
            boolean inRange;
            double distance = player.method_5649((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
            boolean bl = inRange = distance <= 1024.0;
            if (log.isTraceEnabled()) {
                log.trace("Player {} at distance {:.2f} blocks (max: {}): {}", (Object)player.method_5477().getString(), (Object)Math.sqrt(distance), (Object)32.0, (Object)(inRange ? "IN RANGE" : "out of range"));
            }
            return inRange;
        });
    }

    private void startPlayback(class_1937 level, class_2338 pos, class_2960 holologId) {
        log.info("[{}] startPlayback() called for hololog: {}", (Object)this.cubeUUID, (Object)holologId);
        if (holologId == null) {
            log.error("[{}] Cannot start playback: holologId is null", (Object)this.cubeUUID);
            return;
        }
        if (!level.field_9236) {
            log.error("[{}] startPlayback() called on server side - this should never happen!", (Object)this.cubeUUID);
            return;
        }
        class_2960 localizedId = HolologParser.getLocalizedId(holologId);
        log.debug("[{}] Localized hololog ID: {}", (Object)this.cubeUUID, (Object)localizedId);
        Optional<HolologData> holologData = HolologParser.getHololog(localizedId);
        if (holologData.isEmpty()) {
            log.error("[{}] Failed to load hololog data for: {} (localized: {})", (Object)this.cubeUUID, (Object)holologId, (Object)localizedId);
            HoloCubeBlock.updateStatus(level, pos, HolologStatus.READY);
            return;
        }
        HolologData data = holologData.get();
        if (data.lines().isEmpty()) {
            log.error("[{}] Hololog has no lines: {}", (Object)this.cubeUUID, (Object)localizedId);
            HoloCubeBlock.updateStatus(level, pos, HolologStatus.READY);
            return;
        }
        log.info("[{}] Hololog loaded successfully: {} (lines: {}, default delay: {})", (Object)this.cubeUUID, (Object)localizedId, (Object)data.lines().size(), (Object)data.lineDelayTicks());
        HolologPlaybackContext.WorldContext context = new HolologPlaybackContext.WorldContext(level, pos);
        this.currentPlayerId = HolologPlayer.play(data, context, text -> {
            class_746 player = class_310.method_1551().field_1724;
            if (player != null && !player.method_7325()) {
                player.method_7353((class_2561)class_2561.method_43470((String)("\u00a77[Hololog] \u00a7f" + text)), false);
            }
        }, () -> {
            log.info("[{}] Playback finished", (Object)this.cubeUUID);
            HoloCubeBlock.updateStatus(level, pos, HolologStatus.ENDED);
        });
        if (this.currentPlayerId == null) {
            log.error("[{}] HolologPlayer.play() returned null player ID!", (Object)this.cubeUUID);
            HoloCubeBlock.updateStatus(level, pos, HolologStatus.READY);
        } else {
            log.info("[{}] Playback started with player ID: {}", (Object)this.cubeUUID, (Object)this.currentPlayerId);
        }
    }

    private void stopPlayback() {
        if (this.currentPlayerId != null) {
            log.debug("[{}] Stopping playback", (Object)this.cubeUUID);
            HolologPlayer.stop(this.currentPlayerId);
            this.currentPlayerId = null;
        }
    }

    public void cleanup() {
        this.stopPlayback();
    }

    public void method_11012() {
        super.method_11012();
        this.cleanup();
    }

    public UUID getCubeUUID() {
        return this.cubeUUID;
    }

    public class_2960 getHolologId() {
        return this.holologId != null ? this.holologId : DEFAULT_HOLOLOG;
    }

    public void setHolologId(class_2960 holologId) {
        log.debug("[{}] Setting hololog ID to: {}", (Object)this.cubeUUID, (Object)holologId);
        this.holologId = holologId;
        this.method_5431();
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public void setPlayerUUID(UUID playerUUID) {
        log.debug("[{}] Setting player UUID to: {}", (Object)this.cubeUUID, (Object)playerUUID);
        this.playerUUID = playerUUID;
        this.method_5431();
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        if (tag.method_10545(CUBE_UUID_TAG)) {
            this.cubeUUID = tag.method_25926(CUBE_UUID_TAG);
        }
        if (tag.method_10545(HOLOLOG_ID_TAG)) {
            try {
                this.holologId = new class_2960(tag.method_10558(HOLOLOG_ID_TAG));
            }
            catch (Exception e) {
                log.warn("[{}] Failed to load hololog ID: {}", (Object)this.cubeUUID, (Object)e.getMessage());
                this.holologId = DEFAULT_HOLOLOG;
            }
        }
        if (tag.method_10545(PLAYER_UUID_TAG)) {
            this.playerUUID = tag.method_25926(PLAYER_UUID_TAG);
        }
        if (tag.method_10545(LAST_STATUS_TAG)) {
            try {
                this.lastKnownStatus = HolologStatus.valueOf(tag.method_10558(LAST_STATUS_TAG).toUpperCase());
            }
            catch (Exception e) {
                log.warn("[{}] Failed to load last status: {}", (Object)this.cubeUUID, (Object)e.getMessage());
                this.lastKnownStatus = HolologStatus.READY;
            }
        }
        if (tag.method_10545(ENDED_TICK_TAG)) {
            this.endedAtTick = tag.method_10537(ENDED_TICK_TAG);
        }
        log.debug("[{}] Loaded HoloCube data", (Object)this.cubeUUID);
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_25927(CUBE_UUID_TAG, this.cubeUUID);
        tag.method_10582(LAST_STATUS_TAG, this.lastKnownStatus.name());
        tag.method_10544(ENDED_TICK_TAG, this.endedAtTick);
        if (this.holologId != null) {
            tag.method_10582(HOLOLOG_ID_TAG, this.holologId.toString());
        }
        if (this.playerUUID != null) {
            tag.method_25927(PLAYER_UUID_TAG, this.playerUUID);
        }
    }

    public class_2487 method_16887() {
        class_2487 tag = super.method_16887();
        this.method_11007(tag);
        return tag;
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    private void syncToClient() {
        class_1937 currentLevel = this.field_11863;
        if (currentLevel != null && !currentLevel.field_9236) {
            currentLevel.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
        }
    }

    public void method_5431() {
        super.method_5431();
        this.syncToClient();
    }
}

