/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.block.hololog;

import de.markusbordihn.scraptechworkshop.block.entity.HoloCubeBlockEntity;
import de.markusbordihn.scraptechworkshop.data.hololog.HolologStatus;
import de.markusbordihn.scraptechworkshop.item.hololog.HoloCubeItem;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HoloCubeBlock
extends class_2237 {
    public static final String ID = "holocube";
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2754<HolologStatus> STATUS = class_2754.method_11850((String)"status", HolologStatus.class);
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final class_265 SHAPE = class_259.method_1081((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)0.375, (double)0.6875);

    public HoloCubeBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657(STATUS, (Comparable)((Object)HolologStatus.READY)));
    }

    public static void updateStatus(class_1937 level, class_2338 pos, HolologStatus newStatus) {
        class_2680 currentState = level.method_8320(pos);
        if (currentState.method_26204() instanceof HoloCubeBlock && currentState.method_11654(STATUS) != newStatus) {
            level.method_8652(pos, (class_2680)currentState.method_11657(STATUS, (Comparable)((Object)newStatus)), 3);
        }
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, STATUS});
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new HoloCubeBlockEntity(pos, state);
    }

    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
        return level.field_9236 ? HoloCubeBlock.method_31618(type, HoloCubeBlockEntity.TYPE, HoloCubeBlockEntity::tick) : null;
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        double distance;
        if (level.field_9236) {
            return class_1269.field_5812;
        }
        class_2586 class_25862 = level.method_8321(pos);
        if (!(class_25862 instanceof HoloCubeBlockEntity)) {
            log.warn("No HoloCubeBlockEntity found at {}", (Object)pos);
            return class_1269.field_5814;
        }
        HoloCubeBlockEntity blockEntity = (HoloCubeBlockEntity)class_25862;
        class_2960 holologId = blockEntity.getHolologId();
        if (holologId == null) {
            player.method_7353((class_2561)class_2561.method_43470((String)"No hololog data found!"), true);
            log.warn("[{}] No hololog ID found", (Object)blockEntity.getCubeUUID());
            return class_1269.field_5814;
        }
        HolologStatus currentStatus = (HolologStatus)((Object)state.method_11654(STATUS));
        HolologStatus newStatus = currentStatus.cycle();
        if (currentStatus != HolologStatus.PLAYING && newStatus == HolologStatus.PLAYING && (distance = player.method_5649((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5)) > 1024.0) {
            player.method_7353((class_2561)class_2561.method_43470((String)"You must be within 32 blocks to activate the hololog!"), true);
            log.debug("[{}] Player {} too far away ({} blocks) to activate", (Object)blockEntity.getCubeUUID(), (Object)player.method_5477().getString(), (Object)Math.sqrt(distance));
            return class_1269.field_5814;
        }
        log.debug("[{}] Player {} changed status from {} to {}", (Object)blockEntity.getCubeUUID(), (Object)player.method_5477().getString(), (Object)currentStatus, (Object)newStatus);
        level.method_8652(pos, (class_2680)state.method_11657(STATUS, (Comparable)((Object)newStatus)), 3);
        return class_1269.field_5812;
    }

    public class_2680 method_9605(class_1750 context) {
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)context.method_8042().method_10153())).method_11657(STATUS, (Comparable)((Object)HolologStatus.READY));
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    public void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean isMoving) {
        if (!state.method_27852(newState.method_26204())) {
            class_2586 class_25862;
            if (level.field_9236 && (class_25862 = level.method_8321(pos)) instanceof HoloCubeBlockEntity) {
                HoloCubeBlockEntity blockEntity = (HoloCubeBlockEntity)class_25862;
                blockEntity.cleanup();
            }
            super.method_9536(state, level, pos, newState, isMoving);
        }
    }

    public void method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        HoloCubeBlockEntity blockEntity;
        class_2960 holologId;
        class_2586 class_25862;
        if (!level.field_9236 && !player.method_7337() && (class_25862 = level.method_8321(pos)) instanceof HoloCubeBlockEntity && (holologId = (blockEntity = (HoloCubeBlockEntity)class_25862).getHolologId()) != null) {
            class_1799 stack = HoloCubeItem.create(holologId);
            HoloCubeBlock.method_9577((class_1937)level, (class_2338)pos, (class_1799)stack);
        }
        super.method_9576(level, pos, state, player);
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
        super.method_9567(level, pos, state, placer, stack);
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof HoloCubeBlockEntity) {
            HoloCubeBlockEntity blockEntity = (HoloCubeBlockEntity)class_25862;
            class_2960 holologId = HoloCubeItem.getHolologId(stack);
            if (holologId != null) {
                blockEntity.setHolologId(holologId);
                log.info("[{}] Placed with hololog: {}", (Object)blockEntity.getCubeUUID(), (Object)holologId);
            } else {
                log.warn("[{}] Placed without hololog ID", (Object)blockEntity.getCubeUUID());
            }
        }
    }
}

