/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.hololog;

import de.markusbordihn.scraptechworkshop.client.hololog.HolologPlayerAudio;
import de.markusbordihn.scraptechworkshop.client.hololog.HolologPlayerEffects;
import de.markusbordihn.scraptechworkshop.client.hololog.HolologPlayerManager;
import de.markusbordihn.scraptechworkshop.data.hololog.HolologData;
import de.markusbordihn.scraptechworkshop.data.hololog.HolologPlaybackContext;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_638;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HolologPlayer {
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private final HolologData hololog;
    private final HolologPlaybackContext context;
    private final Consumer<String> textDisplay;
    private final Runnable onComplete;
    private final UUID playerId;
    private PlaybackState state = PlaybackState.STOPPED;
    private int currentLine = 0;
    private boolean endEffectsPlayed = false;
    private boolean voiceOverStarted = false;
    private int ticksForCurrentLine = 0;

    private HolologPlayer(HolologData hololog, HolologPlaybackContext context, Consumer<String> textDisplay, Runnable onComplete, UUID playerId) {
        this.hololog = hololog;
        this.context = context;
        this.textDisplay = textDisplay;
        this.onComplete = onComplete;
        this.playerId = playerId;
    }

    public static UUID play(HolologData hololog, HolologPlaybackContext context, Consumer<String> textDisplay) {
        return HolologPlayer.play(hololog, context, textDisplay, null);
    }

    public static UUID play(HolologData hololog, HolologPlaybackContext context, Consumer<String> textDisplay, Runnable onComplete) {
        UUID id = UUID.randomUUID();
        HolologPlayer player = new HolologPlayer(hololog, context, textDisplay, onComplete, id);
        UUID registeredId = HolologPlayerManager.register(player, hololog.id());
        if (HolologPlayerManager.get(registeredId) == player) {
            log.info("Player registered successfully with ID: {}, starting playback", (Object)registeredId);
            player.start();
        } else {
            log.warn("Player registration failed or duplicate detected for hololog: {}, ID: {}", (Object)hololog.id(), (Object)registeredId);
        }
        return registeredId;
    }

    public static void stop(UUID id) {
        HolologPlayer player = HolologPlayerManager.get(id);
        if (player != null) {
            player.stop();
            HolologPlayerAudio.stopVoiceOver(id);
            HolologPlayerManager.remove(id);
        }
    }

    public static int getCurrentLine(class_2960 holologId) {
        return HolologPlayerManager.getCurrentLine(holologId);
    }

    public static void stopAll() {
        HolologPlayerAudio.stopAll();
        HolologPlayerManager.stopAll();
    }

    public static void tickAll() {
        HolologPlayerManager.tickAll();
    }

    private void start() {
        this.state = PlaybackState.PLAYING;
        this.currentLine = 0;
        this.endEffectsPlayed = false;
        this.voiceOverStarted = false;
        this.ticksForCurrentLine = 0;
        log.info("Starting hololog playback: {} (lines: {}, default delay: {})", (Object)this.hololog.id(), (Object)this.hololog.lines().size(), (Object)this.hololog.lineDelayTicks());
        HolologPlayerEffects.playEffects(this.hololog.start(), this.context, this.context.getEffectPosition());
        if (this.textDisplay != null) {
            Object titleText = class_2561.method_43470((String)this.hololog.title()).getString();
            if (!this.hololog.subtitle().isEmpty()) {
                titleText = (String)titleText + " - " + this.hololog.subtitle();
            }
            this.textDisplay.accept((String)titleText);
            log.debug("Displayed title: {}", titleText);
        }
    }

    void tick() {
        if (this.state != PlaybackState.PLAYING) {
            return;
        }
        class_1937 level = this.context.getLevel();
        if (level == null || !(level instanceof class_638)) {
            log.warn("Level is null or not ClientLevel, stopping playback");
            this.state = PlaybackState.STOPPED;
            return;
        }
        ++this.ticksForCurrentLine;
        if (this.currentLine < this.hololog.lines().size()) {
            int delay;
            HolologData.HolologLine line = this.hololog.lines().get(this.currentLine);
            int n = delay = line.lineDelayTicks() > 0 ? line.lineDelayTicks() : this.hololog.lineDelayTicks();
            if (this.ticksForCurrentLine >= delay) {
                if (!this.voiceOverStarted && this.hololog.hasVoiceOver()) {
                    HolologPlayerAudio.playVoiceOver(this.playerId, this.hololog.voiceOver(), this.context);
                    this.voiceOverStarted = true;
                    log.debug("Started voice-over synchronized with first line");
                }
                log.debug("Displaying line {}/{}: '{}' (delay: {} ticks, waited: {} ticks)", (Object)(this.currentLine + 1), (Object)this.hololog.lines().size(), (Object)(line.text().isEmpty() ? "<pause>" : line.text()), (Object)delay, (Object)this.ticksForCurrentLine);
                if (this.textDisplay != null && !line.text().isEmpty()) {
                    this.textDisplay.accept(line.text());
                }
                HolologPlayerEffects.playEffects(line.effects(), this.context, this.context.getEffectPosition());
                ++this.currentLine;
                this.ticksForCurrentLine = 0;
            }
        }
        if (this.currentLine >= this.hololog.lines().size()) {
            if (!this.endEffectsPlayed) {
                HolologPlayerEffects.playEffects(this.hololog.end(), this.context, this.context.getEffectPosition());
                this.endEffectsPlayed = true;
                if (this.onComplete != null) {
                    log.info("Hololog playback completed: {}", (Object)this.hololog.id());
                    this.onComplete.run();
                }
            }
            this.state = PlaybackState.STOPPED;
        }
    }

    void stop() {
        this.state = PlaybackState.STOPPED;
        HolologPlayerAudio.stopVoiceOver(this.playerId);
    }

    boolean isPlaying() {
        return this.state == PlaybackState.PLAYING;
    }

    boolean isStopped() {
        return this.state == PlaybackState.STOPPED;
    }

    boolean hasPlayedEndEffects() {
        return this.endEffectsPlayed;
    }

    int getCurrentLine() {
        return this.currentLine;
    }

    public float getProgress() {
        if (this.hololog.lines().isEmpty()) {
            return 1.0f;
        }
        return (float)this.currentLine / (float)this.hololog.lines().size();
    }

    public boolean isActive() {
        return this.state != PlaybackState.STOPPED;
    }

    private static enum PlaybackState {
        STOPPED,
        PLAYING;

    }
}

