/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.hololog;

import de.markusbordihn.scraptechworkshop.data.hololog.HolologData;
import de.markusbordihn.scraptechworkshop.data.hololog.HolologPlaybackContext;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_5253;
import net.minecraft.class_638;
import org.joml.Vector3f;

public final class HolologPlayerEffects {
    private static final double PARTICLE_SPAWN_SPREAD = 0.5;
    private static final double PARTICLE_VELOCITY_HORIZONTAL = 0.02;
    private static final double PARTICLE_VELOCITY_VERTICAL = 0.05;

    private HolologPlayerEffects() {
    }

    public static void playEffects(HolologData.HolologEffects effects, HolologPlaybackContext context, class_243 effectPos) {
        if (!(context.getLevel() instanceof class_638)) {
            return;
        }
        for (HolologData.HolologSound sound : effects.sfx()) {
            context.playSound(sound.id(), sound.volume(), sound.pitch());
        }
        for (HolologData.HolologParticle particle : effects.fx()) {
            HolologPlayerEffects.spawnParticles(particle, effectPos, context);
        }
    }

    private static void spawnParticles(HolologData.HolologParticle particle, class_243 pos, HolologPlaybackContext context) {
        class_2394 particleType = HolologPlayerEffects.getParticleType(particle);
        for (int i = 0; i < particle.count(); ++i) {
            class_243 spawnPos = pos.method_1031((Math.random() - 0.5) * 0.5, (Math.random() - 0.5) * 0.5, (Math.random() - 0.5) * 0.5);
            class_243 velocity = new class_243((Math.random() - 0.5) * 0.02, Math.random() * 0.05, (Math.random() - 0.5) * 0.02);
            context.spawnParticle(particleType, spawnPos, velocity);
        }
    }

    private static class_2394 getParticleType(HolologData.HolologParticle particle) {
        String particleId = particle.id().method_12832();
        if ("dust".equals(particleId) && particle.color() != null) {
            Vector3f color = HolologPlayerEffects.parseColor(particle.color());
            return new class_2390(color, particle.scale());
        }
        return switch (particleId) {
            case "smoke" -> class_2398.field_11251;
            case "portal" -> class_2398.field_11214;
            case "crit" -> class_2398.field_11205;
            case "flash" -> class_2398.field_17909;
            default -> class_2398.field_11207;
        };
    }

    private static Vector3f parseColor(String hexColor) {
        if (hexColor == null || hexColor.isEmpty()) {
            return new Vector3f(1.0f, 1.0f, 1.0f);
        }
        try {
            int color = Integer.parseInt(hexColor.replace("#", ""), 16);
            float r = (float)class_5253.class_5254.method_27765((int)(color | 0xFF000000)) / 255.0f;
            float g = (float)class_5253.class_5254.method_27766((int)(color | 0xFF000000)) / 255.0f;
            float b = (float)class_5253.class_5254.method_27767((int)(color | 0xFF000000)) / 255.0f;
            return new Vector3f(r, g, b);
        }
        catch (NumberFormatException e) {
            return new Vector3f(1.0f, 1.0f, 1.0f);
        }
    }
}

