/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.data.energy;

import net.minecraft.class_1799;
import net.minecraft.class_2487;

public record EnergyData(int current, int maximum, int transferRate) {
    public static final String NBT_ENERGY = "Energy";
    public static final String NBT_MAX_ENERGY = "MaxEnergy";
    public static final String NBT_TRANSFER_RATE = "TransferRate";
    public static final int DEFAULT_TRANSFER_RATE = 100;

    public EnergyData(class_1799 itemStack) {
        this(itemStack, itemStack.method_7936());
    }

    public EnergyData(class_1799 itemStack, int maxEnergy) {
        this(EnergyData.readFromItemStack(itemStack, maxEnergy));
    }

    private EnergyData(EnergyValues values) {
        this(values.current, values.maximum, values.transferRate);
    }

    private static EnergyValues readFromItemStack(class_1799 itemStack, int maxEnergy) {
        int transferRate;
        int maximum;
        int current;
        class_2487 tag = itemStack.method_7969();
        if (tag != null) {
            current = tag.method_10545(NBT_ENERGY) ? tag.method_10550(NBT_ENERGY) : Math.max(1, maxEnergy - itemStack.method_7919());
            maximum = tag.method_10545(NBT_MAX_ENERGY) ? tag.method_10550(NBT_MAX_ENERGY) : maxEnergy;
            transferRate = tag.method_10545(NBT_TRANSFER_RATE) ? tag.method_10550(NBT_TRANSFER_RATE) : 100;
        } else {
            current = Math.max(1, maxEnergy - itemStack.method_7919());
            maximum = maxEnergy;
            transferRate = 100;
        }
        return new EnergyValues(current, maximum, transferRate);
    }

    public void writeToItemStack(class_1799 itemStack) {
        class_2487 tag = itemStack.method_7948();
        tag.method_10569(NBT_ENERGY, this.current);
        tag.method_10569(NBT_MAX_ENERGY, this.maximum);
        tag.method_10569(NBT_TRANSFER_RATE, this.transferRate);
        itemStack.method_7974(this.maximum - Math.max(1, this.current));
    }

    public boolean hasEnergy(int amount) {
        return this.current >= amount;
    }

    public float getPercentage() {
        if (this.current <= 0 || this.maximum <= 0) {
            return 0.0f;
        }
        return (float)this.current / (float)this.maximum;
    }

    public int getDisplayEnergy() {
        return Math.round(this.getPercentage() * 100.0f);
    }

    public EnergyData consume(int amount) {
        return new EnergyData(Math.max(0, this.current - amount), this.maximum, this.transferRate);
    }

    public EnergyData add(int amount) {
        return new EnergyData(Math.min(this.maximum, this.current + amount), this.maximum, this.transferRate);
    }

    public EnergyData withCurrent(int newCurrent) {
        return new EnergyData(Math.max(0, Math.min(this.maximum, newCurrent)), this.maximum, this.transferRate);
    }

    public boolean isEmpty() {
        return this.current <= 0;
    }

    public boolean isFull() {
        return this.current >= this.maximum;
    }

    private record EnergyValues(int current, int maximum, int transferRate) {
    }
}

