/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.data.hololog;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.markusbordihn.scraptechworkshop.data.hololog.HolologData;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HolologParser {
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final Gson GSON = new Gson();
    private static final Map<class_2960, HolologData> CACHE = new HashMap<class_2960, HolologData>();
    private static final String FIELD_ID = "id";
    private static final String FIELD_TITLE = "title";
    private static final String FIELD_SUBTITLE = "subtitle";
    private static final String FIELD_TITLE_COLOR = "titleColor";
    private static final String FIELD_SUBTITLE_COLOR = "subtitleColor";
    private static final String FIELD_LINE_DELAY_TICKS = "lineDelayTicks";
    private static final String FIELD_CHAR_DELAY_TICKS = "charDelayTicks";
    private static final String FIELD_VOICE_OVER = "voiceOver";
    private static final String FIELD_DISPLAY_ENTITY = "displayEntity";
    private static final String FIELD_DISPLAY_BLOCK = "displayBlock";
    private static final String FIELD_DISPLAY_ITEM = "displayItem";
    private static final String FIELD_DISPLAY_HOLO_ENTITY = "displayHoloEntity";
    private static final String FIELD_START = "start";
    private static final String FIELD_LINES = "lines";
    private static final String FIELD_END = "end";
    private static final String FIELD_TEXT = "text";
    private static final String FIELD_SCALE = "scale";
    private static final String FIELD_ROTATION_SPEED = "rotationSpeed";
    private static final String FIELD_ROTATION_X = "rotationX";
    private static final String FIELD_ROTATION_Y = "rotationY";
    private static final String FIELD_ROTATION_Z = "rotationZ";
    private static final String FIELD_TEXTURE = "texture";
    private static final String FIELD_SLIM = "slim";
    private static final String FIELD_PLAY_SOUND = "playSound";
    private static final String FIELD_SHOW_PARTICLE = "showParticle";
    private static final String FIELD_VOLUME = "volume";
    private static final String FIELD_PITCH = "pitch";
    private static final String FIELD_COUNT = "count";
    private static final String FIELD_COLOR = "color";
    private static final String DEFAULT_TITLE_COLOR = "#FFFFFF";
    private static final String DEFAULT_SUBTITLE_COLOR = "#AAAAAA";
    private static final int DEFAULT_LINE_DELAY_TICKS = 40;
    private static final int DEFAULT_CHAR_DELAY_TICKS = 1;
    private static final float DEFAULT_SCALE = 0.5f;
    private static final float DEFAULT_ROTATION_SPEED = 1.0f;
    private static final float DEFAULT_VOLUME = 1.0f;
    private static final float DEFAULT_PITCH = 1.0f;
    private static final float DEFAULT_EFFECT_SCALE = 1.0f;
    private static final int DEFAULT_PARTICLE_COUNT = 5;
    private static final String JSON_EXTENSION = ".json";
    private static final String ASSETS_PATH_PREFIX = "/assets/";
    private static final String PATH_SEPARATOR = "/";
    private static final String LANGUAGE_SEPARATOR = "_";
    private static final String ENGLISH_LANGUAGE_CODE = "en";

    private HolologParser() {
    }

    public static class_2960 getLocalizedId(class_2960 id) {
        try {
            class_2960 englishId;
            String[] parts = id.method_12832().split(PATH_SEPARATOR, 2);
            if (parts.length < 2) {
                return id;
            }
            String languageCode = class_310.method_1551().method_1526().method_4669().split(LANGUAGE_SEPARATOR)[0];
            class_2960 localizedId = new class_2960(id.method_12836(), parts[0] + PATH_SEPARATOR + languageCode + PATH_SEPARATOR + parts[1]);
            if (HolologParser.holologExists(localizedId)) {
                return localizedId;
            }
            if (!languageCode.equals(ENGLISH_LANGUAGE_CODE) && HolologParser.holologExists(englishId = new class_2960(id.method_12836(), parts[0] + "/en/" + parts[1]))) {
                log.debug("Using English fallback hololog: {}", (Object)englishId);
                return englishId;
            }
            log.debug("Using original hololog path: {}", (Object)id);
            return id;
        }
        catch (Exception e) {
            log.debug("Cannot access client (server-side?), using original path: {}", (Object)id);
            return id;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean holologExists(class_2960 id) {
        boolean bl;
        if (CACHE.containsKey(id)) {
            return true;
        }
        class_310 minecraft = class_310.method_1551();
        class_3300 resourceManager = minecraft.method_1478();
        class_2960 resourcePath = new class_2960(id.method_12836(), id.method_12832() + JSON_EXTENSION);
        Optional resource = resourceManager.method_14486(resourcePath);
        if (!resource.isEmpty()) return resource.isPresent();
        String classpathPath = ASSETS_PATH_PREFIX + id.method_12836() + PATH_SEPARATOR + id.method_12832() + JSON_EXTENSION;
        InputStream stream = HolologParser.class.getResourceAsStream(classpathPath);
        try {
            boolean bl2 = bl = stream != null;
            if (stream == null) return bl;
        }
        catch (Throwable throwable) {
            try {
                if (stream == null) throw throwable;
                try {
                    stream.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return false;
            }
        }
        stream.close();
        return bl;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Optional<HolologData> getHololog(class_2960 id) {
        block15: {
            if (CACHE.containsKey(id)) {
                return Optional.of(CACHE.get(id));
            }
            try {
                class_310 minecraft = class_310.method_1551();
                class_3300 resourceManager = minecraft.method_1478();
                Optional resource = resourceManager.method_14486(new class_2960(id.method_12836(), id.method_12832() + JSON_EXTENSION));
                InputStream stream = null;
                if (resource.isPresent()) {
                    stream = ((class_3298)resource.get()).method_14482();
                    log.debug("Loaded hololog from ResourceManager: {}", (Object)id);
                } else {
                    String classpathPath = ASSETS_PATH_PREFIX + id.method_12836() + PATH_SEPARATOR + id.method_12832() + JSON_EXTENSION;
                    stream = HolologParser.class.getResourceAsStream(classpathPath);
                    if (stream != null) {
                        log.debug("Loaded hololog from classpath: {}", (Object)classpathPath);
                    } else {
                        log.error("Hololog not found: {}", (Object)id);
                    }
                }
                if (stream == null) break block15;
                try {
                    Optional<HolologData> optional;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
                        JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                        Optional<HolologData> data = HolologParser.parseHolologJson(json);
                        data.ifPresent(hololog -> {
                            CACHE.put(id, (HolologData)hololog);
                            log.debug("Cached hololog: {}", (Object)id);
                        });
                        optional = data;
                    }
                    return optional;
                }
                finally {
                    stream.close();
                }
            }
            catch (Exception e) {
                log.error("Failed to load hololog {}: {}", (Object)id, (Object)e.getMessage(), (Object)e);
            }
        }
        return Optional.empty();
    }

    private static Optional<HolologData> parseHolologJson(JsonObject json) {
        if (json == null) {
            log.warn("Empty or invalid JSON");
            return Optional.empty();
        }
        class_2960 id = new class_2960(json.get(FIELD_ID).getAsString());
        String title = json.get(FIELD_TITLE).getAsString();
        String subtitle = json.has(FIELD_SUBTITLE) ? json.get(FIELD_SUBTITLE).getAsString() : "";
        String titleColor = json.has(FIELD_TITLE_COLOR) ? json.get(FIELD_TITLE_COLOR).getAsString() : DEFAULT_TITLE_COLOR;
        String subtitleColor = json.has(FIELD_SUBTITLE_COLOR) ? json.get(FIELD_SUBTITLE_COLOR).getAsString() : DEFAULT_SUBTITLE_COLOR;
        int lineDelayTicks = json.has(FIELD_LINE_DELAY_TICKS) ? json.get(FIELD_LINE_DELAY_TICKS).getAsInt() : 40;
        int charDelayTicks = json.has(FIELD_CHAR_DELAY_TICKS) ? json.get(FIELD_CHAR_DELAY_TICKS).getAsInt() : 1;
        class_2960 voiceOver = null;
        if (json.has(FIELD_VOICE_OVER)) {
            voiceOver = new class_2960(json.get(FIELD_VOICE_OVER).getAsString());
        }
        HolologData.HolologDisplayEntity displayEntity = null;
        if (json.has(FIELD_DISPLAY_ENTITY)) {
            displayEntity = HolologParser.parseDisplayEntity(json.getAsJsonObject(FIELD_DISPLAY_ENTITY), HolologData.DisplayType.ENTITY);
        } else if (json.has(FIELD_DISPLAY_BLOCK)) {
            displayEntity = HolologParser.parseDisplayEntity(json.getAsJsonObject(FIELD_DISPLAY_BLOCK), HolologData.DisplayType.BLOCK);
        } else if (json.has(FIELD_DISPLAY_ITEM)) {
            displayEntity = HolologParser.parseDisplayEntity(json.getAsJsonObject(FIELD_DISPLAY_ITEM), HolologData.DisplayType.ITEM);
        } else if (json.has(FIELD_DISPLAY_HOLO_ENTITY)) {
            displayEntity = HolologParser.parseDisplayEntity(json.getAsJsonObject(FIELD_DISPLAY_HOLO_ENTITY), HolologData.DisplayType.HOLO_ENTITY);
        }
        HolologData.HolologEffects start = json.has(FIELD_START) ? HolologParser.parseEffects(json.getAsJsonObject(FIELD_START)) : HolologData.HolologEffects.EMPTY;
        ArrayList<HolologData.HolologLine> lines = new ArrayList<HolologData.HolologLine>();
        if (json.has(FIELD_LINES)) {
            JsonArray linesArray = json.getAsJsonArray(FIELD_LINES);
            for (JsonElement lineElement : linesArray) {
                JsonObject jsonObject = lineElement.getAsJsonObject();
                String text = jsonObject.has(FIELD_TEXT) ? jsonObject.get(FIELD_TEXT).getAsString() : "";
                int lineSpecificDelay = jsonObject.has(FIELD_LINE_DELAY_TICKS) ? jsonObject.get(FIELD_LINE_DELAY_TICKS).getAsInt() : -1;
                HolologData.HolologDisplayEntity lineDisplayEntity = null;
                if (jsonObject.has(FIELD_DISPLAY_ENTITY)) {
                    lineDisplayEntity = HolologParser.parseDisplayEntity(jsonObject.getAsJsonObject(FIELD_DISPLAY_ENTITY), HolologData.DisplayType.ENTITY);
                } else if (jsonObject.has(FIELD_DISPLAY_BLOCK)) {
                    lineDisplayEntity = HolologParser.parseDisplayEntity(jsonObject.getAsJsonObject(FIELD_DISPLAY_BLOCK), HolologData.DisplayType.BLOCK);
                } else if (jsonObject.has(FIELD_DISPLAY_ITEM)) {
                    lineDisplayEntity = HolologParser.parseDisplayEntity(jsonObject.getAsJsonObject(FIELD_DISPLAY_ITEM), HolologData.DisplayType.ITEM);
                } else if (jsonObject.has(FIELD_DISPLAY_HOLO_ENTITY)) {
                    lineDisplayEntity = HolologParser.parseDisplayEntity(jsonObject.getAsJsonObject(FIELD_DISPLAY_HOLO_ENTITY), HolologData.DisplayType.HOLO_ENTITY);
                }
                HolologData.HolologEffects effects = jsonObject.has(FIELD_PLAY_SOUND) || jsonObject.has(FIELD_SHOW_PARTICLE) ? HolologParser.parseEffects(jsonObject) : HolologData.HolologEffects.EMPTY;
                lines.add(new HolologData.HolologLine(text, lineDisplayEntity, effects, lineSpecificDelay));
            }
        }
        HolologData.HolologEffects end = json.has(FIELD_END) ? HolologParser.parseEffects(json.getAsJsonObject(FIELD_END)) : HolologData.HolologEffects.EMPTY;
        return Optional.of(new HolologData(id, title, subtitle, titleColor, subtitleColor, lineDelayTicks, charDelayTicks, voiceOver, displayEntity, start, lines, end));
    }

    private static HolologData.HolologDisplayEntity parseDisplayEntity(JsonObject json, HolologData.DisplayType defaultType) {
        class_2960 id = new class_2960(json.get(FIELD_ID).getAsString());
        float scale = json.has(FIELD_SCALE) ? json.get(FIELD_SCALE).getAsFloat() : 0.5f;
        float rotationSpeed = 0.0f;
        if (defaultType != HolologData.DisplayType.ENTITY) {
            rotationSpeed = json.has(FIELD_ROTATION_SPEED) ? json.get(FIELD_ROTATION_SPEED).getAsFloat() : 1.0f;
        }
        float rotationX = json.has(FIELD_ROTATION_X) ? json.get(FIELD_ROTATION_X).getAsFloat() : 0.0f;
        float rotationY = json.has(FIELD_ROTATION_Y) ? json.get(FIELD_ROTATION_Y).getAsFloat() : 0.0f;
        float rotationZ = json.has(FIELD_ROTATION_Z) ? json.get(FIELD_ROTATION_Z).getAsFloat() : 0.0f;
        class_2960 texture = null;
        if (json.has(FIELD_TEXTURE)) {
            texture = new class_2960(json.get(FIELD_TEXTURE).getAsString());
        }
        boolean slim = json.has(FIELD_SLIM) && json.get(FIELD_SLIM).getAsBoolean();
        return new HolologData.HolologDisplayEntity(defaultType, id, scale, rotationSpeed, rotationX, rotationY, rotationZ, texture, slim);
    }

    private static HolologData.HolologEffects parseEffects(JsonObject json) {
        ArrayList<HolologData.HolologSound> sounds = new ArrayList<HolologData.HolologSound>();
        if (json.has(FIELD_PLAY_SOUND)) {
            JsonArray soundArray = json.getAsJsonArray(FIELD_PLAY_SOUND);
            for (JsonElement soundElement : soundArray) {
                JsonObject soundObj = soundElement.getAsJsonObject();
                class_2960 id = new class_2960(soundObj.get(FIELD_ID).getAsString());
                float volume = soundObj.has(FIELD_VOLUME) ? soundObj.get(FIELD_VOLUME).getAsFloat() : 1.0f;
                float pitch = soundObj.has(FIELD_PITCH) ? soundObj.get(FIELD_PITCH).getAsFloat() : 1.0f;
                sounds.add(new HolologData.HolologSound(id, volume, pitch));
            }
        }
        ArrayList<HolologData.HolologParticle> particles = new ArrayList<HolologData.HolologParticle>();
        if (json.has(FIELD_SHOW_PARTICLE)) {
            JsonArray particleArray = json.getAsJsonArray(FIELD_SHOW_PARTICLE);
            for (JsonElement particleElement : particleArray) {
                JsonObject particleObj = particleElement.getAsJsonObject();
                class_2960 id = new class_2960(particleObj.get(FIELD_ID).getAsString());
                int count = particleObj.has(FIELD_COUNT) ? particleObj.get(FIELD_COUNT).getAsInt() : 5;
                String color = particleObj.has(FIELD_COLOR) ? particleObj.get(FIELD_COLOR).getAsString() : null;
                float scale = particleObj.has(FIELD_SCALE) ? particleObj.get(FIELD_SCALE).getAsFloat() : 1.0f;
                particles.add(new HolologData.HolologParticle(id, count, color, scale));
            }
        }
        return new HolologData.HolologEffects(sounds, particles);
    }

    public static void clearCache() {
        CACHE.clear();
    }
}

