/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.data.multitool;

import de.markusbordihn.scraptechworkshop.data.multitool.BatteryLevel;
import de.markusbordihn.scraptechworkshop.data.multitool.ToolMode;
import de.markusbordihn.scraptechworkshop.item.component.EnergyCellItem;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public record ScrapMultitoolData(class_1799 battery, class_1799[] modules, int hologramColor, boolean hudEnabled, String toolPriority, String activeMode) {
    public static final int MODULE_SLOTS = 4;
    private static final String BATTERY_TAG = "Battery";
    private static final String MODULES_TAG = "Modules";
    private static final String HOLOGRAM_COLOR_TAG = "HologramColor";
    private static final String HUD_ENABLED_TAG = "HudEnabled";
    private static final String TOOL_PRIORITY_TAG = "ToolPriority";
    private static final String ACTIVE_MODE_TAG = "ActiveMode";
    private static final String MULTITOOL_DATA_TAG = "MultitoolData";

    public static ScrapMultitoolData createDefault() {
        return new ScrapMultitoolData(class_1799.field_8037, new class_1799[4], 65535, true, "auto", ToolMode.DEFAULT.getId());
    }

    public static ScrapMultitoolData fromItemStack(class_1799 itemStack) {
        class_2487 compoundTag = itemStack.method_7948();
        if (compoundTag.method_10545(MULTITOOL_DATA_TAG)) {
            return ScrapMultitoolData.fromNBT(compoundTag.method_10562(MULTITOOL_DATA_TAG));
        }
        return ScrapMultitoolData.createDefault();
    }

    public static ScrapMultitoolData fromNBT(class_2487 compoundTag) {
        class_1799 battery = class_1799.field_8037;
        if (compoundTag.method_10545(BATTERY_TAG)) {
            battery = class_1799.method_7915((class_2487)compoundTag.method_10562(BATTERY_TAG));
        }
        class_1799[] modules = new class_1799[4];
        if (compoundTag.method_10545(MODULES_TAG)) {
            class_2499 modulesTag = compoundTag.method_10554(MODULES_TAG, 10);
            for (int i = 0; i < Math.min(modulesTag.size(), 4); ++i) {
                modules[i] = class_1799.method_7915((class_2487)modulesTag.method_10602(i));
            }
        }
        return new ScrapMultitoolData(battery, modules, compoundTag.method_10550(HOLOGRAM_COLOR_TAG), compoundTag.method_10577(HUD_ENABLED_TAG), compoundTag.method_10558(TOOL_PRIORITY_TAG), compoundTag.method_10545(ACTIVE_MODE_TAG) ? compoundTag.method_10558(ACTIVE_MODE_TAG) : ToolMode.DEFAULT.getId());
    }

    public boolean hasBattery() {
        return !this.battery.method_7960();
    }

    public class_2487 toNBT() {
        class_2487 compoundTag = new class_2487();
        if (!this.battery.method_7960()) {
            compoundTag.method_10566(BATTERY_TAG, (class_2520)this.battery.method_7953(new class_2487()));
        }
        class_2499 modulesTag = new class_2499();
        for (class_1799 module : this.modules) {
            if (module != null && !module.method_7960()) {
                modulesTag.add((Object)module.method_7953(new class_2487()));
                continue;
            }
            modulesTag.add((Object)new class_2487());
        }
        compoundTag.method_10566(MODULES_TAG, (class_2520)modulesTag);
        compoundTag.method_10569(HOLOGRAM_COLOR_TAG, this.hologramColor);
        compoundTag.method_10556(HUD_ENABLED_TAG, this.hudEnabled);
        compoundTag.method_10582(TOOL_PRIORITY_TAG, this.toolPriority);
        compoundTag.method_10582(ACTIVE_MODE_TAG, this.activeMode);
        return compoundTag;
    }

    public void saveToItemStack(class_1799 itemStack) {
        class_2487 compoundTag = itemStack.method_7948();
        compoundTag.method_10566(MULTITOOL_DATA_TAG, (class_2520)this.toNBT());
    }

    public ScrapMultitoolData withBattery(class_1799 newBattery) {
        return new ScrapMultitoolData(newBattery, this.modules, this.hologramColor, this.hudEnabled, this.toolPriority, this.activeMode);
    }

    public ScrapMultitoolData withModule(int slot, class_1799 module) {
        if (slot < 0 || slot >= 4) {
            return this;
        }
        class_1799[] newModules = (class_1799[])this.modules.clone();
        newModules[slot] = module;
        return new ScrapMultitoolData(this.battery, newModules, this.hologramColor, this.hudEnabled, this.toolPriority, this.activeMode);
    }

    public ScrapMultitoolData withActiveMode(String newMode) {
        return new ScrapMultitoolData(this.battery, this.modules, this.hologramColor, this.hudEnabled, this.toolPriority, newMode);
    }

    public BatteryLevel getBatteryLevel() {
        if (!this.hasBattery()) {
            return BatteryLevel.BATTERY_LEVEL_0;
        }
        class_1792 class_17922 = this.battery.method_7909();
        if (class_17922 instanceof EnergyCellItem) {
            EnergyCellItem batteryItem = (EnergyCellItem)class_17922;
            float percentage = batteryItem.getEnergyPercentage(this.battery);
            if (percentage >= 1.0f) {
                return BatteryLevel.BATTERY_LEVEL_100;
            }
            if (percentage >= 0.75f) {
                return BatteryLevel.BATTERY_LEVEL_75;
            }
            if (percentage >= 0.5f) {
                return BatteryLevel.BATTERY_LEVEL_50;
            }
            if (percentage >= 0.25f) {
                return BatteryLevel.BATTERY_LEVEL_25;
            }
        }
        return BatteryLevel.BATTERY_LEVEL_0;
    }
}

