/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.energy;

import de.markusbordihn.scraptechworkshop.energy.EnergySourceType;
import de.markusbordihn.scraptechworkshop.energy.EnergyStatus;
import net.minecraft.class_1799;
import net.minecraft.class_2487;

public record BatteryStatus(EnergyStatus status, EnergySourceType sourceType, boolean rechargeable, int cycleCount) {
    public static final String NBT_RECHARGEABLE = "Rechargeable";
    public static final String NBT_CYCLE_COUNT = "CycleCount";

    public BatteryStatus(class_1799 itemStack) {
        this(BatteryStatus.readFromItemStack(itemStack));
    }

    private BatteryStatus(BatteryValues values) {
        this(values.status, values.sourceType, values.rechargeable, values.cycleCount);
    }

    private static BatteryValues readFromItemStack(class_1799 itemStack) {
        int cycleCount;
        boolean rechargeable;
        EnergySourceType sourceType;
        EnergyStatus status;
        class_2487 tag = itemStack.method_7969();
        if (tag != null) {
            status = EnergyStatus.fromId(tag.method_10558("EnergyStatus"));
            sourceType = EnergySourceType.fromId(tag.method_10558("EnergySource"));
            rechargeable = tag.method_10577(NBT_RECHARGEABLE);
            cycleCount = tag.method_10550(NBT_CYCLE_COUNT);
        } else {
            status = EnergyStatus.READY;
            sourceType = EnergySourceType.BATTERY;
            rechargeable = false;
            cycleCount = 0;
        }
        return new BatteryValues(status, sourceType, rechargeable, cycleCount);
    }

    public void writeToItemStack(class_1799 itemStack) {
        class_2487 tag = itemStack.method_7948();
        tag.method_10582("EnergyStatus", this.status.getId());
        tag.method_10582("EnergySource", this.sourceType.getId());
        tag.method_10556(NBT_RECHARGEABLE, this.rechargeable);
        tag.method_10569(NBT_CYCLE_COUNT, this.cycleCount);
    }

    public BatteryStatus withStatus(EnergyStatus newStatus) {
        return new BatteryStatus(newStatus, this.sourceType, this.rechargeable, this.cycleCount);
    }

    public BatteryStatus withCycleIncrement() {
        return new BatteryStatus(this.status, this.sourceType, this.rechargeable, this.cycleCount + 1);
    }

    public boolean canCharge() {
        return this.rechargeable && this.status != EnergyStatus.FAULTY && this.status != EnergyStatus.OVERCHARGED;
    }

    public boolean canDischarge() {
        return this.status != EnergyStatus.EMPTY && this.status != EnergyStatus.FAULTY;
    }

    public boolean isFaulty() {
        return this.status == EnergyStatus.FAULTY;
    }

    private record BatteryValues(EnergyStatus status, EnergySourceType sourceType, boolean rechargeable, int cycleCount) {
    }
}

