/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.energy;

import de.markusbordihn.scraptechworkshop.data.energy.EnergyData;
import de.markusbordihn.scraptechworkshop.energy.BatteryStatus;
import de.markusbordihn.scraptechworkshop.energy.EnergyStatus;
import de.markusbordihn.scraptechworkshop.item.component.EnergyCellItem;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

public final class EnergyManager {
    private EnergyManager() {
    }

    public static EnergyData getEnergyData(class_1799 itemStack, int maxEnergy) {
        return new EnergyData(itemStack, maxEnergy);
    }

    public static EnergyData getEnergyData(class_1799 itemStack) {
        return new EnergyData(itemStack);
    }

    public static BatteryStatus getBatteryStatus(class_1799 itemStack) {
        return new BatteryStatus(itemStack);
    }

    public static EnergyStatus getEnergyStatus(class_1799 itemStack) {
        return EnergyManager.getBatteryStatus(itemStack).status();
    }

    public static boolean hasEnergy(class_1799 itemStack, int maxEnergy, int amount) {
        return EnergyManager.getEnergyData(itemStack, maxEnergy).hasEnergy(amount);
    }

    public static boolean hasEnergy(class_1799 itemStack, int amount) {
        return EnergyManager.getEnergyData(itemStack).hasEnergy(amount);
    }

    public static void setEnergy(class_1799 itemStack, int maxEnergy, int energy) {
        EnergyData energyData = new EnergyData(Math.max(1, Math.min(energy, maxEnergy)), maxEnergy, 100);
        energyData.writeToItemStack(itemStack);
        EnergyManager.updateBatteryStatus(itemStack, energyData);
    }

    public static void consumeEnergy(class_1799 itemStack, int maxEnergy, int amount) {
        BatteryStatus batteryStatus = EnergyManager.getBatteryStatus(itemStack);
        if (!batteryStatus.canDischarge()) {
            return;
        }
        EnergyData energyData = EnergyManager.getEnergyData(itemStack, maxEnergy);
        EnergyData updatedData = energyData.consume(amount);
        updatedData.writeToItemStack(itemStack);
        EnergyManager.updateBatteryStatus(itemStack, updatedData);
    }

    public static void addEnergy(class_1799 itemStack, int maxEnergy, int amount) {
        BatteryStatus batteryStatus = EnergyManager.getBatteryStatus(itemStack);
        if (!batteryStatus.canCharge()) {
            return;
        }
        EnergyData energyData = EnergyManager.getEnergyData(itemStack, maxEnergy);
        EnergyData updatedData = energyData.add(amount);
        updatedData.writeToItemStack(itemStack);
        EnergyManager.updateBatteryStatus(itemStack, updatedData);
    }

    private static void updateBatteryStatus(class_1799 itemStack, EnergyData energyData) {
        BatteryStatus currentStatus = EnergyManager.getBatteryStatus(itemStack);
        EnergyStatus newStatus = EnergyStatus.fromEnergyLevel(energyData.current(), energyData.maximum());
        if (currentStatus.status() != newStatus) {
            BatteryStatus updatedStatus = currentStatus.withStatus(newStatus);
            updatedStatus.writeToItemStack(itemStack);
        }
    }

    public static boolean canReceiveEnergy(class_1799 itemStack) {
        return EnergyManager.getBatteryStatus(itemStack).canCharge();
    }

    public static boolean canExtractEnergy(class_1799 itemStack) {
        return EnergyManager.getBatteryStatus(itemStack).canDischarge();
    }

    public static int receiveEnergy(class_1799 itemStack, int maxEnergy, int maxReceive, boolean simulate) {
        EnergyData energyData = EnergyManager.getEnergyData(itemStack, maxEnergy);
        int canReceive = Math.min(maxReceive, energyData.maximum() - energyData.current());
        if (!simulate && canReceive > 0) {
            EnergyManager.addEnergy(itemStack, maxEnergy, canReceive);
        }
        return canReceive;
    }

    public static int extractEnergy(class_1799 itemStack, int maxEnergy, int maxExtract, boolean simulate) {
        EnergyData energyData = EnergyManager.getEnergyData(itemStack, maxEnergy);
        int canExtract = Math.min(maxExtract, energyData.current());
        if (!simulate && canExtract > 0) {
            EnergyManager.consumeEnergy(itemStack, maxEnergy, canExtract);
        }
        return canExtract;
    }

    public static int getEnergyStored(class_1799 itemStack, int maxEnergy) {
        return EnergyManager.getEnergyData(itemStack, maxEnergy).current();
    }

    public static int getEnergyStored(class_1799 itemStack) {
        return EnergyManager.getEnergyData(itemStack).current();
    }

    public static int getMaxEnergyStored(class_1799 itemStack, int maxEnergy) {
        return maxEnergy;
    }

    public static int getMaxEnergyStored(class_1799 itemStack) {
        return EnergyManager.getEnergyData(itemStack).maximum();
    }

    public static void syncFromBattery(class_1799 itemStack, int maxEnergy, class_1799 battery) {
        EnergyData currentData;
        EnergyCellItem batteryItem;
        int batteryEnergy;
        int transferAmount;
        class_1792 class_17922 = battery.method_7909();
        if (class_17922 instanceof EnergyCellItem && (transferAmount = Math.min(batteryEnergy = (batteryItem = (EnergyCellItem)class_17922).getEnergy(battery), maxEnergy - (currentData = EnergyManager.getEnergyData(itemStack, maxEnergy)).current())) > 0) {
            batteryItem.consumeEnergy(battery, transferAmount);
            EnergyManager.addEnergy(itemStack, maxEnergy, transferAmount);
        }
    }

    public static void consumeWithBatteryBackup(class_1799 itemStack, int maxEnergy, int amount, class_1799 battery) {
        EnergyData energyData = EnergyManager.getEnergyData(itemStack, maxEnergy);
        if (energyData.hasEnergy(amount)) {
            EnergyManager.consumeEnergy(itemStack, maxEnergy, amount);
            return;
        }
        class_1792 class_17922 = battery.method_7909();
        if (class_17922 instanceof EnergyCellItem) {
            EnergyCellItem batteryItem = (EnergyCellItem)class_17922;
            int batteryEnergy = batteryItem.getEnergy(battery);
            if (batteryEnergy >= amount) {
                batteryItem.consumeEnergy(battery, amount);
                EnergyManager.syncFromBattery(itemStack, maxEnergy, battery);
                return;
            }
            if (batteryEnergy > 0) {
                batteryItem.consumeEnergy(battery, batteryEnergy);
                amount -= batteryEnergy;
                EnergyManager.syncFromBattery(itemStack, maxEnergy, battery);
            }
        }
        EnergyData updatedData = energyData.consume(Math.max(1, energyData.current() - amount));
        updatedData.writeToItemStack(itemStack);
    }
}

