/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.renderer.hololog;

import de.markusbordihn.scraptechworkshop.client.renderer.hololog.HoloLogPlaybackBase;
import de.markusbordihn.scraptechworkshop.client.renderer.hololog.HoloLogPlayerEffects;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogData;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogDisplayEntity;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogLine;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogPlaybackContext;
import de.markusbordihn.scraptechworkshop.entity.hololog.HoloLogHumanoidEntity;
import de.markusbordihn.scraptechworkshop.registry.entity.HoloLogEntityRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_638;
import net.minecraft.class_7923;
import net.minecraft.class_811;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HoloLogScreenPlayer
extends HoloLogPlaybackBase {
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final int CHECKS_PER_SECOND = 10;
    private static final float CHECK_INTERVAL = 0.1f;
    private final List<String> displayedLines = new ArrayList<String>();
    private final float ticksPerCheck;
    private int currentCharIndex = 0;
    private float elapsedTimeSinceLastChar = 0.0f;
    private float elapsedTime = 0.0f;
    private float endDelayTimer = 0.0f;
    private boolean waitingForEndDelay = false;
    private int ticksSinceLastCheck = 0;

    public HoloLogScreenPlayer(HoloLogData holoLogData, HoloLogPlaybackContext context, UUID playerId, Runnable onComplete) {
        super(holoLogData, context, playerId, onComplete);
        this.ticksPerCheck = 2.0f;
    }

    @Override
    protected void onPlaybackStart() {
        this.displayedLines.clear();
        this.currentCharIndex = 0;
        this.elapsedTimeSinceLastChar = 0.0f;
        this.elapsedTime = 0.0f;
        this.endDelayTimer = 0.0f;
        this.waitingForEndDelay = false;
        this.ticksSinceLastCheck = 0;
        log.info("[HolologScreenPlayer] Playback started: {} lines", (Object)this.holoLogData.lines().size());
    }

    @Override
    protected void onPlaybackStop() {
        this.displayedLines.clear();
    }

    @Override
    protected int getDisplayLineIndex() {
        HoloLogLine line;
        int lineIndex = -1;
        int i = 0;
        while (i <= this.currentLineIndex && i < this.holoLogData.lines().size() && this.elapsedTime >= (line = this.holoLogData.lines().get(i)).startTime()) {
            lineIndex = i++;
        }
        return lineIndex;
    }

    @Override
    public void tick() {
        if (this.state != HoloLogPlaybackBase.PlaybackState.PLAYING) {
            return;
        }
        ++this.ticksSinceLastCheck;
        if ((float)this.ticksSinceLastCheck >= this.ticksPerCheck) {
            float charDelay;
            int charsToAdd;
            this.elapsedTime += 0.1f;
            this.elapsedTimeSinceLastChar += 0.1f;
            this.ticksSinceLastCheck = 0;
            this.startVoiceOver(this.elapsedTime);
            if (this.currentLineIndex < this.holoLogData.lines().size() && (charsToAdd = (int)(this.elapsedTimeSinceLastChar / (charDelay = this.holoLogData.charDelay()))) > 0) {
                this.elapsedTimeSinceLastChar -= (float)charsToAdd * charDelay;
                while (charsToAdd > 0 && this.currentLineIndex < this.holoLogData.lines().size()) {
                    String lineText;
                    HoloLogLine currentLine = this.holoLogData.lines().get(this.currentLineIndex);
                    String string = lineText = currentLine.text() != null ? currentLine.text() : "";
                    if (this.elapsedTime < currentLine.startTime()) break;
                    if (this.currentCharIndex < lineText.length()) {
                        this.currentCharIndex += charsToAdd;
                        if (this.currentCharIndex > lineText.length()) {
                            charsToAdd = this.currentCharIndex - lineText.length();
                            this.currentCharIndex = lineText.length();
                            continue;
                        }
                        charsToAdd = 0;
                        continue;
                    }
                    HoloLogPlayerEffects.playEffects(currentLine.effects(), this.context, this.context.getEffectPosition());
                    ++this.currentLineIndex;
                    this.currentCharIndex = 0;
                    this.elapsedTimeSinceLastChar = 0.0f;
                    if (lineText.isEmpty()) continue;
                    this.displayedLines.add(lineText);
                }
            }
            if (this.currentLineIndex >= this.holoLogData.lines().size() && !this.waitingForEndDelay) {
                this.waitingForEndDelay = true;
                this.endDelayTimer = 0.0f;
                log.debug("All lines finished, waiting {}s before end effects", (Object)Float.valueOf(this.holoLogData.endDelay()));
            }
            if (this.waitingForEndDelay) {
                this.endDelayTimer += 0.1f;
                if (this.endDelayTimer >= this.holoLogData.endDelay()) {
                    this.completePlayback();
                }
            }
        }
    }

    public List<String> getDisplayedLines() {
        return this.displayedLines;
    }

    public String getCurrentPartialLine() {
        String lineText;
        if (this.currentLineIndex >= this.holoLogData.lines().size()) {
            return "";
        }
        HoloLogLine currentLine = this.holoLogData.lines().get(this.currentLineIndex);
        String string = lineText = currentLine.text() != null ? currentLine.text() : "";
        if (this.currentCharIndex > 0 && this.currentCharIndex <= lineText.length()) {
            return lineText.substring(0, this.currentCharIndex);
        }
        return "";
    }

    public String getTitle() {
        return this.holoLogData.title();
    }

    public String getSubtitle() {
        return this.holoLogData.subtitle();
    }

    @Override
    protected void renderEntity(class_4587 poseStack, class_2960 entityId, float partialTick, int lightLevel) {
        class_310 mc = class_310.method_1551();
        this.renderEntity(poseStack, (class_4597)mc.method_22940().method_23000(), entityId, partialTick, lightLevel);
    }

    @Override
    protected void renderEntity(class_4587 poseStack, class_4597 buffer, class_2960 entityId, float partialTick, int lightLevel) {
        class_1299.method_5898((String)entityId.toString()).ifPresent(entityType -> {
            class_1297 entity;
            class_310 mc = class_310.method_1551();
            if (mc.field_1687 != null && (entity = entityType.method_5883((class_1937)mc.field_1687)) instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                mc.method_1561().method_3954((class_1297)livingEntity, 0.0, 0.0, 0.0, 0.0f, partialTick, poseStack, buffer, lightLevel);
                if (buffer instanceof class_4597.class_4598) {
                    class_4597.class_4598 bufferSource = (class_4597.class_4598)buffer;
                    bufferSource.method_22993();
                }
            }
        });
    }

    @Override
    protected void renderHoloEntity(class_4587 poseStack, HoloLogDisplayEntity displayEntity, float partialTick, int lightLevel) {
        class_310 mc = class_310.method_1551();
        this.renderHoloEntity(poseStack, (class_4597)mc.method_22940().method_23000(), displayEntity, partialTick, lightLevel);
    }

    @Override
    protected void renderHoloEntity(class_4587 poseStack, class_4597 buffer, HoloLogDisplayEntity displayEntity, float partialTick, int lightLevel) {
        class_310 minecraft = class_310.method_1551();
        class_638 level = minecraft.field_1687;
        if (level == null || HoloLogEntityRegistry.HOLO_LOG_HUMANOID_ENTITY_TYPE == null) {
            return;
        }
        HoloLogHumanoidEntity holoEntity = (HoloLogHumanoidEntity)HoloLogEntityRegistry.HOLO_LOG_HUMANOID_ENTITY_TYPE.method_5883((class_1937)level);
        if (holoEntity != null) {
            if (displayEntity.texture() != null) {
                holoEntity.setTexture(displayEntity.texture());
            }
            holoEntity.setSlim(displayEntity.slim());
            holoEntity.field_6012 = (int)level.method_8510();
            minecraft.method_1561().method_3954((class_1297)holoEntity, 0.0, 0.0, 0.0, 0.0f, partialTick, poseStack, buffer, lightLevel);
            if (buffer instanceof class_4597.class_4598) {
                class_4597.class_4598 bufferSource = (class_4597.class_4598)buffer;
                bufferSource.method_22993();
            }
        }
    }

    @Override
    protected void renderBlock(class_4587 poseStack, class_2960 blockId, int lightLevel) {
        class_310 mc = class_310.method_1551();
        this.renderBlock(poseStack, (class_4597)mc.method_22940().method_23000(), blockId, lightLevel);
    }

    @Override
    protected void renderBlock(class_4587 poseStack, class_4597 buffer, class_2960 blockId, int lightLevel) {
        class_2248 block = (class_2248)class_7923.field_41175.method_10223(blockId);
        if (block != null && block != class_2246.field_10124) {
            class_310 mc = class_310.method_1551();
            int fullBright = 0xF000F0;
            mc.method_1541().method_3353(block.method_9564(), poseStack, buffer, fullBright, class_4608.field_21444);
            if (buffer instanceof class_4597.class_4598) {
                class_4597.class_4598 bufferSource = (class_4597.class_4598)buffer;
                bufferSource.method_22993();
            }
        }
    }

    @Override
    protected void renderItem(class_4587 poseStack, class_2960 itemId, int lightLevel) {
        class_310 mc = class_310.method_1551();
        this.renderItem(poseStack, (class_4597)mc.method_22940().method_23000(), itemId, lightLevel);
    }

    @Override
    protected void renderItem(class_4587 poseStack, class_4597 buffer, class_2960 itemId, int lightLevel) {
        class_1792 item = (class_1792)class_7923.field_41178.method_10223(itemId);
        if (item != null && item != class_1802.field_8162) {
            class_310 mc = class_310.method_1551();
            class_1799 itemStack = new class_1799((class_1935)item);
            mc.method_1480().method_23178(itemStack, class_811.field_4319, lightLevel, class_4608.field_21444, poseStack, buffer, (class_1937)mc.field_1687, 0);
            if (buffer instanceof class_4597.class_4598) {
                class_4597.class_4598 bufferSource = (class_4597.class_4598)buffer;
                bufferSource.method_22993();
            }
        }
    }
}

