/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.data.loot;

import java.util.Map;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VanillaChestLootData {
    private static final String LOG_PREFIX = "[Loot Table Injection]";
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final Map<class_2960, class_2960> LOOT_TABLE_INJECTIONS = Map.ofEntries(Map.entry(new class_2960("minecraft", "chests/abandoned_mineshaft"), new class_2960("scrap_tech_workshop", "inject/chests/abandoned_mineshaft")), Map.entry(new class_2960("minecraft", "chests/simple_dungeon"), new class_2960("scrap_tech_workshop", "inject/chests/simple_dungeon")), Map.entry(new class_2960("minecraft", "chests/stronghold_corridor"), new class_2960("scrap_tech_workshop", "inject/chests/stronghold_corridor")), Map.entry(new class_2960("minecraft", "chests/ancient_city"), new class_2960("scrap_tech_workshop", "inject/chests/ancient_city")), Map.entry(new class_2960("minecraft", "chests/end_city_treasure"), new class_2960("scrap_tech_workshop", "inject/chests/end_city_treasure")), Map.entry(new class_2960("minecraft", "chests/ruined_portal"), new class_2960("scrap_tech_workshop", "inject/chests/ruined_portal")), Map.entry(new class_2960("minecraft", "chests/bastion_treasure"), new class_2960("scrap_tech_workshop", "inject/chests/bastion_treasure")), Map.entry(new class_2960("minecraft", "chests/shipwreck_supply"), new class_2960("scrap_tech_workshop", "inject/chests/shipwreck_supply")), Map.entry(new class_2960("minecraft", "chests/ocean_ruin_cold"), new class_2960("scrap_tech_workshop", "inject/chests/ocean_ruin_cold")), Map.entry(new class_2960("minecraft", "chests/ocean_ruin_warm"), new class_2960("scrap_tech_workshop", "inject/chests/ocean_ruin_warm")), Map.entry(new class_2960("minecraft", "chests/desert_pyramid"), new class_2960("scrap_tech_workshop", "inject/chests/desert_pyramid")));

    private VanillaChestLootData() {
    }

    public static class_2960 getInjectionTable(class_2960 targetTable) {
        return LOOT_TABLE_INJECTIONS.get(targetTable);
    }

    public static boolean shouldModifyLootTable(class_2960 targetTable) {
        return targetTable != null && LOOT_TABLE_INJECTIONS.containsKey(targetTable);
    }

    public static Map<class_2960, class_2960> getAllInjections() {
        return LOOT_TABLE_INJECTIONS;
    }

    public static void logSuccessfulInjection(class_2960 targetTable, class_2960 injectionTable) {
        log.debug("{} Successfully injected '{}' into '{}'", (Object)LOG_PREFIX, (Object)injectionTable, (Object)targetTable);
    }

    public static void logFailedInjection(class_2960 targetTable, class_2960 injectionTable, String reason) {
        log.warn("{} Failed to inject '{}' into '{}': {}", (Object)LOG_PREFIX, (Object)injectionTable, (Object)targetTable, (Object)reason);
    }

    public static void logSkippedInjection(class_2960 targetTable, String reason) {
        log.debug("{} Skipped '{}': {}", (Object)LOG_PREFIX, (Object)targetTable, (Object)reason);
    }
}

