/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.item.component;

import de.markusbordihn.scraptechworkshop.item.ModItems;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;

public class EnergyCellItem
extends class_1792 {
    public static final String ID = "energy_cell";
    public static final int ENERGY_MAX = 5000;
    private final int initialEnergy;

    public EnergyCellItem(class_1792.class_1793 properties) {
        this(properties, 5000);
    }

    public EnergyCellItem(class_1792.class_1793 properties, int initialEnergy) {
        super(properties.method_7889(1).method_7895(5000).method_7894(class_1814.field_8907));
        this.initialEnergy = Math.max(1, Math.min(initialEnergy, 5000));
    }

    public int getEnergy(class_1799 itemStack) {
        return 5000 - itemStack.method_7919();
    }

    public class_1799 method_7854() {
        class_1799 stack = new class_1799((class_1935)this);
        this.setEnergy(stack, this.initialEnergy);
        return stack;
    }

    public void setEnergy(class_1799 itemStack, int energy) {
        itemStack.method_7974(5000 - Math.max(1, Math.min(energy, 5000)));
    }

    public void consumeEnergy(class_1799 itemStack, int amount) {
        int currentEnergy = this.getEnergy(itemStack);
        this.setEnergy(itemStack, Math.max(1, currentEnergy - amount));
    }

    public boolean hasEnergy(class_1799 itemStack, int amount) {
        return this.getEnergy(itemStack) >= amount;
    }

    public float getEnergyPercentage(class_1799 itemStack) {
        return (float)this.getEnergy(itemStack) / 5000.0f;
    }

    public class_1799 createEmptyBattery() {
        return new class_1799((class_1935)ModItems.EMPTY_ENERGY_CELL.get());
    }

    public boolean method_31567(class_1799 itemStack) {
        return true;
    }

    public int method_31571(class_1799 itemStack) {
        float energyRatio = this.getEnergyPercentage(itemStack);
        return energyRatio > 0.6f ? 65280 : (energyRatio > 0.3f ? 0xFFFF00 : 0xFF0000);
    }

    public void method_7851(class_1799 itemStack, class_1937 level, List<class_2561> tooltipComponents, class_1836 isAdvanced) {
        tooltipComponents.add((class_2561)class_2561.method_43471((String)"item.scrap_tech_workshop.energy_cell.description"));
        int energy = this.getEnergy(itemStack);
        tooltipComponents.add((class_2561)class_2561.method_43470((String)("Energy: " + energy + "/5000")).method_27694(style -> style.method_36139(this.method_31571(itemStack))));
        super.method_7851(itemStack, level, tooltipComponents, isAdvanced);
    }

    public boolean method_7878(class_1799 toRepair, class_1799 repair) {
        return false;
    }
}

