/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.recipe.recycler;

import de.markusbordihn.scraptechworkshop.recipe.recycler.RecyclerRecipe;
import de.markusbordihn.scraptechworkshop.recipe.recycler.RecyclerRecipeType;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3956;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecyclerRecipeSelector {
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final String SPECIFIC_FOLDER = "specific";
    private static final String COMMON_FOLDER = "common";
    private static final String FALLBACK_FOLDER = "fallback";
    private static boolean recipesLogged = false;

    private RecyclerRecipeSelector() {
    }

    public static Optional<RecyclerRecipe> selectBestRecipe(class_1937 level, class_1799 inputStack) {
        if (level == null || inputStack.method_7960()) {
            return Optional.empty();
        }
        List allRecipes = level.method_8433().method_30027((class_3956)RecyclerRecipeType.INSTANCE);
        log.debug("Found {} total recycler recipes", (Object)allRecipes.size());
        if (!recipesLogged && !allRecipes.isEmpty()) {
            recipesLogged = true;
            int specificCount = 0;
            int commonCount = 0;
            int fallbackCount = 0;
            int unknownCount = 0;
            block10: for (RecyclerRecipe recipe2 : allRecipes) {
                String recipeType = RecyclerRecipeSelector.getRecipeTypeFromPath(recipe2.method_8114().method_12832());
                log.info("Registered recycler recipe: {} [Type: {}]", (Object)recipe2.method_8114(), (Object)recipeType);
                switch (recipeType) {
                    case "SPECIFIC": {
                        ++specificCount;
                        continue block10;
                    }
                    case "COMMON": {
                        ++commonCount;
                        continue block10;
                    }
                    case "FALLBACK": {
                        ++fallbackCount;
                        continue block10;
                    }
                }
                ++unknownCount;
            }
            log.info("Recipe Summary - Total: {}, Specific: {}, Common: {}, Fallback: {}, Unknown: {}", (Object)allRecipes.size(), (Object)specificCount, (Object)commonCount, (Object)fallbackCount, (Object)unknownCount);
        } else if (allRecipes.isEmpty()) {
            log.warn("WARNING: No recycler recipes found! Recipe loading might have failed.");
        }
        List matchingRecipes = allRecipes.stream().filter(recipe -> recipe.matchesInput(inputStack)).collect(Collectors.toList());
        log.debug("Found {} matching recipes for item: {}", (Object)matchingRecipes.size(), (Object)inputStack.method_7909());
        if (matchingRecipes.isEmpty()) {
            return Optional.empty();
        }
        List<RecyclerRecipe> specificRecipes = matchingRecipes.stream().filter(recipe -> RecyclerRecipeSelector.getFolderPriority(recipe) == 3).collect(Collectors.toList());
        List<RecyclerRecipe> commonRecipes = matchingRecipes.stream().filter(recipe -> RecyclerRecipeSelector.getFolderPriority(recipe) == 2).collect(Collectors.toList());
        List<RecyclerRecipe> fallbackRecipes = matchingRecipes.stream().filter(recipe -> RecyclerRecipeSelector.getFolderPriority(recipe) == 1).collect(Collectors.toList());
        Optional<RecyclerRecipe> selected = RecyclerRecipeSelector.selectBestFromGroup(specificRecipes);
        if (selected.isPresent()) {
            return selected;
        }
        selected = RecyclerRecipeSelector.selectBestFromGroup(commonRecipes);
        if (selected.isPresent()) {
            return selected;
        }
        return RecyclerRecipeSelector.selectBestFromGroup(fallbackRecipes);
    }

    private static int getFolderPriority(RecyclerRecipe recipe) {
        String path = recipe.method_8114().method_12832();
        if (path.contains("/specific/")) {
            return 3;
        }
        if (path.contains("/common/")) {
            return 2;
        }
        if (path.contains("/fallback/")) {
            return 1;
        }
        return 2;
    }

    private static String getRecipeTypeFromPath(String path) {
        if (path.contains("/specific/")) {
            return "SPECIFIC";
        }
        if (path.contains("/common/")) {
            return "COMMON";
        }
        if (path.contains("/fallback/")) {
            return "FALLBACK";
        }
        return "UNKNOWN";
    }

    private static Optional<RecyclerRecipe> selectBestFromGroup(List<RecyclerRecipe> recipes) {
        if (recipes.isEmpty()) {
            return Optional.empty();
        }
        return recipes.stream().max(Comparator.comparing(recipe -> recipe.method_8114().toString()));
    }
}

