/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.block.entity.recycler;

import de.markusbordihn.scraptechworkshop.block.entity.recycler.RecyclerContainer;
import de.markusbordihn.scraptechworkshop.block.entity.recycler.RecyclerTickProcessor;
import de.markusbordihn.scraptechworkshop.block.recycler.RecyclerBlock;
import de.markusbordihn.scraptechworkshop.config.RecyclerConfig;
import de.markusbordihn.scraptechworkshop.data.recycler.RecyclerStatus;
import de.markusbordihn.scraptechworkshop.item.upgrade.SpeedUpgradeItem;
import de.markusbordihn.scraptechworkshop.menu.RecyclerMenu;
import de.markusbordihn.scraptechworkshop.recipe.recycler.RecyclerRecipe;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3908;
import net.minecraft.class_3913;

public class RecyclerBlockEntity
extends class_2586
implements class_3908,
class_1278 {
    public static final String ID = "recycler";
    private static final int INPUT_SLOTS = 1;
    private static final int OUTPUT_SLOTS = 9;
    private static final int UPGRADE_SLOTS = 2;
    private static final int TOTAL_SLOTS = 12;
    private static final int INPUT_SLOT = 0;
    private static final int FIRST_OUTPUT_SLOT = 1;
    private static final int LAST_OUTPUT_SLOT = 9;
    private static final int FIRST_UPGRADE_SLOT = 10;
    private static final int LAST_UPGRADE_SLOT = 11;
    private static final String PROGRESS_TAG = "Progress";
    private static final String MAX_PROGRESS_TAG = "MaxProgress";
    private static final String NO_RECIPE_TIMER_TAG = "NoRecipeTimer";
    private static final String DONE_TIMER_TAG = "DoneTimer";
    private static final String ITEM_TAG_PREFIX = "Item";
    private static final int PROGRESS_DATA_INDEX = 0;
    private static final int MAX_PROGRESS_DATA_INDEX = 1;
    private static final String TRANSLATION_KEY = "container.scrap_tech_workshop.recycler";
    public static class_2591<RecyclerBlockEntity> TYPE;
    private final RecyclerContainer container;
    private int progress = 0;
    private int maxProgress = RecyclerConfig.processTime;
    private final class_3913 containerData = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> RecyclerBlockEntity.this.progress;
                case 1 -> RecyclerBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    RecyclerBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    RecyclerBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int method_17389() {
            return 2;
        }
    };
    private int noRecipeTimer = 0;
    private int doneTimer = 0;
    private RecyclerRecipe currentRecipe = null;
    private int tickCounter = 0;

    public RecyclerBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(TYPE, blockPos, blockState);
        this.container = new RecyclerContainer(12, this::method_5431);
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 blockState, RecyclerBlockEntity blockEntity) {
        if (level.field_9236) {
            return;
        }
        ++blockEntity.tickCounter;
        RecyclerStatus currentStatus = (RecyclerStatus)((Object)blockState.method_11654(RecyclerBlock.STATUS));
        int speedMultiplier = blockEntity.getSpeedMultiplierBonus();
        RecyclerTickProcessor.RecyclerState recyclerState = new RecyclerTickProcessor.RecyclerState(level, blockPos, blockEntity.container.getItems(), blockEntity.progress, blockEntity.maxProgress, blockEntity.noRecipeTimer, blockEntity.doneTimer, blockEntity.currentRecipe, speedMultiplier);
        RecyclerTickProcessor.TickResult result = switch (currentStatus) {
            default -> throw new IncompatibleClassChangeError();
            case RecyclerStatus.NO_RECIPE -> RecyclerTickProcessor.processNoRecipeStatus(recyclerState);
            case RecyclerStatus.DONE -> RecyclerTickProcessor.processDoneStatus(recyclerState);
            case RecyclerStatus.IDLE, RecyclerStatus.WORKING, RecyclerStatus.ERROR -> RecyclerTickProcessor.processActiveStatus(recyclerState, blockState);
        };
        blockEntity.progress = recyclerState.progress;
        blockEntity.noRecipeTimer = recyclerState.noRecipeTimer;
        blockEntity.doneTimer = recyclerState.doneTimer;
        blockEntity.currentRecipe = recyclerState.currentRecipe;
        if (result.newStatus != currentStatus) {
            RecyclerBlock.updateStatus(level, blockPos, result.newStatus);
        }
        if (result.hasChanged && blockEntity.tickCounter % RecyclerConfig.progressUpdateInterval == 0) {
            blockEntity.method_5431();
        }
    }

    public RecyclerContainer getContainer() {
        return this.container;
    }

    public void method_11014(class_2487 compoundTag) {
        super.method_11014(compoundTag);
        for (int i = 0; i < 12; ++i) {
            this.container.getItems()[i] = compoundTag.method_10545(ITEM_TAG_PREFIX + i) ? class_1799.method_7915((class_2487)compoundTag.method_10562(ITEM_TAG_PREFIX + i)) : class_1799.field_8037;
        }
        this.progress = compoundTag.method_10550(PROGRESS_TAG);
        this.maxProgress = compoundTag.method_10550(MAX_PROGRESS_TAG);
        this.noRecipeTimer = compoundTag.method_10550(NO_RECIPE_TIMER_TAG);
        this.doneTimer = compoundTag.method_10550(DONE_TIMER_TAG);
    }

    protected void method_11007(class_2487 compoundTag) {
        super.method_11007(compoundTag);
        for (int i = 0; i < 12; ++i) {
            if (this.container.getItems()[i].method_7960()) continue;
            compoundTag.method_10566(ITEM_TAG_PREFIX + i, (class_2520)this.container.getItems()[i].method_7953(new class_2487()));
        }
        compoundTag.method_10569(PROGRESS_TAG, this.progress);
        compoundTag.method_10569(MAX_PROGRESS_TAG, this.maxProgress);
        compoundTag.method_10569(NO_RECIPE_TIMER_TAG, this.noRecipeTimer);
        compoundTag.method_10569(DONE_TIMER_TAG, this.doneTimer);
    }

    public int method_5439() {
        return this.container.method_5439();
    }

    public boolean method_5442() {
        return this.container.method_5442();
    }

    public class_1799 method_5438(int slot) {
        return this.container.method_5438(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        return this.container.method_5434(slot, amount);
    }

    public class_1799 method_5441(int slot) {
        return this.container.method_5441(slot);
    }

    public void method_5447(int slot, class_1799 itemStack) {
        this.container.method_5447(slot, itemStack);
    }

    public boolean method_5443(class_1657 player) {
        return class_1263.method_49105((class_2586)this, (class_1657)player);
    }

    public boolean method_5437(int slot, class_1799 itemStack) {
        return this.container.method_5437(slot, itemStack);
    }

    public void method_5448() {
        this.container.method_5448();
    }

    public int[] method_5494(class_2350 direction) {
        return this.container.method_5494(direction);
    }

    public boolean method_5492(int slot, class_1799 itemStack, class_2350 direction) {
        return this.container.method_5492(slot, itemStack, direction);
    }

    public boolean method_5493(int slot, class_1799 itemStack, class_2350 direction) {
        return this.container.method_5493(slot, itemStack, direction);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)TRANSLATION_KEY);
    }

    public class_1703 createMenu(int windowId, class_1661 playerInventory, class_1657 player) {
        return new RecyclerMenu(windowId, playerInventory, this, this.containerData);
    }

    public int getRedstoneSignal() {
        if (this.maxProgress <= 0) {
            return 0;
        }
        return this.progress * 15 / this.maxProgress;
    }

    public class_3913 getContainerData() {
        return this.containerData;
    }

    private void syncToClient() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
        }
    }

    public void method_5431() {
        super.method_5431();
        this.syncToClient();
    }

    public class_2487 method_16887() {
        class_2487 compoundTag = new class_2487();
        this.method_11007(compoundTag);
        return compoundTag;
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    private int getSpeedMultiplierBonus() {
        int totalMultiplier = 1;
        for (int i = 10; i <= 11; ++i) {
            class_1792 class_17922;
            class_1799 stack = this.container.method_5438(i);
            if (stack.method_7960() || !((class_17922 = stack.method_7909()) instanceof SpeedUpgradeItem)) continue;
            SpeedUpgradeItem speedUpgrade = (SpeedUpgradeItem)class_17922;
            totalMultiplier += speedUpgrade.getSpeedMultiplier() - 1;
        }
        return totalMultiplier;
    }
}

