/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.renderer.blockentity;

import de.markusbordihn.scraptechworkshop.block.entity.hololog.HoloCubeBlockEntity;
import de.markusbordihn.scraptechworkshop.block.hololog.HoloCubeBlock;
import de.markusbordihn.scraptechworkshop.client.renderer.hololog.HoloLogBlockPlayer;
import de.markusbordihn.scraptechworkshop.data.hololog.DisplayType;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogDisplayEntity;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogStatus;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HoloCubeBlockEntityRenderer<T extends HoloCubeBlockEntity>
implements class_827<T> {
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final double HOLOGRAM_CENTER_X = 0.5;
    private static final double HOLOGRAM_CENTER_Z = 0.5;
    private static final double HOLOGRAM_Y_OFFSET_ITEM = 0.7;
    private static final double HOLOGRAM_Y_OFFSET_BLOCK = 0.8;
    private static final double HOLOGRAM_Y_OFFSET_DEFAULT = 0.5;
    private static final float BLOCK_SCALE_MULTIPLIER = 0.6f;
    private static final float ENTITY_SCALE_MULTIPLIER = 0.8f;
    private static final float ENTITY_HEAD_BOB_SPEED = 0.1f;
    private static final float ENTITY_HEAD_BOB_AMOUNT = 3.0f;
    private static final int RENDER_DISTANCE = 32;

    public HoloCubeBlockEntityRenderer(class_5614.class_5615 context) {
    }

    public void render(T blockEntity, float partialTicks, class_4587 poseStack, class_4597 buffer, int combinedLight, int combinedOverlay) {
        if (blockEntity.method_11010().method_11654(HoloCubeBlock.STATUS) != HoloLogStatus.PLAYING) {
            return;
        }
        HoloLogBlockPlayer player = ((HoloCubeBlockEntity)((Object)blockEntity)).getPlayer();
        if (player == null || !player.isPlaying()) {
            return;
        }
        HoloLogDisplayEntity displayEntity = player.getCurrentDisplayEntity();
        if (displayEntity == null) {
            displayEntity = HoloLogDisplayEntity.DEFAULT_VILLAGER;
        }
        try {
            poseStack.method_22903();
            this.prepareHologramPose(blockEntity, displayEntity, poseStack);
            player.renderDisplayEntity(poseStack, buffer, displayEntity, partialTicks, combinedLight);
            poseStack.method_22909();
        }
        catch (Exception e) {
            log.error("Failed to render hologram display {} for block entity at {}: {}", (Object)displayEntity.id(), (Object)blockEntity.method_11016(), (Object)e.getMessage());
        }
    }

    private void prepareHologramPose(T blockEntity, HoloLogDisplayEntity displayEntity, class_4587 poseStack) {
        double yOffset;
        double d = displayEntity.type() == DisplayType.ITEM ? 0.7 : (yOffset = displayEntity.type() == DisplayType.BLOCK ? 0.8 : 0.5);
        if (displayEntity.type() == DisplayType.BLOCK) {
            poseStack.method_22904(0.5, yOffset, 0.5);
            float scale = displayEntity.scale() * 0.6f;
            poseStack.method_22905(scale, scale, scale);
            class_1937 level = blockEntity.method_10997();
            if (level != null && displayEntity.rotationSpeed() > 0.0f) {
                float time = level.method_8510();
                float rotationSpeed = displayEntity.rotationSpeed();
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(time * rotationSpeed));
            }
            poseStack.method_22904(-0.5, -0.5, -0.5);
        } else {
            poseStack.method_22904(0.5, yOffset, 0.5);
        }
        if (displayEntity.type() == DisplayType.ENTITY || displayEntity.type() == DisplayType.HOLO_ENTITY) {
            boolean hasCustomRotation = false;
            if (displayEntity.type() == DisplayType.HOLO_ENTITY) {
                boolean bl = hasCustomRotation = displayEntity.rotationX() != 0.0f || displayEntity.rotationY() != 0.0f || displayEntity.rotationZ() != 0.0f;
            }
            if (!hasCustomRotation) {
                class_310 minecraft = class_310.method_1551();
                if (minecraft.field_1724 != null) {
                    class_243 blockCenter = class_243.method_24953((class_2382)blockEntity.method_11016()).method_1031(0.0, yOffset, 0.0);
                    class_243 playerPos = minecraft.field_1724.method_33571();
                    class_243 lookDir = playerPos.method_1020(blockCenter).method_1029();
                    float yaw = (float)Math.toDegrees(Math.atan2(lookDir.field_1352, lookDir.field_1350));
                    poseStack.method_22907(class_7833.field_40716.rotationDegrees(yaw));
                    class_1937 level = blockEntity.method_10997();
                    if (level != null) {
                        float time = (float)level.method_8510() + (float)minecraft.method_47600() / 1.0E9f;
                        float headBob = (float)Math.sin(time * 0.1f) * 3.0f;
                        poseStack.method_22907(class_7833.field_40714.rotationDegrees(headBob));
                    }
                }
            } else {
                poseStack.method_22907(class_7833.field_40714.rotationDegrees(displayEntity.rotationX()));
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(displayEntity.rotationY()));
                poseStack.method_22907(class_7833.field_40718.rotationDegrees(displayEntity.rotationZ()));
            }
            float scale = displayEntity.scale() * 0.8f;
            poseStack.method_22905(scale, scale, scale);
        } else if (displayEntity.type() == DisplayType.ITEM) {
            class_1937 level = blockEntity.method_10997();
            if (level != null && displayEntity.rotationSpeed() > 0.0f) {
                float time = level.method_8510();
                float rotationSpeed = displayEntity.rotationSpeed();
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(time * rotationSpeed));
            }
            float scale = displayEntity.scale();
            poseStack.method_22905(scale, scale, scale);
        }
    }

    public int method_33893() {
        return 32;
    }
}

