/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import de.markusbordihn.scraptechworkshop.client.screen.BaseContainerScreen;
import de.markusbordihn.scraptechworkshop.data.collectorstation.CollectorStationStatus;
import de.markusbordihn.scraptechworkshop.menu.CollectorStationMenu;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_757;

public class CollectorStationScreen
extends BaseContainerScreen<CollectorStationMenu> {
    private static final String TRANSLATION_KEY_PREFIX = "gui.scrap_tech_workshop.collector_station.";
    private static final String TRANSLATION_STATUS_CHARGING = "gui.scrap_tech_workshop.collector_station.status.charging";
    private static final String TRANSLATION_STATUS_COLLECTING = "gui.scrap_tech_workshop.collector_station.status.collecting";
    private static final String TRANSLATION_STATUS_RETURNING = "gui.scrap_tech_workshop.collector_station.status.returning";
    private static final String TRANSLATION_STATUS_PROCESSING = "gui.scrap_tech_workshop.collector_station.status.processing";
    private static final String TRANSLATION_STATUS_NO_STORAGE = "gui.scrap_tech_workshop.collector_station.status.no_storage";
    private static final String TRANSLATION_STATUS_NO_POWER = "gui.scrap_tech_workshop.collector_station.status.no_power";
    private static final class_2960 TEXTURE = new class_2960("scrap_tech_workshop", "textures/gui/collector_station.png");
    private static final int SCREEN_WIDTH = 176;
    private static final int SCREEN_HEIGHT = 220;
    private static final int ENERGY_BAR_WIDTH = 14;
    private static final int ENERGY_BAR_HEIGHT = 50;
    private static final int ENERGY_BAR_TEXTURE_X = 176;
    private static final int ENERGY_BAR_TEXTURE_Y = 0;
    private static final int PROGRESS_BAR_WIDTH = 100;
    private static final int PROGRESS_BAR_HEIGHT = 14;
    private static final int PROGRESS_BAR_TEXTURE_X = 176;
    private static final int PROGRESS_BAR_TEXTURE_Y = 50;
    private static final int PROGRESS_TEXT_Y = 114;
    private static final int MAX_ENERGY = 5000;

    public CollectorStationScreen(CollectorStationMenu menu, class_1661 playerInventory, class_2561 title) {
        super(menu, playerInventory, title);
        this.field_2792 = 176;
        this.field_2779 = 220;
    }

    protected void method_25426() {
        super.method_25426();
        this.field_25267 = (this.field_2792 - this.field_22793.method_27525((class_5348)this.field_22785)) / 2;
        this.field_25270 = this.field_2779 - 94;
    }

    protected void method_2389(class_332 guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = this.field_2776;
        int y = this.field_2800;
        this.renderDefaultBackground(guiGraphics, x, y, this.field_2792, this.field_2779);
        this.renderSlot(guiGraphics, x + 8, y + 18);
        this.renderSlots(guiGraphics, x + 30 + 2, y + 18, 6, 4);
        for (int i = 0; i < 4; ++i) {
            this.renderSlot(guiGraphics, x + 150 + 2, y + 18 + i * 18);
        }
        this.renderPlayerInventoryAt(guiGraphics, x, y, 139, 197);
        int energyBarX = x + 9;
        int energyBarY = y + 38;
        guiGraphics.method_25294(energyBarX - 1, energyBarY - 1, energyBarX + 14 + 1, energyBarY + 50 + 1, -7631989);
        int progressBarX = x + 39;
        int progressBarY = y + 96;
        guiGraphics.method_25294(progressBarX - 1, progressBarY - 1, progressBarX + 100 + 1, progressBarY + 14 + 1, -7631989);
        this.renderEnergyBar(guiGraphics, x, y);
        this.renderProgressBar(guiGraphics, x, y);
    }

    private void renderEnergyBar(class_332 guiGraphics, int x, int y) {
        int energy = ((CollectorStationMenu)this.field_2797).getCurrentEnergy();
        int maxEnergy = 5000;
        int energyBarX = x + 9;
        int energyBarY = y + 38;
        guiGraphics.method_25294(energyBarX, energyBarY, energyBarX + 14, energyBarY + 50, -11184811);
        if (energy > 0) {
            int energyBarHeight = (int)((float)energy / (float)maxEnergy * 50.0f);
            guiGraphics.method_25294(energyBarX, energyBarY + (50 - energyBarHeight), energyBarX + 14, energyBarY + 50, -16711936);
        }
        int percentage = energy * 100 / maxEnergy;
        String energyText = percentage + "%";
        int textX = energyBarX + 7 - this.field_22793.method_1727(energyText) / 2 + 1;
        int textY = energyBarY + 50 + 3;
        guiGraphics.method_51433(this.field_22793, energyText, textX, textY, 0x55FF55, false);
    }

    private void renderProgressBar(class_332 guiGraphics, int x, int y) {
        int progress = ((CollectorStationMenu)this.field_2797).getCollectionProgress();
        int maxProgress = ((CollectorStationMenu)this.field_2797).getMaxCollectionTime();
        int progressBarX = x + 39;
        int progressBarY = y + 96;
        guiGraphics.method_25294(progressBarX, progressBarY, progressBarX + 100, progressBarY + 14, -11184811);
        if (maxProgress > 0 && progress > 0) {
            int progressBarWidth = (int)((float)progress / (float)maxProgress * 100.0f);
            guiGraphics.method_25294(progressBarX, progressBarY, progressBarX + progressBarWidth, progressBarY + 14, -22016);
        }
    }

    protected void method_2388(class_332 guiGraphics, int mouseX, int mouseY) {
        guiGraphics.method_51439(this.field_22793, this.field_22785, this.field_25267, this.field_25268, 0x404040, false);
        guiGraphics.method_51439(this.field_22793, this.field_29347, this.field_25269, this.field_25270, 0x404040, false);
        int statusOrdinal = ((CollectorStationMenu)this.field_2797).getStatus();
        CollectorStationStatus status = CollectorStationStatus.values()[statusOrdinal];
        int stateTimer = ((CollectorStationMenu)this.field_2797).getStateTimer();
        int maxTime = ((CollectorStationMenu)this.field_2797).getMaxCollectionTime();
        class_5250 statusText = switch (status) {
            case CollectorStationStatus.CHARGING -> {
                int percentage;
                if (maxTime > 0 && stateTimer >= 0) {
                    percentage = stateTimer * 100 / maxTime;
                    yield class_2561.method_43469((String)TRANSLATION_STATUS_CHARGING, (Object[])new Object[]{percentage});
                }
                yield class_2561.method_43469((String)TRANSLATION_STATUS_CHARGING, (Object[])new Object[]{0});
            }
            case CollectorStationStatus.COLLECTING -> {
                int percentage;
                if (maxTime > 0 && stateTimer >= 0) {
                    percentage = stateTimer * 100 / maxTime;
                    yield class_2561.method_43469((String)TRANSLATION_STATUS_COLLECTING, (Object[])new Object[]{percentage});
                }
                yield class_2561.method_43469((String)TRANSLATION_STATUS_COLLECTING, (Object[])new Object[]{0});
            }
            case CollectorStationStatus.RETURNING -> {
                int percentage;
                if (maxTime > 0 && stateTimer >= 0) {
                    percentage = stateTimer * 100 / maxTime;
                    yield class_2561.method_43469((String)TRANSLATION_STATUS_RETURNING, (Object[])new Object[]{percentage});
                }
                yield class_2561.method_43469((String)TRANSLATION_STATUS_RETURNING, (Object[])new Object[]{0});
            }
            case CollectorStationStatus.PROCESSING -> {
                int percentage;
                if (maxTime > 0 && stateTimer >= 0) {
                    percentage = stateTimer * 100 / maxTime;
                    yield class_2561.method_43469((String)TRANSLATION_STATUS_PROCESSING, (Object[])new Object[]{percentage});
                }
                yield class_2561.method_43469((String)TRANSLATION_STATUS_PROCESSING, (Object[])new Object[]{0});
            }
            case CollectorStationStatus.NO_STORAGE -> class_2561.method_43471((String)TRANSLATION_STATUS_NO_STORAGE);
            case CollectorStationStatus.NO_POWER -> class_2561.method_43471((String)TRANSLATION_STATUS_NO_POWER);
            default -> class_2561.method_43471((String)TRANSLATION_STATUS_NO_POWER);
        };
        int textX = 39 - this.field_22793.method_27525((class_5348)statusText) / 2 + 50;
        guiGraphics.method_51439(this.field_22793, (class_2561)statusText, textX, 114, 0x404040, false);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(guiGraphics);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.method_2380(guiGraphics, mouseX, mouseY);
    }

    protected void method_2380(class_332 guiGraphics, int x, int y) {
        int percentage;
        super.method_2380(guiGraphics, x, y);
        int relativeX = x - this.field_2776;
        int relativeY = y - this.field_2800;
        if (relativeX >= 9 && relativeX <= 23 && relativeY >= 38 && relativeY <= 88) {
            int currentEnergy = ((CollectorStationMenu)this.field_2797).getCurrentEnergy();
            int maxEnergy = 5000;
            percentage = maxEnergy > 0 ? currentEnergy * 100 / maxEnergy : 0;
            class_5250 tooltip = class_2561.method_43470((String)String.format("Energy: %d / %d (%d%%)", currentEnergy, maxEnergy, percentage));
            guiGraphics.method_51438(this.field_22793, (class_2561)tooltip, x, y);
        }
        if (relativeX >= 39 && relativeX <= 139 && relativeY >= 96 && relativeY <= 110) {
            int progress = ((CollectorStationMenu)this.field_2797).getCollectionProgress();
            int maxProgress = ((CollectorStationMenu)this.field_2797).getMaxCollectionTime();
            percentage = maxProgress > 0 ? progress * 100 / maxProgress : 0;
            String statusName = this.getStatusName(((CollectorStationMenu)this.field_2797).getStatus());
            class_5250 tooltip = class_2561.method_43470((String)String.format("%s: %d%%", statusName, percentage));
            guiGraphics.method_51438(this.field_22793, (class_2561)tooltip, x, y);
        }
    }

    private String getStatusName(int statusOrdinal) {
        if (statusOrdinal < 0 || statusOrdinal >= CollectorStationStatus.values().length) {
            return "Unknown";
        }
        CollectorStationStatus status = CollectorStationStatus.values()[statusOrdinal];
        return switch (status) {
            default -> throw new IncompatibleClassChangeError();
            case CollectorStationStatus.CHARGING -> "Charging";
            case CollectorStationStatus.COLLECTING -> "Collecting";
            case CollectorStationStatus.RETURNING -> "Returning";
            case CollectorStationStatus.PROCESSING -> "Processing";
            case CollectorStationStatus.NO_STORAGE -> "No Storage";
            case CollectorStationStatus.NO_POWER -> "No Power";
        };
    }
}

