/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.data.hololog;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogData;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HoloLogParser {
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final Gson GSON = new Gson();

    private HoloLogParser() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean holoLogExists(class_2960 id) {
        boolean bl;
        class_310 minecraft = class_310.method_1551();
        class_3300 resourceManager = minecraft.method_1478();
        class_2960 resourcePath = new class_2960(id.method_12836(), id.method_12832() + ".json");
        Optional resource = resourceManager.method_14486(resourcePath);
        if (!resource.isEmpty()) return resource.isPresent();
        String classpathPath = "/assets/" + id.method_12836() + "/" + id.method_12832() + ".json";
        InputStream stream = HoloLogParser.class.getResourceAsStream(classpathPath);
        try {
            boolean bl2 = bl = stream != null;
            if (stream == null) return bl;
        }
        catch (Throwable throwable) {
            try {
                if (stream == null) throw throwable;
                try {
                    stream.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return false;
            }
        }
        stream.close();
        return bl;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Optional<HoloLogData> getHoloLog(class_2960 id) {
        block14: {
            try {
                class_310 minecraft = class_310.method_1551();
                class_3300 resourceManager = minecraft.method_1478();
                Optional resource = resourceManager.method_14486(new class_2960(id.method_12836(), id.method_12832() + ".json"));
                InputStream stream = null;
                if (resource.isPresent()) {
                    stream = ((class_3298)resource.get()).method_14482();
                    log.debug("Loaded hololog from ResourceManager: {}", (Object)id);
                } else {
                    String classpathPath = "/assets/" + id.method_12836() + "/" + id.method_12832() + ".json";
                    stream = HoloLogParser.class.getResourceAsStream(classpathPath);
                    if (stream != null) {
                        log.debug("Loaded hololog from classpath: {}", (Object)classpathPath);
                    } else {
                        log.error("Hololog not found: {}", (Object)id);
                    }
                }
                if (stream == null) break block14;
                try {
                    Optional<HoloLogData> optional;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
                        JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                        HoloLogData data = HoloLogData.fromJson(json);
                        HoloLogParser.validateLineLengths(data, id);
                        log.debug("Parsed hololog: {}", (Object)id);
                        optional = Optional.of(data);
                    }
                    return optional;
                }
                finally {
                    stream.close();
                }
            }
            catch (Exception e) {
                log.error("Failed to load hololog {}: {}", (Object)id, (Object)e.getMessage(), (Object)e);
            }
        }
        return Optional.empty();
    }

    private static void validateLineLengths(HoloLogData holoLogData, class_2960 id) {
        int MAX_LINE_LENGTH = 65;
        for (int i = 0; i < holoLogData.lines().size(); ++i) {
            String text = holoLogData.lines().get(i).text();
            if (text == null || text.length() <= 65) continue;
            log.warn("Hololog '{}' line {} exceeds recommended length: {} characters (max {}): \"{}\"", (Object)id, (Object)(i + 1), (Object)text.length(), (Object)65, (Object)text);
        }
    }
}

