/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.loot;

import de.markusbordihn.scraptechworkshop.config.ScrapFishingConfig;
import de.markusbordihn.scraptechworkshop.item.ModItems;
import de.markusbordihn.scraptechworkshop.loot.WeightedLootTable;
import net.minecraft.class_1792;
import net.minecraft.class_5819;

public final class ScrapFishingLootTables {
    private static WeightedLootTable<class_1792> vanillaRodTable;
    private static WeightedLootTable<class_1792> scrapRodTable;
    private static WeightedLootTable<class_1792> magnetRodTable;

    private ScrapFishingLootTables() {
    }

    public static class_1792 getVanillaRodLoot(class_5819 random) {
        if (vanillaRodTable == null) {
            ScrapFishingLootTables.initialize();
        }
        return vanillaRodTable.generate(random);
    }

    public static class_1792 getScrapRodLoot(class_5819 random) {
        if (scrapRodTable == null) {
            ScrapFishingLootTables.initialize();
        }
        return scrapRodTable.generate(random);
    }

    public static class_1792 getMagnetRodLoot(class_5819 random) {
        if (magnetRodTable == null) {
            ScrapFishingLootTables.initialize();
        }
        return magnetRodTable.generate(random);
    }

    public static void reset() {
        vanillaRodTable = null;
        scrapRodTable = null;
        magnetRodTable = null;
    }

    private static void initialize() {
        vanillaRodTable = ScrapFishingLootTables.createVanillaRodTable();
        scrapRodTable = ScrapFishingLootTables.createScrapRodTable();
        magnetRodTable = ScrapFishingLootTables.createMagnetRodTable();
    }

    private static WeightedLootTable<class_1792> createVanillaRodTable() {
        return new WeightedLootTable<class_1792>(new WeightedLootTable.Entry<class_1792>(ModItems.PLASTIC_SCRAP.get(), ScrapFishingConfig.vanillaPlasticWeight), new WeightedLootTable.Entry<class_1792>(ModItems.RUBBER_SCRAP.get(), ScrapFishingConfig.vanillaRubberWeight), new WeightedLootTable.Entry<class_1792>(ModItems.FASTENER_SCRAP.get(), ScrapFishingConfig.vanillaFastenerWeight), new WeightedLootTable.Entry<class_1792>(ModItems.METAL_SCRAP.get(), ScrapFishingConfig.vanillaMetalWeight), new WeightedLootTable.Entry<class_1792>(ModItems.IRON_SCRAP.get(), ScrapFishingConfig.vanillaIronWeight), new WeightedLootTable.Entry<class_1792>(ModItems.CIRCUIT_SCRAP.get(), ScrapFishingConfig.vanillaCircuitWeight), new WeightedLootTable.Entry<class_1792>(ModItems.GLASS_SCRAP.get(), ScrapFishingConfig.vanillaGlassWeight));
    }

    private static WeightedLootTable<class_1792> createScrapRodTable() {
        return new WeightedLootTable<class_1792>(new WeightedLootTable.Entry<class_1792>(ModItems.METAL_SCRAP.get(), ScrapFishingConfig.scrapRodMetalWeight), new WeightedLootTable.Entry<class_1792>(ModItems.IRON_SCRAP.get(), ScrapFishingConfig.scrapRodIronWeight), new WeightedLootTable.Entry<class_1792>(ModItems.COPPER_SCRAP.get(), ScrapFishingConfig.scrapRodCopperWeight), new WeightedLootTable.Entry<class_1792>(ModItems.CIRCUIT_SCRAP.get(), ScrapFishingConfig.scrapRodCircuitWeight), new WeightedLootTable.Entry<class_1792>(ModItems.CAPACITOR_SCRAP.get(), ScrapFishingConfig.scrapRodCapacitorWeight), new WeightedLootTable.Entry<class_1792>(ModItems.PLASTIC_SCRAP.get(), ScrapFishingConfig.scrapRodPlasticWeight), new WeightedLootTable.Entry<class_1792>(ModItems.RUBBER_SCRAP.get(), ScrapFishingConfig.scrapRodRubberWeight), new WeightedLootTable.Entry<class_1792>(ModItems.GLASS_SCRAP.get(), ScrapFishingConfig.scrapRodGlassWeight));
    }

    private static WeightedLootTable<class_1792> createMagnetRodTable() {
        return new WeightedLootTable<class_1792>(new WeightedLootTable.Entry<class_1792>(ModItems.CIRCUIT_SCRAP.get(), ScrapFishingConfig.magnetRodCircuitWeight), new WeightedLootTable.Entry<class_1792>(ModItems.CAPACITOR_SCRAP.get(), ScrapFishingConfig.magnetRodCapacitorWeight), new WeightedLootTable.Entry<class_1792>(ModItems.COIL_SCRAP.get(), ScrapFishingConfig.magnetRodCoilWeight), new WeightedLootTable.Entry<class_1792>(ModItems.METAL_SCRAP.get(), ScrapFishingConfig.magnetRodMetalWeight), new WeightedLootTable.Entry<class_1792>(ModItems.IRON_SCRAP.get(), ScrapFishingConfig.magnetRodIronWeight), new WeightedLootTable.Entry<class_1792>(ModItems.COPPER_SCRAP.get(), ScrapFishingConfig.magnetRodCopperWeight), new WeightedLootTable.Entry<class_1792>(ModItems.ALLOY_SCRAP.get(), ScrapFishingConfig.magnetRodAlloyWeight), new WeightedLootTable.Entry<class_1792>(ModItems.PLASTIC_SCRAP.get(), ScrapFishingConfig.magnetRodPlasticWeight));
    }
}

