/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.loot;

import de.markusbordihn.scraptechworkshop.config.ScrapPileConfig;
import de.markusbordihn.scraptechworkshop.data.ScrapPileVariant;
import de.markusbordihn.scraptechworkshop.item.ModItems;
import de.markusbordihn.scraptechworkshop.loot.WeightedLootTable;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_5819;

public final class ScrapLootTables {
    private static final Object METAL_LOCK = new Object();
    private static final Object TECH_LOCK = new Object();
    private static final Object MIXED_LOCK = new Object();
    private static volatile WeightedLootTable<class_1792> metalTable;
    private static volatile WeightedLootTable<class_1792> techTable;
    private static volatile WeightedLootTable<class_1792> mixedTable;

    private ScrapLootTables() {
    }

    public static class_1799 generateRandomScrap(ScrapPileVariant variant, class_5819 random) {
        WeightedLootTable<class_1792> table = switch (variant) {
            case ScrapPileVariant.METAL -> ScrapLootTables.getMetalTable();
            case ScrapPileVariant.TECH -> ScrapLootTables.getTechTable();
            default -> ScrapLootTables.getMixedTable();
        };
        return new class_1799((class_1935)table.generate(random));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WeightedLootTable<class_1792> getMetalTable() {
        WeightedLootTable<class_1792> table = metalTable;
        if (table == null) {
            Object object = METAL_LOCK;
            synchronized (object) {
                table = metalTable;
                if (table == null) {
                    metalTable = table = ScrapLootTables.createMetalTable();
                }
            }
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WeightedLootTable<class_1792> getTechTable() {
        WeightedLootTable<class_1792> table = techTable;
        if (table == null) {
            Object object = TECH_LOCK;
            synchronized (object) {
                table = techTable;
                if (table == null) {
                    techTable = table = ScrapLootTables.createTechTable();
                }
            }
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WeightedLootTable<class_1792> getMixedTable() {
        WeightedLootTable<class_1792> table = mixedTable;
        if (table == null) {
            Object object = MIXED_LOCK;
            synchronized (object) {
                table = mixedTable;
                if (table == null) {
                    mixedTable = table = ScrapLootTables.createMixedTable();
                }
            }
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetTables() {
        Object object = METAL_LOCK;
        synchronized (object) {
            metalTable = null;
        }
        object = TECH_LOCK;
        synchronized (object) {
            techTable = null;
        }
        object = MIXED_LOCK;
        synchronized (object) {
            mixedTable = null;
        }
    }

    private static WeightedLootTable<class_1792> createMetalTable() {
        return new WeightedLootTable<class_1792>(new WeightedLootTable.Entry<class_1792>(ModItems.ALLOY_SCRAP.get(), ScrapPileConfig.alloyScrapWeight), new WeightedLootTable.Entry<class_1792>(ModItems.METAL_SCRAP.get(), ScrapPileConfig.metalScrapWeight), new WeightedLootTable.Entry<class_1792>(ModItems.IRON_SCRAP.get(), ScrapPileConfig.ironScrapWeight), new WeightedLootTable.Entry<class_1792>(ModItems.COPPER_SCRAP.get(), ScrapPileConfig.copperScrapWeight), new WeightedLootTable.Entry<class_1792>(ModItems.GOLD_SCRAP.get(), ScrapPileConfig.goldScrapWeight));
    }

    private static WeightedLootTable<class_1792> createTechTable() {
        return new WeightedLootTable<class_1792>(new WeightedLootTable.Entry<class_1792>(ModItems.TECH_SCRAP.get(), ScrapPileConfig.techScrapWeight), new WeightedLootTable.Entry<class_1792>(ModItems.CIRCUIT_SCRAP.get(), ScrapPileConfig.circuitScrapWeight), new WeightedLootTable.Entry<class_1792>(ModItems.COIL_SCRAP.get(), ScrapPileConfig.coilScrapWeight), new WeightedLootTable.Entry<class_1792>(ModItems.CAPACITOR_SCRAP.get(), ScrapPileConfig.capacitorScrapWeight), new WeightedLootTable.Entry<class_1792>(ModItems.ENERGY_CELL_SCRAP.get(), ScrapPileConfig.energyCellScrapWeight));
    }

    private static WeightedLootTable<class_1792> createMixedTable() {
        return new WeightedLootTable<class_1792>(new WeightedLootTable.Entry<class_1792>(ModItems.METAL_SCRAP.get(), ScrapPileConfig.metalScrapWeight), new WeightedLootTable.Entry<class_1792>(ModItems.IRON_SCRAP.get(), ScrapPileConfig.ironScrapWeight), new WeightedLootTable.Entry<class_1792>(ModItems.COPPER_SCRAP.get(), ScrapPileConfig.copperScrapWeight), new WeightedLootTable.Entry<class_1792>(ModItems.TECH_SCRAP.get(), ScrapPileConfig.techScrapWeight), new WeightedLootTable.Entry<class_1792>(ModItems.PLASTIC_SCRAP.get(), ScrapPileConfig.plasticScrapWeight), new WeightedLootTable.Entry<class_1792>(ModItems.WOOD_SCRAP.get(), ScrapPileConfig.woodScrapWeight), new WeightedLootTable.Entry<class_1792>(ModItems.CRYSTAL_SCRAP.get(), ScrapPileConfig.crystalScrapWeight), new WeightedLootTable.Entry<class_1792>(ModItems.INSULATION_SCRAP.get(), ScrapPileConfig.insulationScrapWeight), new WeightedLootTable.Entry<class_1792>(ModItems.LUMINOUS_SCRAP.get(), ScrapPileConfig.luminousScrapWeight));
    }

    public static String getDebugInfo() {
        StringBuilder info = new StringBuilder("ScrapLootTables Debug Info:\n");
        if (metalTable != null) {
            info.append("Metal Table: ").append(metalTable.size()).append(" entries, total weight: ").append(metalTable.getTotalWeight()).append("\n");
        } else {
            info.append("Metal Table: Not initialized\n");
        }
        if (techTable != null) {
            info.append("Tech Table: ").append(techTable.size()).append(" entries, total weight: ").append(techTable.getTotalWeight()).append("\n");
        } else {
            info.append("Tech Table: Not initialized\n");
        }
        if (mixedTable != null) {
            info.append("Mixed Table: ").append(mixedTable.size()).append(" entries, total weight: ").append(mixedTable.getTotalWeight()).append("\n");
        } else {
            info.append("Mixed Table: Not initialized\n");
        }
        return info.toString();
    }
}

