/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.recipe.recycler;

import de.markusbordihn.scraptechworkshop.config.RecyclerConfig;
import de.markusbordihn.scraptechworkshop.recipe.recycler.RecyclerRecipeSerializer;
import de.markusbordihn.scraptechworkshop.recipe.recycler.RecyclerRecipeType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_6862;

public record RecyclerRecipe(class_2960 id, RecyclerMatch match, RecyclerOutput primaryOutput, List<RecyclerByproduct> byproducts, int processTime, int weight) implements class_1860<class_1263>
{
    private static final int INPUT_SLOT = 0;

    public RecyclerRecipe {
        if (byproducts == null) {
            byproducts = new ArrayList<RecyclerByproduct>();
        }
    }

    public boolean method_8115(class_1263 container, class_1937 level) {
        if (container.method_5442()) {
            return false;
        }
        class_1799 inputStack = container.method_5438(0);
        return !inputStack.method_7960() && this.match.matches(inputStack);
    }

    public class_1799 method_8116(class_1263 container, class_5455 registryAccess) {
        return this.method_8110(registryAccess);
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 method_8110(class_5455 registryAccess) {
        return this.primaryOutput.createStack();
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public class_1865<?> method_8119() {
        return RecyclerRecipeSerializer.INSTANCE;
    }

    public class_3956<?> method_17716() {
        return RecyclerRecipeType.INSTANCE;
    }

    public boolean matchesInput(class_1799 stack) {
        return this.match.matches(stack);
    }

    public List<class_1799> getOutputsForInput(class_1799 inputStack) {
        ArrayList<class_1799> outputs;
        block3: {
            block4: {
                outputs = new ArrayList<class_1799>();
                outputs.add(this.primaryOutput.createStackForInput(inputStack));
                if (!RecyclerConfig.isMultiByproductMode()) break block4;
                int addedByproducts = 0;
                for (RecyclerByproduct byproduct : this.byproducts) {
                    if (addedByproducts < RecyclerConfig.maxByproductsPerOperation) {
                        if (!byproduct.shouldProduce()) continue;
                        outputs.add(byproduct.createStack());
                        ++addedByproducts;
                        continue;
                    }
                    break block3;
                }
                break block3;
            }
            if (this.byproducts.isEmpty()) break block3;
            for (RecyclerByproduct byproduct : this.byproducts) {
                if (!byproduct.shouldProduce()) continue;
                outputs.add(byproduct.createStack());
                break;
            }
        }
        return outputs;
    }

    public static class RecyclerMatch {
        private final class_1792 item;
        private final class_6862<class_1792> tag;

        public RecyclerMatch(class_1792 item) {
            this.item = item;
            this.tag = null;
        }

        public RecyclerMatch(class_6862<class_1792> tag) {
            this.item = null;
            this.tag = tag;
        }

        public boolean matches(class_1799 stack) {
            if (this.item != null) {
                return stack.method_31574(this.item);
            }
            if (this.tag != null) {
                return stack.method_31573(this.tag);
            }
            return false;
        }

        public boolean isItemMatch() {
            return this.item != null;
        }

        public class_1792 getItem() {
            return this.item;
        }

        public class_6862<class_1792> getTag() {
            return this.tag;
        }
    }

    public static class RecyclerOutput {
        private final class_1792 item;
        private final int minCount;
        private final int maxCount;
        private final boolean durabilityScaling;

        public RecyclerOutput(class_1792 item, int count) {
            this(item, count, count, false);
        }

        public RecyclerOutput(class_1792 item, int minCount, int maxCount, boolean durabilityScaling) {
            this.item = item;
            this.minCount = minCount;
            this.maxCount = maxCount;
            this.durabilityScaling = durabilityScaling;
        }

        public class_1799 createStack() {
            int count = this.minCount == this.maxCount ? this.minCount : this.minCount + (int)(Math.random() * (double)(this.maxCount - this.minCount + 1));
            return new class_1799((class_1935)this.item, count);
        }

        public class_1799 createStackForInput(class_1799 inputStack) {
            int baseCount;
            int n = baseCount = this.minCount == this.maxCount ? this.minCount : this.minCount + (int)(Math.random() * (double)(this.maxCount - this.minCount + 1));
            if (this.durabilityScaling && RecyclerConfig.durabilityScaling && inputStack.method_7963()) {
                double durabilityRatio = (double)(inputStack.method_7936() - inputStack.method_7919()) / (double)inputStack.method_7936();
                double scalingFactor = 0.25 + 0.75 * durabilityRatio;
                baseCount = Math.max(1, (int)Math.floor((double)baseCount * scalingFactor));
            }
            return new class_1799((class_1935)this.item, baseCount);
        }

        public class_1792 getItem() {
            return this.item;
        }

        public int getMinCount() {
            return this.minCount;
        }

        public int getMaxCount() {
            return this.maxCount;
        }

        public boolean isDurabilityScaling() {
            return this.durabilityScaling;
        }
    }

    public static class RecyclerByproduct {
        private final class_1792 item;
        private final double chance;
        private final int minCount;
        private final int maxCount;

        public RecyclerByproduct(class_1792 item, double chance) {
            this(item, chance, 1, 1);
        }

        public RecyclerByproduct(class_1792 item, double chance, int minCount, int maxCount) {
            this.item = item;
            this.chance = chance;
            this.minCount = minCount;
            this.maxCount = maxCount;
        }

        public boolean shouldProduce() {
            return Math.random() < this.chance;
        }

        public class_1799 createStack() {
            int count = this.minCount == this.maxCount ? this.minCount : this.minCount + (int)(Math.random() * (double)(this.maxCount - this.minCount + 1));
            return new class_1799((class_1935)this.item, count);
        }

        public class_1792 getItem() {
            return this.item;
        }

        public double getChance() {
            return this.chance;
        }

        public int getMinCount() {
            return this.minCount;
        }

        public int getMaxCount() {
            return this.maxCount;
        }
    }
}

