/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.block.entity;

import de.markusbordihn.scraptechworkshop.block.RecyclerBlock;
import de.markusbordihn.scraptechworkshop.block.entity.RecyclerRecipeHandler;
import de.markusbordihn.scraptechworkshop.data.recycler.RecyclerStatus;
import de.markusbordihn.scraptechworkshop.recipe.recycler.RecyclerRecipe;
import net.minecraft.class_1264;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class RecyclerTickProcessor {
    private static final int NO_RECIPE_COOLDOWN = 40;
    private static final int DONE_DISPLAY_TIME = 20;
    private static final int PROGRESS_DECAY_RATE = 2;

    public static TickResult processNoRecipeStatus(RecyclerState state) {
        --state.noRecipeTimer;
        if (state.noRecipeTimer <= 0) {
            return new TickResult(RecyclerStatus.IDLE, true);
        }
        return new TickResult(RecyclerStatus.NO_RECIPE, false);
    }

    public static TickResult processDoneStatus(RecyclerState state) {
        --state.doneTimer;
        if (state.doneTimer <= 0) {
            state.currentRecipe = RecyclerRecipeHandler.findRecipe(state.level, state.getInputStack());
            if (state.currentRecipe != null && RecyclerRecipeHandler.canProcessRecipe(state.currentRecipe, state.getInputStack(), state.items)) {
                state.progress = 0;
                return new TickResult(RecyclerStatus.WORKING, true);
            }
            return new TickResult(RecyclerStatus.IDLE, true);
        }
        return new TickResult(RecyclerStatus.DONE, false);
    }

    public static TickResult processActiveStatus(RecyclerState state, class_2680 blockState) {
        boolean hasChanged = false;
        RecyclerStatus newStatus = (RecyclerStatus)((Object)blockState.method_11654(RecyclerBlock.STATUS));
        if (state.currentRecipe == null || !RecyclerRecipeHandler.canProcessRecipe(state.currentRecipe, state.getInputStack(), state.items)) {
            state.currentRecipe = RecyclerRecipeHandler.findRecipe(state.level, state.getInputStack());
            if (state.currentRecipe == null && !state.getInputStack().method_7960()) {
                RecyclerTickProcessor.ejectInputItem(state, blockState);
                state.noRecipeTimer = 40;
                return new TickResult(RecyclerStatus.NO_RECIPE, true);
            }
            state.progress = 0;
            hasChanged = true;
        }
        if (state.currentRecipe != null && RecyclerRecipeHandler.canProcessRecipe(state.currentRecipe, state.getInputStack(), state.items)) {
            state.progress += state.speedMultiplier;
            newStatus = RecyclerStatus.WORKING;
            hasChanged = true;
            if (state.progress >= state.maxProgress) {
                RecyclerRecipeHandler.processRecipe(state.currentRecipe, state.getInputStack(), state.items);
                state.progress = 0;
                state.currentRecipe = null;
                newStatus = RecyclerStatus.DONE;
                state.doneTimer = 20;
            }
        } else if (state.currentRecipe != null && !RecyclerRecipeHandler.canProcessRecipe(state.currentRecipe, state.getInputStack(), state.items)) {
            class_1799 inputStack = state.getInputStack();
            newStatus = !inputStack.method_7960() && state.currentRecipe.matchesInput(inputStack) ? RecyclerStatus.ERROR : RecyclerStatus.IDLE;
            state.progress = 0;
            hasChanged = true;
        } else if (state.progress > 0) {
            if (RecyclerRecipeHandler.findRecipe(state.level, state.getInputStack()) == null) {
                newStatus = RecyclerStatus.IDLE;
            }
            state.progress = Math.max(0, state.progress - 2);
            hasChanged = true;
            if (state.progress == 0) {
                newStatus = RecyclerStatus.IDLE;
            }
        } else {
            newStatus = RecyclerStatus.IDLE;
        }
        return new TickResult(newStatus, hasChanged);
    }

    private static void ejectInputItem(RecyclerState state, class_2680 blockState) {
        class_1799 inputStack = state.getInputStack();
        if (inputStack.method_7960()) {
            return;
        }
        class_2350 backDirection = ((class_2350)blockState.method_11654((class_2769)RecyclerBlock.FACING)).method_10153();
        class_2338 ejectPos = state.pos.method_10093(backDirection);
        class_1799 itemToEject = inputStack.method_7972();
        itemToEject.method_7939(1);
        inputStack.method_7934(1);
        class_1264.method_5449((class_1937)state.level, (double)((double)ejectPos.method_10263() + 0.5), (double)((double)ejectPos.method_10264() + 0.5), (double)((double)ejectPos.method_10260() + 0.5), (class_1799)itemToEject);
        RecyclerTickProcessor.addEjectionFeedback(state.level, state.pos, ejectPos);
    }

    private static void addEjectionFeedback(class_1937 level, class_2338 recyclerPos, class_2338 ejectPos) {
        if (level.field_9236) {
            return;
        }
        level.method_8396(null, recyclerPos, class_3417.field_14701, class_3419.field_15245, 0.5f, 1.2f);
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            serverLevel.method_14199((class_2394)class_2398.field_11251, (double)ejectPos.method_10263() + 0.5, (double)ejectPos.method_10264() + 0.5, (double)ejectPos.method_10260() + 0.5, 3, 0.2, 0.1, 0.2, 0.02);
        }
    }

    public static class RecyclerState {
        public final class_1937 level;
        public final class_2338 pos;
        public final class_1799[] items;
        public final int maxProgress;
        public final int speedMultiplier;
        public int progress;
        public int noRecipeTimer;
        public int doneTimer;
        public RecyclerRecipe currentRecipe;

        public RecyclerState(class_1937 level, class_2338 pos, class_1799[] items, int progress, int maxProgress, int noRecipeTimer, int doneTimer, RecyclerRecipe currentRecipe, int speedMultiplier) {
            this.level = level;
            this.pos = pos;
            this.items = items;
            this.progress = progress;
            this.maxProgress = maxProgress;
            this.noRecipeTimer = noRecipeTimer;
            this.doneTimer = doneTimer;
            this.currentRecipe = currentRecipe;
            this.speedMultiplier = speedMultiplier;
        }

        public class_1799 getInputStack() {
            return this.items[0];
        }
    }

    public static class TickResult {
        public final RecyclerStatus newStatus;
        public final boolean hasChanged;

        public TickResult(RecyclerStatus newStatus, boolean hasChanged) {
            this.newStatus = newStatus;
            this.hasChanged = hasChanged;
        }
    }
}

