/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.item.tool;

import de.markusbordihn.scraptechworkshop.Constants;
import de.markusbordihn.scraptechworkshop.config.MultitoolConfig;
import de.markusbordihn.scraptechworkshop.data.block.StrippableBlocks;
import de.markusbordihn.scraptechworkshop.data.energy.EnergyData;
import de.markusbordihn.scraptechworkshop.data.multitool.DisplayMode;
import de.markusbordihn.scraptechworkshop.data.multitool.ScrapMultitoolData;
import de.markusbordihn.scraptechworkshop.data.multitool.ToolMode;
import de.markusbordihn.scraptechworkshop.energy.EnergyCellConsumer;
import de.markusbordihn.scraptechworkshop.energy.EnergyManager;
import de.markusbordihn.scraptechworkshop.item.ModItems;
import de.markusbordihn.scraptechworkshop.item.component.EnergyCellItem;
import de.markusbordihn.scraptechworkshop.item.tool.ToolModeDetector;
import de.markusbordihn.scraptechworkshop.menu.ScrapMultitoolMenuProvider;
import de.markusbordihn.scraptechworkshop.processing.AxeInteractionHandler;
import de.markusbordihn.scraptechworkshop.processing.BlockInteractionProcessor;
import de.markusbordihn.scraptechworkshop.processing.ShovelInteractionHandler;
import de.markusbordihn.scraptechworkshop.processing.SwordInteractionHandler;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1766;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3908;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScrapMultitoolItem
extends class_1766
implements EnergyCellConsumer {
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");

    public ScrapMultitoolItem(class_1792.class_1793 properties) {
        super(4.0f, -2.4f, (class_1832)class_1834.field_8923, class_3481.field_33715, properties.method_7895(MultitoolConfig.energyMax).method_7894(class_1814.field_8903));
    }

    @Override
    public int getMaxEnergy() {
        return MultitoolConfig.energyMax;
    }

    public void method_7843(class_1799 itemStack, class_1937 level, class_1657 player) {
        super.method_7843(itemStack, level, player);
        ScrapMultitoolData data = ScrapMultitoolData.fromItemStack(itemStack);
        if (!data.hasBattery()) {
            class_1799 battery = new class_1799((class_1935)ModItems.SLIGHTLY_DAMAGED_ENERGY_CELL.get());
            class_1792 class_17922 = battery.method_7909();
            if (class_17922 instanceof EnergyCellItem) {
                EnergyCellItem energyCell = (EnergyCellItem)class_17922;
                energyCell.setEnergy(battery, 2500);
            }
            data = data.withBattery(battery);
            data.saveToItemStack(itemStack);
            this.syncEnergyDisplay(itemStack);
            DisplayMode displayMode = new DisplayMode(itemStack);
            displayMode.updateModel(ToolMode.fromId(data.activeMode()), data.getBatteryLevel());
        }
    }

    public float method_7865(class_1799 itemStack, class_2680 state) {
        boolean isEffective;
        ToolModeDetector detector = new ToolModeDetector(itemStack);
        detector.updateToolMode(null, state);
        if (!this.hasEnergy(itemStack, MultitoolConfig.energyPerBlock)) {
            return 1.0f;
        }
        ToolMode mode = detector.getToolModeForBlock(state);
        if (mode != ToolMode.NONE) {
            return this.getPoweredSpeed(mode);
        }
        ScrapMultitoolData data = ScrapMultitoolData.fromItemStack(itemStack);
        ToolMode activeToolMode = ToolMode.fromId(data.activeMode());
        switch (activeToolMode) {
            case PICKAXE: {
                boolean bl = state.method_26164(class_3481.field_33715);
                break;
            }
            case AXE: {
                boolean bl = state.method_26164(class_3481.field_33713);
                break;
            }
            case SHOVEL: {
                boolean bl = state.method_26164(class_3481.field_33716);
                break;
            }
            case HOE: {
                boolean bl = state.method_26164(class_3481.field_33714);
                break;
            }
            default: {
                boolean bl = isEffective = state.method_26164(class_3481.field_33715);
            }
        }
        if (isEffective) {
            return this.getPoweredSpeed(activeToolMode);
        }
        return super.method_7865(itemStack, state);
    }

    public boolean method_7873(class_1799 itemStack, class_1309 target, class_1309 attacker) {
        ScrapMultitoolData data;
        if (attacker instanceof class_1657) {
            data = ScrapMultitoolData.fromItemStack(itemStack);
            if (!ToolMode.SWORD.getId().equals(data.activeMode())) {
                ScrapMultitoolData newData = data.withActiveMode(ToolMode.SWORD.getId());
                newData.saveToItemStack(itemStack);
                DisplayMode displayMode = new DisplayMode(itemStack);
                displayMode.updateModel(ToolMode.SWORD, newData.getBatteryLevel());
            }
        }
        data = ScrapMultitoolData.fromItemStack(itemStack);
        return this.consumeEnergy(itemStack, MultitoolConfig.energyPerAttack);
    }

    public boolean method_7879(class_1799 itemStack, class_1937 level, class_2680 state, class_2338 pos, class_1309 entity) {
        ToolModeDetector detector;
        class_1657 player;
        if (entity instanceof class_1657) {
            player = (class_1657)entity;
            detector = new ToolModeDetector(itemStack);
            detector.updateToolMode(player, state);
        }
        if (this.consumeEnergy(itemStack, MultitoolConfig.energyPerBlock)) {
            if (entity instanceof class_1657) {
                player = (class_1657)entity;
                detector = new ToolModeDetector(itemStack);
                detector.updateToolMode(player, state);
            }
            return true;
        }
        return false;
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (player.method_5715() && !level.field_9236) {
            this.openMultitoolScreen(player, itemStack, hand);
            return class_1271.method_29237((Object)itemStack, (boolean)level.field_9236);
        }
        if (!level.field_9236) {
            ToolModeDetector detector = new ToolModeDetector(itemStack);
            class_2680 targetBlock = detector.getTargetBlock(level, player);
            detector.updateToolMode(player, targetBlock);
        }
        if (!level.field_9236 && this.hasEnergy(itemStack, MultitoolConfig.energyPerUse)) {
            class_243 playerPos = player.method_19538().method_1031(0.0, 1.0, 0.0);
            class_243 lookDirection = player.method_5720();
            class_243 particlePos = playerPos.method_1019(lookDirection.method_1021(1.5));
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                serverLevel.method_14199((class_2394)class_2398.field_29644, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 5, 0.1, 0.1, 0.1, 0.02);
            }
            level.method_8396(null, player.method_24515(), class_3417.field_14891, class_3419.field_15248, 0.5f, 1.2f);
            this.consumeEnergy(itemStack, MultitoolConfig.energyPerUse);
        }
        return class_1271.method_22430((Object)itemStack);
    }

    public class_1269 method_7884(class_1838 context) {
        class_1657 player = context.method_8036();
        if (player != null && player.method_5715()) {
            return class_1269.field_5811;
        }
        class_1799 itemStack = context.method_8041();
        if (!this.hasEnergy(itemStack, MultitoolConfig.energyPerUse)) {
            return class_1269.field_5811;
        }
        class_1937 level = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2680 state = level.method_8320(pos);
        class_2248 block = state.method_26204();
        ScrapMultitoolData data = ScrapMultitoolData.fromItemStack(itemStack);
        ToolMode activeMode = ToolMode.fromId(data.activeMode());
        class_1269 result = class_1269.field_5811;
        ToolMode usedMode = null;
        if (BlockInteractionProcessor.isCycleableBlock(block) && context.method_8038() != class_2350.field_11033) {
            result = BlockInteractionProcessor.processCycleableBlock(context, state);
            if (result.method_23665()) {
                usedMode = StrippableBlocks.isCycleableWood(block) ? ToolMode.AXE : (block == class_2246.field_10194 || state.method_26204() == class_2246.field_10362 ? ToolMode.HOE : ToolMode.SHOVEL);
            }
        } else {
            switch (activeMode) {
                case AXE: {
                    usedMode = ToolMode.AXE;
                    class_1269 class_12692 = AxeInteractionHandler.processAxeInteraction(context);
                    break;
                }
                case SHOVEL: {
                    usedMode = ToolMode.SHOVEL;
                    class_1269 class_12692 = ShovelInteractionHandler.processInteraction(context);
                    break;
                }
                case SWORD: {
                    usedMode = ToolMode.SWORD;
                    class_1269 class_12692 = SwordInteractionHandler.processInteraction(context);
                    break;
                }
                default: {
                    class_1269 class_12692 = result = class_1269.field_5811;
                }
            }
            if (result == class_1269.field_5811 && activeMode != ToolMode.AXE && (result = AxeInteractionHandler.processAxeInteraction(context)) != class_1269.field_5811) {
                usedMode = ToolMode.AXE;
            }
            if (result == class_1269.field_5811 && activeMode != ToolMode.SHOVEL && (result = ShovelInteractionHandler.processInteraction(context)) != class_1269.field_5811) {
                usedMode = ToolMode.SHOVEL;
            }
            if (result == class_1269.field_5811 && activeMode != ToolMode.SWORD && (result = SwordInteractionHandler.processInteraction(context)) != class_1269.field_5811) {
                usedMode = ToolMode.SWORD;
            }
        }
        if (result.method_23665() && usedMode != null && usedMode != activeMode) {
            ScrapMultitoolData newData = data.withActiveMode(usedMode.getId());
            newData.saveToItemStack(itemStack);
            DisplayMode displayMode = new DisplayMode(itemStack);
            displayMode.updateModel(usedMode, newData.getBatteryLevel());
            this.consumeEnergy(itemStack, MultitoolConfig.energyPerUse);
        } else if (result.method_23665()) {
            this.consumeEnergy(itemStack, MultitoolConfig.energyPerUse);
        }
        return result != class_1269.field_5811 ? result : super.method_7884(context);
    }

    private float getPoweredSpeed(ToolMode toolMode) {
        return switch (toolMode) {
            case ToolMode.PICKAXE -> 6.0f;
            case ToolMode.AXE -> 6.0f;
            case ToolMode.SHOVEL -> 6.0f;
            case ToolMode.HOE -> 4.0f;
            case ToolMode.SWORD -> 6.0f;
            default -> 6.0f;
        };
    }

    private void openMultitoolScreen(class_1657 player, class_1799 itemStack, class_1268 interactionHand) {
        if (Constants.IS_FABRIC) {
            try {
                Class<?> fabricHandlerClass = Class.forName("de.markusbordihn.scraptechworkshop.menu.ScrapMultitoolScreenHandler");
                Object fabricHandler = fabricHandlerClass.getConstructor(class_1799.class, class_1268.class).newInstance(itemStack, interactionHand);
                player.method_17355((class_3908)fabricHandler);
            }
            catch (Exception e) {
                log.error("Failed to open multitool screen on Fabric: {}", (Object)e.getMessage());
            }
        } else {
            player.method_17355((class_3908)new ScrapMultitoolMenuProvider(itemStack, interactionHand));
        }
    }

    public boolean method_31567(class_1799 itemStack) {
        return true;
    }

    public int method_31571(class_1799 itemStack) {
        EnergyData energyData = EnergyManager.getEnergyData(itemStack, MultitoolConfig.energyMax);
        float energyRatio = energyData.getPercentage();
        return energyRatio > 0.6f ? 65280 : (energyRatio > 0.3f ? 0xFFFF00 : 0xFF0000);
    }

    public void method_7851(class_1799 itemStack, class_1937 level, List<class_2561> tooltipComponents, class_1836 isAdvanced) {
        tooltipComponents.add((class_2561)class_2561.method_43471((String)"item.scrap_tech_workshop.scrap_multitool.description"));
        EnergyData energyData = EnergyManager.getEnergyData(itemStack, MultitoolConfig.energyMax);
        int displayEnergy = energyData.getDisplayEnergy();
        tooltipComponents.add((class_2561)class_2561.method_43470((String)("Energy: " + displayEnergy + "%")).method_27694(style -> style.method_36139(this.method_31571(itemStack))));
        ScrapMultitoolData data = ScrapMultitoolData.fromItemStack(itemStack);
        if (data.hasBattery()) {
            tooltipComponents.add((class_2561)class_2561.method_43470((String)"Battery: Installed").method_27694(style -> style.method_36139(65280)));
        }
        ToolMode activeMode = ToolMode.fromId(data.activeMode());
        tooltipComponents.add((class_2561)class_2561.method_43471((String)activeMode.getTranslationKey()).method_27694(style -> style.method_36139(activeMode.getColor())));
        tooltipComponents.add((class_2561)class_2561.method_43470((String)"Shift + Right-click to configure").method_27694(style -> style.method_10978(Boolean.valueOf(true))));
        super.method_7851(itemStack, level, tooltipComponents, isAdvanced);
    }

    public boolean method_7878(class_1799 toRepair, class_1799 repair) {
        return false;
    }

    public boolean method_7870(class_1799 itemStack) {
        return false;
    }
}

