/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.fishing;

import de.markusbordihn.scraptechworkshop.config.ScrapFishingConfig;
import de.markusbordihn.scraptechworkshop.item.ModItems;
import de.markusbordihn.scraptechworkshop.loot.ScrapFishingLootTables;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1787;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScrapFishingHandler {
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");

    public static void handleFishing(class_3222 serverPlayer, class_3218 serverLevel) {
        class_1799 fishingRodStack = ScrapFishingHandler.getFishingRod(serverPlayer);
        if (!fishingRodStack.method_7960()) {
            ScrapFishingHandler.handleFishing(serverPlayer, serverLevel, fishingRodStack);
        }
    }

    public static void handleFishing(class_3222 serverPlayer, class_3218 serverLevel, class_1799 fishingRodItemStack) {
        class_1799 actualRodStack;
        class_1799 class_17992 = actualRodStack = fishingRodItemStack.method_7960() ? ScrapFishingHandler.getFishingRod(serverPlayer) : fishingRodItemStack;
        if (actualRodStack.method_7960()) {
            return;
        }
        class_1792 fishingRod = actualRodStack.method_7909();
        log.debug("Fishing event triggered for player {} with rod {}", (Object)serverPlayer, (Object)fishingRod);
        int scrapChance = ScrapFishingHandler.getScrapChanceForRod(fishingRod);
        if (scrapChance > 0 && serverLevel.field_9229.method_43048(100) < scrapChance) {
            class_1799 scrapStack = ScrapFishingHandler.generateScrapItem(fishingRod, serverLevel);
            class_1542 itemEntity = new class_1542((class_1937)serverLevel, serverPlayer.method_23317(), serverPlayer.method_23318() + 0.5, serverPlayer.method_23321(), scrapStack);
            itemEntity.method_6975();
            serverLevel.method_8649((class_1297)itemEntity);
            ScrapFishingHandler.playScrapSound(serverLevel, serverPlayer, fishingRod);
            ScrapFishingHandler.logScrapFished(serverPlayer, scrapStack.method_7909(), fishingRod, scrapChance);
        }
    }

    private static class_1799 getFishingRod(class_3222 serverPlayer) {
        class_1799 mainHand = serverPlayer.method_6047();
        if (!mainHand.method_7960() && mainHand.method_7909() instanceof class_1787) {
            return mainHand;
        }
        class_1799 offHand = serverPlayer.method_6079();
        if (!offHand.method_7960() && offHand.method_7909() instanceof class_1787) {
            return offHand;
        }
        return class_1799.field_8037;
    }

    private static class_1799 generateScrapItem(class_1792 rod, class_3218 serverLevel) {
        class_1792 scrapItem = ScrapFishingHandler.getScrapItemForRod(rod, serverLevel);
        return new class_1799((class_1935)scrapItem, 1);
    }

    private static void playScrapSound(class_3218 serverLevel, class_3222 player, class_1792 rod) {
        if (!ScrapFishingConfig.enableSounds) {
            return;
        }
        float volume = ScrapFishingConfig.soundVolume;
        boolean isUpgradedRod = ScrapFishingHandler.isScrapRodOrBetter(rod);
        serverLevel.method_8396(null, player.method_24515(), isUpgradedRod ? class_3417.field_14833 : class_3417.field_14959, class_3419.field_15248, volume * (isUpgradedRod ? 0.5f : 0.3f), (isUpgradedRod ? 1.2f : 1.5f) + serverLevel.field_9229.method_43057() * (isUpgradedRod ? 0.2f : 0.3f));
    }

    private static void logScrapFished(class_3222 serverPlayer, class_1792 scrapItem, class_1792 rod, int scrapChance) {
        log.debug("Player {} fished {} with {} ({}% chance)", (Object)serverPlayer.method_5477().getString(), (Object)new class_1799((class_1935)scrapItem).method_7954().getString(), (Object)rod, (Object)scrapChance);
    }

    private static int getScrapChanceForRod(class_1792 item) {
        if (item == ModItems.MAGNET_FISHING_ROD.get()) {
            return ScrapFishingConfig.magnetRodScrapChance;
        }
        if (item == ModItems.SCRAP_FISHING_ROD.get()) {
            return ScrapFishingConfig.scrapRodScrapChance;
        }
        if (item == class_1802.field_8378) {
            return ScrapFishingConfig.vanillaRodScrapChance;
        }
        return 0;
    }

    private static boolean isScrapRodOrBetter(class_1792 item) {
        return item == ModItems.MAGNET_FISHING_ROD.get() || item == ModItems.SCRAP_FISHING_ROD.get();
    }

    private static class_1792 getScrapItemForRod(class_1792 item, class_3218 serverLevel) {
        if (item == ModItems.MAGNET_FISHING_ROD.get()) {
            return ScrapFishingLootTables.getMagnetRodLoot(serverLevel.field_9229);
        }
        if (item == ModItems.SCRAP_FISHING_ROD.get()) {
            return ScrapFishingLootTables.getScrapRodLoot(serverLevel.field_9229);
        }
        return ScrapFishingLootTables.getVanillaRodLoot(serverLevel.field_9229);
    }
}

