/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.block.entity.recycler;

import de.markusbordihn.scraptechworkshop.block.entity.AbstractWorkshopBlockEntity;
import de.markusbordihn.scraptechworkshop.block.entity.recycler.RecyclerContainer;
import de.markusbordihn.scraptechworkshop.block.entity.recycler.RecyclerState;
import de.markusbordihn.scraptechworkshop.block.entity.recycler.RecyclerTickProcessor;
import de.markusbordihn.scraptechworkshop.block.entity.recycler.RecyclerTickResult;
import de.markusbordihn.scraptechworkshop.block.recycler.RecyclerBlock;
import de.markusbordihn.scraptechworkshop.config.RecyclerConfig;
import de.markusbordihn.scraptechworkshop.data.energy.EnergyPowerData;
import de.markusbordihn.scraptechworkshop.data.recycler.RecyclerStatus;
import de.markusbordihn.scraptechworkshop.energy.EnergyPowerConsumer;
import de.markusbordihn.scraptechworkshop.item.upgrade.SpeedUpgradeItem;
import de.markusbordihn.scraptechworkshop.menu.RecyclerMenu;
import de.markusbordihn.scraptechworkshop.recipe.recycler.RecyclerRecipe;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3913;

public class RecyclerBlockEntity
extends AbstractWorkshopBlockEntity
implements EnergyPowerConsumer {
    public static final String ID = "recycler";
    private static final int ENERGY_CAPACITY_MAH = 10000;
    private static final int ENERGY_CONSUMPTION_PER_TICK = 5;
    private static final int ENERGY_CONSUMPTION_INTERVAL = 10;
    private static final int ENERGY_FLOW_DISPLAY_TICKS = 40;
    private static final String PROGRESS_TAG = "Progress";
    private static final String MAX_PROGRESS_TAG = "MaxProgress";
    private static final String NO_RECIPE_TIMER_TAG = "NoRecipeTimer";
    private static final String DONE_TIMER_TAG = "DoneTimer";
    private static final int PROGRESS_DATA_INDEX = 0;
    private static final int MAX_PROGRESS_DATA_INDEX = 1;
    private static final String TRANSLATION_KEY = "container.scrap_tech_workshop.recycler";
    public static class_2591<RecyclerBlockEntity> TYPE;
    private final RecyclerContainer container;
    private final class_3913 energyContainerData = this.createEnergyContainerData();
    private int progress = 0;
    private int maxProgress = RecyclerConfig.processTime;
    private final class_3913 containerData = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> RecyclerBlockEntity.this.progress;
                case 1 -> RecyclerBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    RecyclerBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    RecyclerBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int method_17389() {
            return 2;
        }
    };
    private EnergyPowerData energyData = EnergyPowerData.empty();
    private int noRecipeTimer = 0;
    private int doneTimer = 0;
    private RecyclerRecipe currentRecipe = null;
    private int tickCounter = 0;
    private long lastEnergyReceiveTick = 0L;
    private long lastEnergyDistributeTick = 0L;

    public RecyclerBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(TYPE, blockPos, blockState);
        this.container = new RecyclerContainer(13, this::method_5431);
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 blockState, RecyclerBlockEntity blockEntity) {
        RecyclerTickResult result;
        long currentTime;
        if (level.field_9236) {
            return;
        }
        ++blockEntity.tickCounter;
        long currentTick = currentTime = level.method_8510();
        if (blockEntity.lastEnergyReceiveTick > 0L && currentTick - blockEntity.lastEnergyReceiveTick > 40L) {
            blockEntity.energyContainerData.method_17391(4, 0);
            blockEntity.lastEnergyReceiveTick = 0L;
        }
        if (blockEntity.lastEnergyDistributeTick > 0L && currentTick - blockEntity.lastEnergyDistributeTick > 40L) {
            blockEntity.energyContainerData.method_17391(5, 0);
            blockEntity.lastEnergyDistributeTick = 0L;
        }
        blockEntity.updateEnergyFlow(currentTime);
        RecyclerStatus currentStatus = (RecyclerStatus)((Object)blockState.method_11654(RecyclerBlock.STATUS));
        boolean hasEnoughEnergy = blockEntity.getCurrentEnergy() >= 5;
        int speedMultiplier = blockEntity.getSpeedMultiplierBonus();
        RecyclerState recyclerState = new RecyclerState(level, blockPos, blockEntity.container.getItems(), blockEntity.progress, blockEntity.maxProgress, blockEntity.noRecipeTimer, blockEntity.doneTimer, blockEntity.currentRecipe, speedMultiplier, blockEntity.getCurrentEnergy(), blockEntity.tickCounter);
        if (!hasEnoughEnergy && currentStatus == RecyclerStatus.WORKING) {
            recyclerState.progress = 0;
            result = new RecyclerTickResult(RecyclerStatus.IDLE, true);
        } else {
            switch (currentStatus) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case NO_RECIPE: {
                    RecyclerTickResult recyclerTickResult = RecyclerTickProcessor.processNoRecipeStatus(recyclerState);
                    break;
                }
                case DONE: {
                    RecyclerTickResult recyclerTickResult = RecyclerTickProcessor.processDoneStatus(recyclerState);
                    break;
                }
                case IDLE: 
                case WORKING: 
                case ERROR: {
                    RecyclerTickResult recyclerTickResult = result = RecyclerTickProcessor.processActiveStatus(recyclerState, blockState);
                }
            }
            if (result.newStatus() == RecyclerStatus.WORKING && !hasEnoughEnergy) {
                recyclerState.progress = 0;
                result = new RecyclerTickResult(RecyclerStatus.IDLE, false);
            }
            if (result.newStatus() == RecyclerStatus.WORKING && hasEnoughEnergy && blockEntity.tickCounter % 10 == 0) {
                blockEntity.consumeEnergy(5);
            }
        }
        blockEntity.progress = recyclerState.progress;
        blockEntity.noRecipeTimer = recyclerState.noRecipeTimer;
        blockEntity.doneTimer = recyclerState.doneTimer;
        blockEntity.currentRecipe = recyclerState.currentRecipe;
        if (result.newStatus() != currentStatus) {
            RecyclerBlock.updateStatus(level, blockPos, result.newStatus());
        }
        if (result.hasChanged() && blockEntity.tickCounter % RecyclerConfig.progressUpdateInterval == 0) {
            blockEntity.method_5431();
        }
    }

    @Override
    public int getLastEnergyReceiveAmount() {
        return this.energyContainerData.method_17390(4);
    }

    @Override
    public void setLastEnergyReceiveAmount(int amount) {
        this.energyContainerData.method_17391(4, amount);
        if (this.field_11863 != null) {
            this.lastEnergyReceiveTick = this.field_11863.method_8510();
        }
    }

    @Override
    public int getLastEnergyDistributeAmount() {
        return this.energyContainerData.method_17390(5);
    }

    @Override
    public void setLastEnergyDistributeAmount(int amount) {
        this.energyContainerData.method_17391(5, amount);
        if (this.field_11863 != null) {
            this.lastEnergyDistributeTick = this.field_11863.method_8510();
        }
    }

    public RecyclerContainer getContainer() {
        return this.container;
    }

    @Override
    protected class_2371<class_1799> getItems() {
        return this.container.getItems();
    }

    @Override
    protected class_1278 getContainerDelegate() {
        return this.container;
    }

    @Override
    public void method_11014(class_2487 compoundTag) {
        super.method_11014(compoundTag);
        this.progress = compoundTag.method_10550(PROGRESS_TAG);
        this.maxProgress = compoundTag.method_10550(MAX_PROGRESS_TAG);
        this.noRecipeTimer = compoundTag.method_10550(NO_RECIPE_TIMER_TAG);
        this.doneTimer = compoundTag.method_10550(DONE_TIMER_TAG);
        this.loadEnergyPowerConsumer(compoundTag);
        this.energyData = this.getEnergyData();
    }

    @Override
    protected void method_11007(class_2487 compoundTag) {
        super.method_11007(compoundTag);
        compoundTag.method_10569(PROGRESS_TAG, this.progress);
        compoundTag.method_10569(MAX_PROGRESS_TAG, this.maxProgress);
        compoundTag.method_10569(NO_RECIPE_TIMER_TAG, this.noRecipeTimer);
        compoundTag.method_10569(DONE_TIMER_TAG, this.doneTimer);
        this.saveEnergyPowerConsumer(compoundTag);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)TRANSLATION_KEY);
    }

    public class_1703 createMenu(int windowId, class_1661 playerInventory, class_1657 player) {
        return new RecyclerMenu(windowId, playerInventory, this, this.containerData);
    }

    public int getRedstoneSignal() {
        if (this.maxProgress <= 0) {
            return 0;
        }
        return this.progress * 15 / this.maxProgress;
    }

    public class_3913 getContainerData() {
        return this.containerData;
    }

    private void syncToClient() {
        class_1937 currentLevel = this.method_10997();
        if (currentLevel != null && !currentLevel.field_9236) {
            currentLevel.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
        }
    }

    public void method_5431() {
        super.method_5431();
        this.syncToClient();
    }

    public class_2487 method_16887() {
        class_2487 compoundTag = new class_2487();
        this.method_11007(compoundTag);
        return compoundTag;
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    private int getSpeedMultiplierBonus() {
        int totalMultiplier = 1;
        for (int i = 10; i <= 11; ++i) {
            class_1792 class_17922;
            class_1799 stack = this.container.method_5438(i);
            if (stack.method_7960() || !((class_17922 = stack.method_7909()) instanceof SpeedUpgradeItem)) continue;
            SpeedUpgradeItem speedUpgrade = (SpeedUpgradeItem)class_17922;
            totalMultiplier += speedUpgrade.getSpeedMultiplier() - 1;
        }
        return totalMultiplier;
    }

    @Override
    public EnergyPowerData getEnergyData() {
        return this.energyData;
    }

    @Override
    public void setEnergyData(EnergyPowerData data) {
        class_1799 currentBattery = this.container.method_5438(12);
        this.energyData = data.withBattery(currentBattery);
        this.container.method_5447(12, this.energyData.battery());
        this.method_5431();
    }

    @Override
    public class_3913 getEnergyPowerData() {
        return this.energyContainerData;
    }

    @Override
    public int getEnergyCapacity() {
        return 10000;
    }

    @Override
    public void markDirty() {
        this.method_5431();
    }
}

