/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.renderer.blockentity.collectorstation;

import de.markusbordihn.scraptechworkshop.block.entity.collectorstation.CollectorStationBlockEntity;
import de.markusbordihn.scraptechworkshop.client.renderer.blockentity.collectorstation.RobotStatusHandler;
import de.markusbordihn.scraptechworkshop.config.CollectorStationConfig;
import de.markusbordihn.scraptechworkshop.data.robot.RobotRenderInfo;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3532;

public class ChargingStatusHandler
implements RobotStatusHandler {
    private static final float ROBOT_CHARGING_Y = 0.35f;
    private static final float ROBOT_HOVER_AMPLITUDE = 0.03f;
    private static final float ROBOT_HOVER_SPEED = 0.15f;
    private static final float CHARGING_THRESHOLD = 0.95f;

    @Override
    public RobotRenderInfo calculateRenderInfo(CollectorStationBlockEntity blockEntity, class_1937 level, class_2338 blockPos, class_2350 facing, float stationCenterX, float stationCenterZ, float animationTime, float partialTick) {
        int chargingTime;
        float yaw = -facing.method_10144();
        int stateTimer = blockEntity.getStateTimer();
        float chargeProgress = Math.min(1.0f, (float)stateTimer / (float)(chargingTime = CollectorStationConfig.chargingTime));
        if (chargeProgress >= 0.95f) {
            float descentProgress = (chargeProgress - 0.95f) / 0.050000012f;
            descentProgress = this.smoothStep(descentProgress);
            float targetY = 0.0f;
            float currentY = class_3532.method_16439((float)descentProgress, (float)0.35f, (float)targetY);
            return new RobotRenderInfo(stationCenterX, currentY, stationCenterZ, yaw);
        }
        float hoverOffset = class_3532.method_15374((float)(animationTime * 0.15f)) * 0.03f;
        return new RobotRenderInfo(stationCenterX, 0.35f + hoverOffset, stationCenterZ, yaw);
    }

    private float smoothStep(float t) {
        return t * t * (3.0f - 2.0f * t);
    }

    @Override
    public void spawnParticles(class_1937 level, class_2338 blockPos, RobotRenderInfo renderInfo, float partialTick) {
        if (level.method_8409().method_43057() < 0.3f) {
            double x = (double)blockPos.method_10263() + 0.5 + (level.method_8409().method_43058() - 0.5) * 0.3;
            double y = (double)((float)blockPos.method_10264() + 0.35f) + 0.2;
            double z = (double)blockPos.method_10260() + 0.5 + (level.method_8409().method_43058() - 0.5) * 0.3;
            level.method_8406((class_2394)class_2398.field_29644, x, y, z, 0.0, 0.02, 0.0);
        }
    }
}

