/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import de.markusbordihn.scraptechworkshop.Constants;
import de.markusbordihn.scraptechworkshop.client.screen.energy.EnergyPowerRenderer;
import de.markusbordihn.scraptechworkshop.data.energy.EnergyFlowStatus;
import de.markusbordihn.scraptechworkshop.menu.EnergyPowerGeneratorMenu;
import de.markusbordihn.scraptechworkshop.menu.EnergyPowerMenu;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_465;

public abstract class BaseContainerScreen<T extends class_1703>
extends class_465<T> {
    public static final int STANDARD_BACKGROUND_WIDTH = 248;
    public static final int STANDARD_BACKGROUND_HEIGHT = 166;
    public static final int PROGRESS_BAR_BACKGROUND_COLOR = -11184811;
    public static final int PROGRESS_BAR_BORDER_COLOR = -16777216;

    protected BaseContainerScreen(T menu, class_1661 playerInventory, class_2561 title) {
        super(menu, playerInventory, title);
    }

    protected void renderDefaultBackground(class_332 guiGraphics, int x, int y, int width, int height) {
        RenderSystem.setShaderTexture((int)0, (class_2960)Constants.TEXTURE_DEMO_BACKGROUND);
        int splitX = Math.min(width / 2, 124);
        int splitY = Math.min(height / 2, 83);
        guiGraphics.method_25302(Constants.TEXTURE_DEMO_BACKGROUND, x, y, 0, 0, Math.min(splitX, width), Math.min(splitY, height));
        if (width > splitX) {
            guiGraphics.method_25302(Constants.TEXTURE_DEMO_BACKGROUND, x + splitX, y, 248 - (width - splitX), 0, width - splitX, Math.min(splitY, height));
        }
        if (height > splitY) {
            guiGraphics.method_25302(Constants.TEXTURE_DEMO_BACKGROUND, x, y + splitY, 0, 166 - (height - splitY), Math.min(splitX, width), height - splitY);
        }
        if (width > splitX && height > splitY) {
            guiGraphics.method_25302(Constants.TEXTURE_DEMO_BACKGROUND, x + splitX, y + splitY, 248 - (width - splitX), 166 - (height - splitY), width - splitX, height - splitY);
        }
    }

    protected void renderSlot(class_332 guiGraphics, int x, int y) {
        RenderSystem.setShaderTexture((int)0, (class_2960)Constants.TEXTURE_INVENTORY);
        guiGraphics.method_25302(Constants.TEXTURE_INVENTORY, x - 1, y - 1, 7, 7, 18, 18);
    }

    protected void renderSlots(class_332 guiGraphics, int x, int y, int columns, int rows) {
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                this.renderSlot(guiGraphics, x + column * 18, y + row * 18);
            }
        }
    }

    protected void renderPlayerInventoryAt(class_332 guiGraphics, int x, int y, int inventoryStartY) {
        RenderSystem.setShaderTexture((int)0, (class_2960)Constants.TEXTURE_INVENTORY);
        guiGraphics.method_25302(Constants.TEXTURE_INVENTORY, x + 7, y + inventoryStartY - 1, 7, 83, 162, 54);
        guiGraphics.method_25302(Constants.TEXTURE_INVENTORY, x + 7, y + inventoryStartY + 57, 7, 141, 162, 18);
    }

    protected void renderProgressBar(class_332 guiGraphics, int x, int y, int width, int height, int current, int max, int color) {
        guiGraphics.method_25294(x, y, x + width, y + height, -11184811);
        if (max > 0 && current > 0) {
            int filledWidth = current * width / max;
            guiGraphics.method_25294(x, y, x + filledWidth, y + height, 0xFF000000 | color);
        }
        guiGraphics.method_25294(x, y, x + width, y + 1, -16777216);
        guiGraphics.method_25294(x, y + height - 1, x + width, y + height, -16777216);
        guiGraphics.method_25294(x, y, x + 1, y + height, -16777216);
        guiGraphics.method_25294(x + width - 1, y, x + width, y + height, -16777216);
    }

    protected void renderEnergyPowerUI(class_332 guiGraphics, int x, int y, int currentEnergy, int energyCapacity) {
        class_1703 class_17032 = this.field_2797;
        if (class_17032 instanceof EnergyPowerGeneratorMenu) {
            EnergyPowerGeneratorMenu generatorMenu = (EnergyPowerGeneratorMenu)class_17032;
            EnergyPowerRenderer.renderEnergyPowerUI(guiGraphics, x, y, currentEnergy, energyCapacity, generatorMenu.getEnergyFlowStatus(), generatorMenu.getEnergyReceiveAmount(), generatorMenu.getEnergyDistributeAmount(), 6);
        } else {
            class_17032 = this.field_2797;
            if (class_17032 instanceof EnergyPowerMenu) {
                EnergyPowerMenu energyPowerMenu = (EnergyPowerMenu)class_17032;
                EnergyPowerRenderer.renderEnergyPowerUI(guiGraphics, x, y, currentEnergy, energyCapacity, energyPowerMenu.getEnergyFlowStatus(), energyPowerMenu.getEnergyReceiveAmount(), energyPowerMenu.getEnergyDistributeAmount(), 6);
            } else {
                EnergyPowerRenderer.renderEnergyPowerUI(guiGraphics, x, y, currentEnergy, energyCapacity, EnergyFlowStatus.IDLE, 0, 0, 6);
            }
        }
    }

    protected void renderEnergyPowerTooltips(class_332 guiGraphics, int mouseX, int mouseY, int leftPos, int topPos, int currentEnergy, int energyCapacity, String batteryTooltipKey, int batterySlotIndex) {
        EnergyPowerRenderer.renderEnergyPowerTooltips(guiGraphics, this.field_22793, mouseX, mouseY, leftPos, topPos, currentEnergy, energyCapacity, batteryTooltipKey, this.field_2797, batterySlotIndex);
    }

    protected void method_2389(class_332 guiGraphics, float partialTick, int mouseX, int mouseY) {
        class_1703 class_17032 = this.field_2797;
        if (class_17032 instanceof EnergyPowerMenu) {
            EnergyPowerMenu energyPowerMenu = (EnergyPowerMenu)class_17032;
            this.renderEnergyPowerUI(guiGraphics, this.field_2776, this.field_2800, energyPowerMenu.getCurrentEnergy(), energyPowerMenu.getEnergyCapacity());
        } else {
            class_17032 = this.field_2797;
            if (class_17032 instanceof EnergyPowerGeneratorMenu) {
                EnergyPowerGeneratorMenu generatorMenu = (EnergyPowerGeneratorMenu)class_17032;
                this.renderEnergyPowerUI(guiGraphics, this.field_2776, this.field_2800, generatorMenu.getEnergy(), generatorMenu.getEnergyCapacity());
            }
        }
    }

    protected void method_2380(class_332 guiGraphics, int mouseX, int mouseY) {
        super.method_2380(guiGraphics, mouseX, mouseY);
        class_1703 class_17032 = this.field_2797;
        if (class_17032 instanceof EnergyPowerMenu) {
            EnergyPowerMenu energyPowerMenu = (EnergyPowerMenu)class_17032;
            this.renderEnergyPowerTooltips(guiGraphics, mouseX, mouseY, this.field_2776, this.field_2800, energyPowerMenu.getCurrentEnergy(), energyPowerMenu.getEnergyCapacity(), "gui.scrap_tech_workshop.battery_slot", energyPowerMenu.getBatterySlotIndex());
        } else {
            class_17032 = this.field_2797;
            if (class_17032 instanceof EnergyPowerGeneratorMenu) {
                EnergyPowerGeneratorMenu generatorMenu = (EnergyPowerGeneratorMenu)class_17032;
                this.renderEnergyPowerTooltips(guiGraphics, mouseX, mouseY, this.field_2776, this.field_2800, generatorMenu.getEnergy(), generatorMenu.getEnergyCapacity(), "gui.scrap_tech_workshop.battery_slot", generatorMenu.getBatterySlotIndex());
            }
        }
    }

    protected void method_2388(class_332 guiGraphics, int mouseX, int mouseY) {
        super.method_2388(guiGraphics, mouseX, mouseY);
    }
}

