/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.screen.energy;

import com.mojang.blaze3d.systems.RenderSystem;
import de.markusbordihn.scraptechworkshop.Constants;
import de.markusbordihn.scraptechworkshop.data.energy.EnergyFlowStatus;
import de.markusbordihn.scraptechworkshop.data.energy.ExternalEnergyFlowStatus;
import de.markusbordihn.scraptechworkshop.menu.EnergyPowerGeneratorMenu;
import de.markusbordihn.scraptechworkshop.menu.EnergyPowerMenu;
import java.util.ArrayList;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_7833;

public class EnergyPowerRenderer {
    public static final int TAB_WIDTH = 27;
    public static final int TAB_HEIGHT = 141;
    public static final int TAB_CORNER_HEIGHT = 10;
    public static final int SLOT_SIZE = 18;
    public static final int SLOT_BORDER = 1;
    public static final int ENERGY_BAR_X = -20;
    public static final int ENERGY_BAR_Y = 50;
    public static final int ENERGY_BAR_WIDTH = 16;
    public static final int ENERGY_BAR_HEIGHT = 60;
    public static final int ENERGY_BAR_BACKGROUND_COLOR = -14013910;
    public static final int ENERGY_BAR_FILL_COLOR = -16711936;
    public static final int ENERGY_BAR_FRAME_COLOR = -7631989;
    public static final int ENERGY_BAR_HIGHLIGHT_COLOR = -2130706433;
    public static final int ENERGY_BAR_SHADOW_COLOR = 0x40000000;
    public static final int BATTERY_CAP_WIDTH = 10;
    public static final int BATTERY_CAP_HEIGHT = 4;
    public static final int BATTERY_CAP_X_OFFSET = 3;
    public static final int BATTERY_CAP_Y_OFFSET = -5;
    public static final int STATUS_ICON_SIZE = 16;
    public static final int STATUS_ICON_X_OFFSET = -23;
    public static final int STATUS_ICON_Y_OFFSET = 25;
    public static final int TEXTURE_WIDTH = 64;
    public static final int TEXTURE_HEIGHT = 64;
    public static final int STATUS_ICON_U_OFFSET = 5;
    public static final float DEFAULT_VOLTAGE = 3.2f;
    private static final int[] receiveHistory = new int[20];
    private static final int[] distributeHistory = new int[20];
    private static final class_2960 ENERGY_POWER_GUI_TEXTURE = new class_2960("scrap_tech_workshop", "textures/gui/energy_power_gui.png");
    private static int historyIndex = 0;

    private EnergyPowerRenderer() {
    }

    public static void renderEnergyPowerUI(class_332 guiGraphics, int screenX, int screenY, int currentEnergy, int energyCapacity, EnergyFlowStatus flowStatus, int receiveAmount, int distributeAmount, int batterySlotY) {
        ExternalEnergyFlowStatus externalFlowStatus = EnergyPowerRenderer.calculateExternalFlowStatus(receiveAmount, distributeAmount);
        EnergyPowerRenderer.renderEnergyTab(guiGraphics, screenX - 27, screenY);
        EnergyPowerRenderer.renderBatterySlot(guiGraphics, screenX + -20, screenY + batterySlotY);
        EnergyPowerRenderer.renderStatusIcon(guiGraphics, screenX + -23, screenY + 25, flowStatus);
        EnergyPowerRenderer.renderEnergyBarWithFrame(guiGraphics, screenX + -20, screenY + 50, 16, 60, currentEnergy, energyCapacity);
        EnergyPowerRenderer.renderExternalFlowIcon(guiGraphics, screenX + -20, screenY + 50 + 60 + 9, externalFlowStatus);
    }

    public static void renderEnergyPowerTooltips(class_332 guiGraphics, class_327 font, int mouseX, int mouseY, int screenX, int screenY, int currentEnergy, int energyCapacity, String batteryTooltipKey, class_1703 menu, int batterySlotIndex) {
        class_1735 batterySlot;
        EnergyFlowStatus flowStatus = EnergyFlowStatus.IDLE;
        ExternalEnergyFlowStatus externalFlowStatus = ExternalEnergyFlowStatus.IDLE;
        int receiveAmount = 0;
        int distributeAmount = 0;
        if (menu instanceof EnergyPowerMenu) {
            EnergyPowerMenu energyMenu = (EnergyPowerMenu)menu;
            flowStatus = energyMenu.getEnergyFlowStatus();
            receiveAmount = energyMenu.getEnergyReceiveAmount();
            distributeAmount = energyMenu.getEnergyDistributeAmount();
            externalFlowStatus = EnergyPowerRenderer.calculateExternalFlowStatus(receiveAmount, distributeAmount);
        } else if (menu instanceof EnergyPowerGeneratorMenu) {
            EnergyPowerGeneratorMenu generatorMenu = (EnergyPowerGeneratorMenu)menu;
            flowStatus = generatorMenu.getEnergyFlowStatus();
            receiveAmount = generatorMenu.getEnergyReceiveAmount();
            distributeAmount = generatorMenu.getEnergyDistributeAmount();
            externalFlowStatus = EnergyPowerRenderer.calculateExternalFlowStatus(receiveAmount, distributeAmount);
        }
        int relativeX = mouseX - screenX;
        int relativeY = mouseY - screenY;
        if (EnergyPowerRenderer.isMouseOverArea(relativeX, relativeY, -23, 25, 16, 16)) {
            class_5250 statusTooltip = class_2561.method_43470((String)("Status: " + flowStatus.name()));
            guiGraphics.method_51438(font, (class_2561)statusTooltip, mouseX, mouseY);
        } else if (EnergyPowerRenderer.isMouseOverArea(relativeX, relativeY, -20, 112, 16, 16)) {
            ArrayList<class_5250> tooltip = new ArrayList<class_5250>();
            tooltip.add(class_2561.method_43470((String)("External: " + externalFlowStatus.name())));
            if (externalFlowStatus == ExternalEnergyFlowStatus.ENERGY_IN && receiveAmount > 0) {
                EnergyPowerRenderer.receiveHistory[EnergyPowerRenderer.historyIndex] = receiveAmount;
                int avgReceive = EnergyPowerRenderer.calculateAverage(receiveHistory);
                int perSecond = avgReceive * 20;
                tooltip.add(class_2561.method_43470((String)("\u00a7aReceiving: " + perSecond + " mAh/s")));
                tooltip.add(class_2561.method_43470((String)("\u00a78(" + receiveAmount + " mAh/tick)")));
            } else if (externalFlowStatus == ExternalEnergyFlowStatus.ENERGY_OUT && distributeAmount > 0) {
                EnergyPowerRenderer.distributeHistory[EnergyPowerRenderer.historyIndex] = distributeAmount;
                int avgDistribute = EnergyPowerRenderer.calculateAverage(distributeHistory);
                int perSecond = avgDistribute * 20;
                tooltip.add(class_2561.method_43470((String)("\u00a7cDistributing: " + perSecond + " mAh/s")));
                tooltip.add(class_2561.method_43470((String)("\u00a78(" + distributeAmount + " mAh/tick)")));
            }
            historyIndex = (historyIndex + 1) % 20;
            guiGraphics.method_51434(font, tooltip, mouseX, mouseY);
        } else if (EnergyPowerRenderer.isMouseOverArea(relativeX, relativeY, -20, 50, 16, 60)) {
            EnergyPowerRenderer.renderEnergyTooltip(guiGraphics, font, mouseX, mouseY, currentEnergy, energyCapacity);
        } else if (EnergyPowerRenderer.isMouseOverArea(relativeX, relativeY, -21, 5, 18, 18) && (batterySlot = menu.method_7611(batterySlotIndex)).method_7677().method_7960()) {
            class_5250 batteryTooltip = class_2561.method_43471((String)batteryTooltipKey);
            guiGraphics.method_51438(font, (class_2561)batteryTooltip, mouseX, mouseY);
        }
    }

    private static void renderEnergyTab(class_332 guiGraphics, int x, int y) {
        RenderSystem.setShaderTexture((int)0, (class_2960)Constants.TEXTURE_DEMO_BACKGROUND);
        RenderSystem.setShaderColor((float)0.98f, (float)0.98f, (float)0.98f, (float)1.0f);
        int cornerHeight = Math.min(70, 10);
        guiGraphics.method_25302(Constants.TEXTURE_DEMO_BACKGROUND, x, y, 0, 0, 27, cornerHeight);
        guiGraphics.method_25302(Constants.TEXTURE_DEMO_BACKGROUND, x, y + cornerHeight, 0, 5, 27, 141 - cornerHeight * 2);
        guiGraphics.method_25302(Constants.TEXTURE_DEMO_BACKGROUND, x, y + 141 - cornerHeight, 0, 166 - cornerHeight, 27, cornerHeight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void renderBatterySlot(class_332 guiGraphics, int x, int y) {
        RenderSystem.setShaderTexture((int)0, (class_2960)Constants.TEXTURE_INVENTORY);
        guiGraphics.method_25302(Constants.TEXTURE_INVENTORY, x - 1, y - 1, 7, 7, 18, 18);
    }

    private static void renderStatusIcon(class_332 guiGraphics, int x, int y, EnergyFlowStatus flowStatus) {
        RenderSystem.setShaderTexture((int)0, (class_2960)ENERGY_POWER_GUI_TEXTURE);
        int spriteIndex = flowStatus.getSpriteIndex();
        int textureY = spriteIndex * 16;
        guiGraphics.method_25290(ENERGY_POWER_GUI_TEXTURE, x, y, 5.0f, (float)textureY, 22, 16, 64, 64);
    }

    private static void renderExternalFlowIcon(class_332 guiGraphics, int x, int y, ExternalEnergyFlowStatus flowStatus) {
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        poseStack.method_22904((double)x + 8.0, (double)y + 8.0, 0.0);
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(-90.0f));
        poseStack.method_22904(-8.0, -8.0, 0.0);
        RenderSystem.setShaderTexture((int)0, (class_2960)ENERGY_POWER_GUI_TEXTURE);
        int textureY = flowStatus.getSpriteIndex() * 16;
        guiGraphics.method_25290(ENERGY_POWER_GUI_TEXTURE, 0, 0, 5.0f, (float)textureY, 22, 16, 64, 64);
        poseStack.method_22909();
    }

    public static void renderEnergyBarWithFrame(class_332 guiGraphics, int x, int y, int barWidth, int barHeight, int currentEnergy, int maxEnergy) {
        guiGraphics.method_25294(x + 3 - 1, y + -5 - 1, x + 3 + 10 + 1, y + -5 + 4 + 1, -7631989);
        guiGraphics.method_25294(x + 3, y + -5, x + 3 + 10, y + -5 + 4, -7631989);
        guiGraphics.method_25294(x - 1, y - 1, x + barWidth + 1, y + barHeight + 1, -7631989);
        guiGraphics.method_25294(x, y, x + barWidth, y + barHeight, -14013910);
        if (currentEnergy > 0 && maxEnergy > 0) {
            int fillY = y + barHeight - (int)((float)currentEnergy / (float)maxEnergy * (float)barHeight);
            guiGraphics.method_25294(x, fillY, x + barWidth, y + barHeight, -16711936);
            guiGraphics.method_25294(x, fillY, x + barWidth, fillY + 1, 0x40000000);
            guiGraphics.method_25294(x + 2, fillY + 2, x + 6, fillY + 2 + Math.max(2, (y + barHeight - fillY) / 2), -2130706433);
            guiGraphics.method_25294(x + barWidth - 2, fillY, x + barWidth, y + barHeight, 0x40000000);
        }
    }

    private static void renderEnergyTooltip(class_332 guiGraphics, class_327 font, int mouseX, int mouseY, int currentEnergy, int maxEnergy) {
        int percentage = maxEnergy > 0 ? currentEnergy * 100 / maxEnergy : 0;
        class_5250 tooltip = class_2561.method_43470((String)String.format("%d / %d mAh (%.1fV) - %d%%", currentEnergy, maxEnergy, Float.valueOf(3.2f), percentage));
        guiGraphics.method_51438(font, (class_2561)tooltip, mouseX, mouseY);
    }

    private static boolean isMouseOverArea(int mouseX, int mouseY, int areaX, int areaY, int areaWidth, int areaHeight) {
        return mouseX >= areaX && mouseX <= areaX + areaWidth && mouseY >= areaY && mouseY <= areaY + areaHeight;
    }

    private static ExternalEnergyFlowStatus calculateExternalFlowStatus(int receiveAmount, int distributeAmount) {
        if (receiveAmount > 0) {
            return ExternalEnergyFlowStatus.ENERGY_IN;
        }
        if (distributeAmount > 0) {
            return ExternalEnergyFlowStatus.ENERGY_OUT;
        }
        return ExternalEnergyFlowStatus.IDLE;
    }

    private static int calculateAverage(int[] values) {
        int sum = 0;
        int count = 0;
        for (int value : values) {
            if (value <= 0) continue;
            sum += value;
            ++count;
        }
        return count > 0 ? sum / count : 0;
    }
}

