/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.config;

import de.markusbordihn.scraptechworkshop.config.Config;
import java.io.File;
import java.util.Properties;

public class ScrapPileConfig
extends Config {
    public static final String CONFIG_FILE_NAME = "scrap_pile.cfg";
    public static final String CONFIG_FILE_HEADER = " Scrap Pile Configuration\n\n This configuration file allows you to define the general settings for the Scrap Pile system.\n\n Spawn Settings:\n - spawn_enabled: Enable/disable natural spawning of scrap piles\n - spawn_attempts_per_tick: Number of spawn attempts per game tick (keep low for performance)\n - spawn_chunk_cap: Maximum number of scrap piles per chunk\n - spawn_y_max: Maximum Y level for spawning (underground spawning)\n - spawn_interval_ticks: Time between spawn attempts in ticks (600 = 30 seconds, 1200 = 1 minute)\n - spawn_darkness_required: Whether spawning requires darkness\n\n Pile Settings:\n - max_size: Maximum size of a scrap pile (1-4)\n - decay_enabled: Enable/disable time-based decay\n - decay_chance: Chance per random tick for decay (higher = faster decay)\n - auto_pickup_enabled: Enable pickup when walking over piles\n - auto_pickup_delay_ticks: Delay in ticks between automatic pickups (default: 20 = 1 second, 0 = instant complete pickup)\n - auto_merge_enabled: Enable automatic merging of adjacent piles\n - silk_touch_enabled: Allow silk touch harvesting\n - fortune_enabled: Enable fortune enchantment effects\n\n Loot Settings:\n - Various weight settings for different scrap types\n\n";
    public static boolean spawnEnabled = true;
    public static int spawnAttemptsPerTick = 1;
    public static int spawnChunkCap = 2;
    public static int spawnYMax = 40;
    public static int spawnIntervalTicks = 600;
    public static boolean spawnDarknessRequired = true;
    public static int maxSize = 4;
    public static boolean decayEnabled = true;
    public static int decayChance = 24000;
    public static boolean autoPickupEnabled = true;
    public static int autoPickupDelayTicks = 20;
    public static boolean autoMergeEnabled = false;
    public static boolean silkTouchEnabled = true;
    public static boolean fortuneEnabled = true;
    public static int alloyScrapWeight = 12;
    public static int metalScrapWeight = 40;
    public static int ironScrapWeight = 30;
    public static int copperScrapWeight = 25;
    public static int goldScrapWeight = 10;
    public static int techScrapWeight = 20;
    public static int circuitScrapWeight = 15;
    public static int coilScrapWeight = 15;
    public static int capacitorScrapWeight = 8;
    public static int energyCellScrapWeight = 5;
    public static int crystalScrapWeight = 5;
    public static int insulationScrapWeight = 18;
    public static int luminousScrapWeight = 3;
    public static int plasticScrapWeight = 25;
    public static int woodScrapWeight = 30;

    protected ScrapPileConfig() {
    }

    public static void registerConfig() {
        ScrapPileConfig.registerConfigFile(CONFIG_FILE_NAME, CONFIG_FILE_HEADER);
        ScrapPileConfig.loadConfig();
    }

    public static void loadConfig() {
        ScrapPileConfig.parseConfigFile();
    }

    public static void parseConfigFile() {
        File configFile = ScrapPileConfig.getConfigFile(CONFIG_FILE_NAME);
        Properties properties = ScrapPileConfig.readConfigFile(configFile);
        Properties unmodifiedProperties = (Properties)properties.clone();
        spawnEnabled = ScrapPileConfig.parseConfigValue(properties, "spawn_enabled", spawnEnabled);
        spawnAttemptsPerTick = ScrapPileConfig.parseConfigValue(properties, "spawn_attempts_per_tick", spawnAttemptsPerTick);
        spawnChunkCap = ScrapPileConfig.parseConfigValue(properties, "spawn_chunk_cap", spawnChunkCap);
        spawnYMax = ScrapPileConfig.parseConfigValue(properties, "spawn_y_max", spawnYMax);
        spawnIntervalTicks = ScrapPileConfig.parseConfigValue(properties, "spawn_interval_ticks", spawnIntervalTicks);
        spawnDarknessRequired = ScrapPileConfig.parseConfigValue(properties, "spawn_darkness_required", spawnDarknessRequired);
        maxSize = ScrapPileConfig.parseConfigValue(properties, "max_size", maxSize);
        decayEnabled = ScrapPileConfig.parseConfigValue(properties, "decay_enabled", decayEnabled);
        decayChance = ScrapPileConfig.parseConfigValue(properties, "decay_chance", decayChance);
        autoPickupEnabled = ScrapPileConfig.parseConfigValue(properties, "auto_pickup_enabled", autoPickupEnabled);
        autoPickupDelayTicks = ScrapPileConfig.parseConfigValue(properties, "auto_pickup_delay_ticks", autoPickupDelayTicks);
        autoMergeEnabled = ScrapPileConfig.parseConfigValue(properties, "auto_merge_enabled", autoMergeEnabled);
        silkTouchEnabled = ScrapPileConfig.parseConfigValue(properties, "silk_touch_enabled", silkTouchEnabled);
        fortuneEnabled = ScrapPileConfig.parseConfigValue(properties, "fortune_enabled", fortuneEnabled);
        alloyScrapWeight = ScrapPileConfig.parseConfigValue(properties, "alloy_scrap_weight", alloyScrapWeight);
        metalScrapWeight = ScrapPileConfig.parseConfigValue(properties, "metal_scrap_weight", metalScrapWeight);
        ironScrapWeight = ScrapPileConfig.parseConfigValue(properties, "iron_scrap_weight", ironScrapWeight);
        copperScrapWeight = ScrapPileConfig.parseConfigValue(properties, "copper_scrap_weight", copperScrapWeight);
        goldScrapWeight = ScrapPileConfig.parseConfigValue(properties, "gold_scrap_weight", goldScrapWeight);
        techScrapWeight = ScrapPileConfig.parseConfigValue(properties, "tech_scrap_weight", techScrapWeight);
        circuitScrapWeight = ScrapPileConfig.parseConfigValue(properties, "circuit_scrap_weight", circuitScrapWeight);
        coilScrapWeight = ScrapPileConfig.parseConfigValue(properties, "coil_scrap_weight", coilScrapWeight);
        capacitorScrapWeight = ScrapPileConfig.parseConfigValue(properties, "capacitor_scrap_weight", capacitorScrapWeight);
        energyCellScrapWeight = ScrapPileConfig.parseConfigValue(properties, "energy_cell_scrap_weight", energyCellScrapWeight);
        crystalScrapWeight = ScrapPileConfig.parseConfigValue(properties, "crystal_scrap_weight", crystalScrapWeight);
        insulationScrapWeight = ScrapPileConfig.parseConfigValue(properties, "insulation_scrap_weight", insulationScrapWeight);
        luminousScrapWeight = ScrapPileConfig.parseConfigValue(properties, "luminous_scrap_weight", luminousScrapWeight);
        plasticScrapWeight = ScrapPileConfig.parseConfigValue(properties, "plastic_scrap_weight", plasticScrapWeight);
        woodScrapWeight = ScrapPileConfig.parseConfigValue(properties, "wood_scrap_weight", woodScrapWeight);
        ScrapPileConfig.updateConfigFileIfChanged(configFile, CONFIG_FILE_HEADER, properties, unmodifiedProperties);
    }
}

