/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.data.energy;

import de.markusbordihn.scraptechworkshop.data.energy.EnergySourceType;
import de.markusbordihn.scraptechworkshop.data.energy.EnergyStatus;
import net.minecraft.class_1799;
import net.minecraft.class_2487;

public record BatteryStatus(EnergyStatus status, EnergySourceType sourceType, boolean rechargeable, int cycleCount) {
    public static final String RECHARGEABLE_TAG = "Rechargeable";
    public static final String CYCLE_COUNT_TAG = "CycleCount";
    public static final String ENERGY_SOURCE_TAG = "EnergySource";
    public static final String ENERGY_STATUS_TAG = "EnergyStatus";

    public BatteryStatus(class_1799 itemStack) {
        this(BatteryStatus.readFromItemStack(itemStack));
    }

    private BatteryStatus(BatteryValues values) {
        this(values.status, values.sourceType, values.rechargeable, values.cycleCount);
    }

    private static BatteryValues readFromItemStack(class_1799 itemStack) {
        int cycleCount;
        boolean rechargeable;
        EnergySourceType sourceType;
        EnergyStatus status;
        class_2487 tag = itemStack.method_7969();
        if (tag != null) {
            status = EnergyStatus.fromId(tag.method_10558(ENERGY_STATUS_TAG));
            sourceType = EnergySourceType.fromId(tag.method_10558(ENERGY_SOURCE_TAG));
            rechargeable = tag.method_10577(RECHARGEABLE_TAG);
            cycleCount = tag.method_10550(CYCLE_COUNT_TAG);
        } else {
            status = EnergyStatus.READY;
            sourceType = EnergySourceType.BATTERY;
            rechargeable = false;
            cycleCount = 0;
        }
        return new BatteryValues(status, sourceType, rechargeable, cycleCount);
    }

    public void writeToItemStack(class_1799 itemStack) {
        class_2487 tag = itemStack.method_7948();
        tag.method_10582(ENERGY_STATUS_TAG, this.status.getId());
        tag.method_10582(ENERGY_SOURCE_TAG, this.sourceType.getId());
        tag.method_10556(RECHARGEABLE_TAG, this.rechargeable);
        tag.method_10569(CYCLE_COUNT_TAG, this.cycleCount);
    }

    public BatteryStatus withStatus(EnergyStatus newStatus) {
        return new BatteryStatus(newStatus, this.sourceType, this.rechargeable, this.cycleCount);
    }

    public BatteryStatus withCycleIncrement() {
        return new BatteryStatus(this.status, this.sourceType, this.rechargeable, this.cycleCount + 1);
    }

    public boolean canCharge() {
        return this.rechargeable && this.status != EnergyStatus.FAULTY && this.status != EnergyStatus.OVERCHARGED;
    }

    public boolean canDischarge() {
        return this.status != EnergyStatus.EMPTY && this.status != EnergyStatus.FAULTY;
    }

    public boolean isFaulty() {
        return this.status == EnergyStatus.FAULTY;
    }

    private record BatteryValues(EnergyStatus status, EnergySourceType sourceType, boolean rechargeable, int cycleCount) {
    }
}

