/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.data.energy;

import de.markusbordihn.scraptechworkshop.data.energy.EnergyFlowStatus;
import de.markusbordihn.scraptechworkshop.data.energy.ExternalEnergyFlowStatus;
import net.minecraft.class_1799;

public record EnergyPowerData(int currentEnergy, class_1799 battery, int chargeCycleCount, long lastEnergyChangeTime, int lastEnergyLevel, EnergyFlowStatus energyFlowStatus, ExternalEnergyFlowStatus externalEnergyFlowStatus) {
    public static EnergyPowerData empty() {
        return new EnergyPowerData(0, class_1799.field_8037, 0, 0L, 0, EnergyFlowStatus.NO_BATTERY, ExternalEnergyFlowStatus.IDLE);
    }

    public static EnergyPowerData withEnergy(int energy) {
        return new EnergyPowerData(energy, class_1799.field_8037, 0, 0L, energy, EnergyFlowStatus.IDLE, ExternalEnergyFlowStatus.IDLE);
    }

    public EnergyPowerData withCurrentEnergy(int newEnergy) {
        return new EnergyPowerData(newEnergy, this.battery, this.chargeCycleCount, this.lastEnergyChangeTime, this.lastEnergyLevel, this.energyFlowStatus, this.externalEnergyFlowStatus);
    }

    public EnergyPowerData withBattery(class_1799 newBattery) {
        return new EnergyPowerData(this.currentEnergy, newBattery, this.chargeCycleCount, this.lastEnergyChangeTime, this.lastEnergyLevel, this.energyFlowStatus, this.externalEnergyFlowStatus);
    }

    public EnergyPowerData withChargeCycleCount(int newCycleCount) {
        return new EnergyPowerData(this.currentEnergy, this.battery, newCycleCount, this.lastEnergyChangeTime, this.lastEnergyLevel, this.energyFlowStatus, this.externalEnergyFlowStatus);
    }

    public EnergyPowerData withLastEnergyChangeTime(long newTime) {
        return new EnergyPowerData(this.currentEnergy, this.battery, this.chargeCycleCount, newTime, this.lastEnergyLevel, this.energyFlowStatus, this.externalEnergyFlowStatus);
    }

    public EnergyPowerData withLastEnergyLevel(int newLevel) {
        return new EnergyPowerData(this.currentEnergy, this.battery, this.chargeCycleCount, this.lastEnergyChangeTime, newLevel, this.energyFlowStatus, this.externalEnergyFlowStatus);
    }

    public EnergyPowerData withEnergyFlowStatus(EnergyFlowStatus newStatus) {
        return new EnergyPowerData(this.currentEnergy, this.battery, this.chargeCycleCount, this.lastEnergyChangeTime, this.lastEnergyLevel, newStatus, this.externalEnergyFlowStatus);
    }

    public EnergyPowerData withExternalEnergyFlowStatus(ExternalEnergyFlowStatus newStatus) {
        return new EnergyPowerData(this.currentEnergy, this.battery, this.chargeCycleCount, this.lastEnergyChangeTime, this.lastEnergyLevel, this.energyFlowStatus, newStatus);
    }
}

