/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.energy;

import net.minecraft.class_1799;

public interface EnergyCell {
    public int getCapacity();

    public int getChargeRate();

    public int getDischargeRate();

    public class_1799 createEmptyBattery();

    default public int getEnergy(class_1799 itemStack) {
        if (itemStack.method_7919() > this.getCapacity() - 1) {
            itemStack.method_7974(this.getCapacity() - 1);
        }
        return Math.max(1, this.getCapacity() - itemStack.method_7919());
    }

    default public void setEnergy(class_1799 itemStack, int energy) {
        itemStack.method_7974(Math.min(this.getCapacity() - Math.max(1, Math.min(energy, this.getCapacity())), this.getCapacity() - 1));
    }

    default public void consumeEnergy(class_1799 itemStack, int amount) {
        this.setEnergy(itemStack, Math.max(1, this.getEnergy(itemStack) - amount));
    }

    default public boolean hasEnergy(class_1799 itemStack, int amount) {
        return this.getEnergy(itemStack) >= amount;
    }

    default public int addEnergy(class_1799 itemStack, int amount) {
        int currentEnergy = this.getEnergy(itemStack);
        int transferAmount = Math.min(amount, this.getChargeRate());
        int newEnergy = Math.min(this.getCapacity(), currentEnergy + transferAmount);
        this.setEnergy(itemStack, newEnergy);
        return newEnergy - currentEnergy;
    }

    default public int addEnergy(class_1799 itemStack) {
        return this.addEnergy(itemStack, this.getChargeRate());
    }

    default public int extractEnergy(class_1799 itemStack, int maxAmount) {
        int currentEnergy = this.getEnergy(itemStack);
        int amount = Math.min(maxAmount, Math.min(currentEnergy - 1, this.getDischargeRate()));
        if (amount > 0) {
            this.consumeEnergy(itemStack, amount);
        }
        return amount;
    }

    default public int extractEnergy(class_1799 itemStack) {
        return this.extractEnergy(itemStack, this.getDischargeRate());
    }

    default public float getEnergyPercentage(class_1799 itemStack) {
        return (float)this.getEnergy(itemStack) / (float)this.getCapacity();
    }

    default public int method_31571(class_1799 itemStack) {
        float energyRatio = this.getEnergyPercentage(itemStack);
        return energyRatio > 0.6f ? 65280 : (energyRatio > 0.3f ? 0xFFFF00 : 0xFF0000);
    }
}

