/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.energy;

import de.markusbordihn.scraptechworkshop.data.energy.BatteryStatus;
import de.markusbordihn.scraptechworkshop.data.energy.EnergyData;
import de.markusbordihn.scraptechworkshop.data.energy.EnergyStatus;
import de.markusbordihn.scraptechworkshop.energy.EnergyCell;
import de.markusbordihn.scraptechworkshop.item.component.EnergyCellItem;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

public final class EnergyManager {
    private EnergyManager() {
    }

    public static EnergyData getEnergyData(class_1799 itemStack, int maxEnergy) {
        return new EnergyData(itemStack, maxEnergy);
    }

    public static BatteryStatus getBatteryStatus(class_1799 itemStack) {
        return new BatteryStatus(itemStack);
    }

    public static void setEnergy(class_1799 itemStack, int maxEnergy, int energy) {
        EnergyData energyData = new EnergyData(Math.max(1, Math.min(energy, maxEnergy)), maxEnergy, 100);
        energyData.writeToItemStack(itemStack);
        EnergyManager.updateBatteryStatus(itemStack, energyData);
    }

    private static void updateBatteryStatus(class_1799 itemStack, EnergyData energyData) {
        BatteryStatus currentStatus = EnergyManager.getBatteryStatus(itemStack);
        EnergyStatus newStatus = EnergyStatus.fromEnergyLevel(energyData.current(), energyData.maximum());
        if (currentStatus.status() != newStatus) {
            BatteryStatus updatedStatus = currentStatus.withStatus(newStatus);
            updatedStatus.writeToItemStack(itemStack);
        }
    }

    public static boolean hasEnergyFromBattery(class_1799 itemStack, int maxEnergy, class_1799 battery, int amount) {
        class_1792 class_17922 = battery.method_7909();
        if (!(class_17922 instanceof EnergyCellItem)) {
            return false;
        }
        EnergyCellItem batteryItem = (EnergyCellItem)class_17922;
        return batteryItem.getEnergy(battery) >= amount;
    }

    public static void syncEnergyWithBattery(class_1799 itemStack, int maxEnergy, class_1799 battery) {
        class_1792 class_17922 = battery.method_7909();
        if (class_17922 instanceof EnergyCell) {
            EnergyCell cell = (EnergyCell)class_17922;
            int batteryEnergy = cell.getEnergy(battery);
            if (batteryEnergy <= 1) {
                EnergyManager.setEnergy(itemStack, maxEnergy, 0);
                return;
            }
            float energyRatio = (float)batteryEnergy / (float)cell.getCapacity();
            int multitoolEnergy = Math.round((float)maxEnergy * energyRatio);
            EnergyManager.setEnergy(itemStack, maxEnergy, multitoolEnergy);
        } else {
            EnergyManager.setEnergy(itemStack, maxEnergy, 0);
        }
    }
}

