/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.energy;

import de.markusbordihn.scraptechworkshop.data.energy.ChargingMode;
import de.markusbordihn.scraptechworkshop.data.energy.EnergyFlowStatus;
import de.markusbordihn.scraptechworkshop.energy.EnergyBatteryHandler;
import de.markusbordihn.scraptechworkshop.energy.EnergyCell;
import de.markusbordihn.scraptechworkshop.item.component.EmptyEnergyCellBlockItem;
import de.markusbordihn.scraptechworkshop.item.component.EmptyEnergyCellItem;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

public interface EnergyPowerBatteryHandler
extends EnergyBatteryHandler {
    public int getChargeCycleCount();

    public void setChargeCycleCount(int var1);

    public long getLastEnergyChangeTime();

    public void setLastEnergyChangeTime(long var1);

    public int getLastEnergyLevel();

    public void setLastEnergyLevel(int var1);

    public EnergyFlowStatus getEnergyFlowStatus();

    public void setEnergyFlowStatus(EnergyFlowStatus var1);

    default public ChargingMode getChargingMode() {
        int cycles = this.getChargeCycleCount();
        for (ChargingMode mode : ChargingMode.values()) {
            if (cycles >= mode.getCycleLimit()) continue;
            return mode;
        }
        return ChargingMode.CONSERVATION;
    }

    default public boolean shouldCharge(long currentTime) {
        return currentTime - this.getLastEnergyChangeTime() > 40L;
    }

    default public void updateEnergyFlow(long currentTime) {
        class_1799 battery = this.getBattery();
        EnergyFlowStatus currentStatus = this.getEnergyFlowStatus();
        if (battery.method_7960()) {
            if (currentStatus != EnergyFlowStatus.NO_BATTERY) {
                this.setEnergyFlowStatus(EnergyFlowStatus.NO_BATTERY);
                this.setLastEnergyLevel(0);
                this.markDirty();
            }
            return;
        }
        if (battery.method_7909() instanceof EmptyEnergyCellItem || battery.method_7909() instanceof EmptyEnergyCellBlockItem) {
            if (currentStatus != EnergyFlowStatus.IDLE) {
                this.setEnergyFlowStatus(EnergyFlowStatus.IDLE);
                this.setLastEnergyLevel(0);
                this.markDirty();
            }
            return;
        }
        class_1792 class_17922 = battery.method_7909();
        if (!(class_17922 instanceof EnergyCell)) {
            if (currentStatus != EnergyFlowStatus.NO_BATTERY) {
                this.setEnergyFlowStatus(EnergyFlowStatus.NO_BATTERY);
                this.setLastEnergyLevel(0);
                this.markDirty();
            }
            return;
        }
        EnergyCell cell = (EnergyCell)class_17922;
        int batteryEnergy = cell.getEnergy(battery);
        int lastBatteryEnergy = this.getLastEnergyLevel();
        int hysteresisEnergy = this.getEnergyCapacity() * this.getChargingMode().getHysteresisPercentage() / 100;
        int targetEnergy = this.getEnergyCapacity() * this.getChargingMode().getTargetPercentage() / 100;
        EnergyFlowStatus newStatus = currentStatus;
        if (batteryEnergy > lastBatteryEnergy) {
            newStatus = EnergyFlowStatus.INTERNAL_TO_BATTERY;
            if (this.shouldCharge(currentTime)) {
                this.setLastEnergyLevel(batteryEnergy);
                this.setLastEnergyChangeTime(currentTime);
            }
        } else if (batteryEnergy < lastBatteryEnergy) {
            newStatus = EnergyFlowStatus.BATTERY_TO_INTERNAL;
            if (this.shouldCharge(currentTime)) {
                this.setLastEnergyLevel(batteryEnergy);
                this.setLastEnergyChangeTime(currentTime);
            }
        } else if (this.getCurrentEnergy() < hysteresisEnergy && batteryEnergy > 1 && this.shouldCharge(currentTime)) {
            int extracted = cell.extractEnergy(battery);
            if (extracted > 0) {
                int oldEnergy = this.getCurrentEnergy();
                this.setCurrentEnergy(oldEnergy + extracted);
                newStatus = EnergyFlowStatus.BATTERY_TO_INTERNAL;
                if (oldEnergy < hysteresisEnergy && this.getCurrentEnergy() >= targetEnergy) {
                    this.setChargeCycleCount(this.getChargeCycleCount() + 1);
                }
                if (cell.getEnergy(battery) <= 1) {
                    this.setBattery(cell.createEmptyBattery());
                } else {
                    this.setBattery(battery);
                }
                this.setLastEnergyLevel(cell.getEnergy(battery));
                this.setLastEnergyChangeTime(currentTime);
                this.markDirty();
            }
        } else if (this.getCurrentEnergy() >= hysteresisEnergy && batteryEnergy < cell.getCapacity()) {
            int transferred;
            if ((this.getCurrentEnergy() >= this.getEnergyCapacity() || currentStatus == EnergyFlowStatus.INTERNAL_TO_BATTERY && this.getCurrentEnergy() >= hysteresisEnergy) && (transferred = cell.addEnergy(battery, this.getCurrentEnergy() - hysteresisEnergy + 1)) > 0) {
                this.setCurrentEnergy(this.getCurrentEnergy() - transferred);
                this.setBattery(battery);
                newStatus = EnergyFlowStatus.INTERNAL_TO_BATTERY;
                if (this.shouldCharge(currentTime)) {
                    this.setLastEnergyLevel(cell.getEnergy(battery));
                    this.setLastEnergyChangeTime(currentTime);
                }
                this.markDirty();
            }
        } else if (this.shouldCharge(currentTime) && batteryEnergy == lastBatteryEnergy && currentStatus != EnergyFlowStatus.IDLE) {
            newStatus = EnergyFlowStatus.IDLE;
            this.setLastEnergyChangeTime(currentTime);
        }
        if (newStatus != currentStatus) {
            this.setEnergyFlowStatus(newStatus);
            this.markDirty();
        }
    }
}

