/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.energy;

import de.markusbordihn.scraptechworkshop.data.energy.EnergyFlowStatus;
import de.markusbordihn.scraptechworkshop.data.energy.EnergyPowerData;
import de.markusbordihn.scraptechworkshop.data.energy.ExternalEnergyFlowStatus;
import de.markusbordihn.scraptechworkshop.energy.EnergyBatteryHandler;
import de.markusbordihn.scraptechworkshop.energy.EnergyCell;
import de.markusbordihn.scraptechworkshop.energy.EnergyPowerBatteryHandler;
import de.markusbordihn.scraptechworkshop.energy.EnergyPowerConsumer;
import de.markusbordihn.scraptechworkshop.item.ModItems;
import de.markusbordihn.scraptechworkshop.item.component.EmptyEnergyCellBlockItem;
import de.markusbordihn.scraptechworkshop.item.component.EmptyEnergyCellItem;
import java.lang.reflect.Method;
import java.util.ArrayList;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_3913;

public interface EnergyPowerGenerator
extends EnergyBatteryHandler {
    public static final String ENERGY_TAG = "Energy";
    public static final String BATTERY_TAG = "Battery";
    public static final int TICKS_PER_SECOND = 20;

    @Override
    public int getEnergyCapacity();

    @Override
    public void markDirty();

    public EnergyPowerData getEnergyData();

    public void setEnergyData(EnergyPowerData var1);

    public int getLastEnergyReceiveAmount();

    public void setLastEnergyReceiveAmount(int var1);

    public int getLastEnergyDistributeAmount();

    public void setLastEnergyDistributeAmount(int var1);

    @Override
    default public int getCurrentEnergy() {
        return this.getEnergyData().currentEnergy();
    }

    @Override
    default public void setCurrentEnergy(int energy) {
        this.setEnergyData(this.getEnergyData().withCurrentEnergy(energy));
    }

    @Override
    default public class_1799 getBattery() {
        return this.getEnergyData().battery();
    }

    @Override
    default public void setBattery(class_1799 battery) {
        this.setEnergyData(this.getEnergyData().withBattery(battery));
    }

    default public ExternalEnergyFlowStatus getExternalEnergyFlowStatus() {
        return this.getEnergyData().externalEnergyFlowStatus();
    }

    default public void setExternalEnergyFlowStatus(ExternalEnergyFlowStatus status) {
        this.setEnergyData(this.getEnergyData().withExternalEnergyFlowStatus(status));
    }

    default public void resetEnergyFlowAmounts() {
        if (this.getLastEnergyReceiveAmount() != 0 || this.getLastEnergyDistributeAmount() != 0) {
            this.setLastEnergyReceiveAmount(0);
            this.setLastEnergyDistributeAmount(0);
        }
    }

    default public int getEnergyTransferRate() {
        return 50;
    }

    default public class_3913 createEnergyContainerData() {
        return new class_3913(){
            private int lastReceiveAmount = 0;
            private int lastDistributeAmount = 0;

            public int method_17390(int index) {
                return switch (index) {
                    case 0 -> EnergyPowerGenerator.this.getCurrentEnergy();
                    case 1 -> EnergyPowerGenerator.this.getEnergyCapacity();
                    case 2 -> {
                        EnergyPowerGenerator var3_2 = EnergyPowerGenerator.this;
                        if (var3_2 instanceof EnergyPowerBatteryHandler) {
                            EnergyPowerBatteryHandler handler = (EnergyPowerBatteryHandler)((Object)var3_2);
                            yield handler.getEnergyFlowStatus().ordinal();
                        }
                        yield 0;
                    }
                    case 3 -> EnergyPowerGenerator.this.getEnergyData().externalEnergyFlowStatus().ordinal();
                    case 4 -> this.lastReceiveAmount;
                    case 5 -> this.lastDistributeAmount;
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: {
                        EnergyPowerGenerator.this.setCurrentEnergy(value);
                        break;
                    }
                    case 2: {
                        EnergyPowerGenerator energyPowerGenerator = EnergyPowerGenerator.this;
                        if (!(energyPowerGenerator instanceof EnergyPowerBatteryHandler)) break;
                        EnergyPowerBatteryHandler handler = (EnergyPowerBatteryHandler)((Object)energyPowerGenerator);
                        EnergyFlowStatus[] statuses = EnergyFlowStatus.values();
                        if (value < 0 || value >= statuses.length) break;
                        handler.setEnergyFlowStatus(statuses[value]);
                        break;
                    }
                    case 3: {
                        ExternalEnergyFlowStatus[] statuses = ExternalEnergyFlowStatus.values();
                        if (value < 0 || value >= statuses.length) break;
                        EnergyPowerGenerator.this.setEnergyData(EnergyPowerGenerator.this.getEnergyData().withExternalEnergyFlowStatus(statuses[value]));
                        break;
                    }
                    case 4: {
                        this.lastReceiveAmount = value;
                        break;
                    }
                    case 5: {
                        this.lastDistributeAmount = value;
                    }
                }
            }

            public int method_17389() {
                return 6;
            }
        };
    }

    public class_3913 getEnergyPowerData();

    default public int getAdaptiveTransferRate(int baseTransferRate) {
        if (this.getCurrentEnergy() > baseTransferRate) {
            return baseTransferRate;
        }
        return Math.max(1, baseTransferRate / 20);
    }

    default public boolean generateEnergy(int amount) {
        int energyToAdd = Math.min(amount, this.getEnergyCapacity() - this.getCurrentEnergy());
        if (energyToAdd > 0) {
            this.setCurrentEnergy(this.getCurrentEnergy() + energyToAdd);
            return true;
        }
        return false;
    }

    default public int extractEnergy(int amount, boolean simulate) {
        int energyExtracted = Math.min(amount, this.getCurrentEnergy());
        if (!simulate && energyExtracted > 0) {
            this.setCurrentEnergy(this.getCurrentEnergy() - energyExtracted);
        }
        return energyExtracted;
    }

    default public void loadEnergyPowerGenerator(class_2487 compoundTag) {
        int energy = compoundTag.method_10550(ENERGY_TAG);
        class_1799 battery = class_1799.field_8037;
        if (compoundTag.method_10545(BATTERY_TAG)) {
            battery = class_1799.method_7915((class_2487)compoundTag.method_10562(BATTERY_TAG));
        }
        EnergyPowerData data = EnergyPowerData.withEnergy(energy).withBattery(battery);
        if (this instanceof EnergyPowerBatteryHandler) {
            if (compoundTag.method_10545("ChargeCycleCount")) {
                data = data.withChargeCycleCount(compoundTag.method_10550("ChargeCycleCount"));
            }
            if (compoundTag.method_10545("LastEnergyChangeTime")) {
                data = data.withLastEnergyChangeTime(compoundTag.method_10537("LastEnergyChangeTime"));
            }
            if (compoundTag.method_10545("LastEnergyLevel")) {
                data = data.withLastEnergyLevel(compoundTag.method_10550("LastEnergyLevel"));
            }
            if (compoundTag.method_10545("EnergyFlowStatus")) {
                int statusOrdinal = compoundTag.method_10550("EnergyFlowStatus");
                EnergyFlowStatus[] statuses = EnergyFlowStatus.values();
                if (statusOrdinal >= 0 && statusOrdinal < statuses.length) {
                    data = data.withEnergyFlowStatus(statuses[statusOrdinal]);
                }
            }
        }
        this.setEnergyData(data);
    }

    default public void saveEnergyPowerGenerator(class_2487 compoundTag) {
        EnergyPowerData data = this.getEnergyData();
        compoundTag.method_10569(ENERGY_TAG, data.currentEnergy());
        if (!data.battery().method_7960()) {
            class_2487 batteryTag = new class_2487();
            data.battery().method_7953(batteryTag);
            compoundTag.method_10566(BATTERY_TAG, (class_2520)batteryTag);
        }
        if (this instanceof EnergyPowerBatteryHandler) {
            compoundTag.method_10569("ChargeCycleCount", data.chargeCycleCount());
            compoundTag.method_10544("LastEnergyChangeTime", data.lastEnergyChangeTime());
            compoundTag.method_10569("LastEnergyLevel", data.lastEnergyLevel());
            compoundTag.method_10569("EnergyFlowStatus", data.energyFlowStatus().ordinal());
        }
    }

    default public int distributeToPlatformEnergySystem(class_1937 level, class_2338 blockPos, int availableEnergy, int maxTransferRate) {
        try {
            Class<?> distributorClass = Class.forName("de.markusbordihn.scraptechworkshop.energy.compat.EnergyDistributor");
            Method method = distributorClass.getMethod("distributeToAdjacentBlocks", class_1937.class, class_2338.class, Integer.TYPE, Integer.TYPE);
            Object result = method.invoke(null, level, blockPos, availableEnergy, maxTransferRate);
            return (Integer)result;
        }
        catch (Exception e) {
            return 0;
        }
    }

    default public int distributeEnergy(class_1937 level, class_2338 blockPos, int chargingBatterySlot, int maxTransferRate) {
        EnergyPowerGenerator energyPowerGenerator;
        class_1263 container;
        class_1799 battery;
        int batterySpace;
        EnergyPowerGenerator energyPowerGenerator2;
        if (level == null || level.field_9236) {
            return 0;
        }
        int availableEnergy = this.getCurrentEnergy();
        if (availableEnergy <= 0) {
            return 0;
        }
        int totalDistributed = 0;
        int platformDistributed = this.distributeToPlatformEnergySystem(level, blockPos, availableEnergy, maxTransferRate);
        if (platformDistributed > 0) {
            this.extractEnergy(platformDistributed, false);
            totalDistributed += platformDistributed;
            availableEnergy -= platformDistributed;
            this.markDirty();
        }
        ArrayList<EnergyConsumerInfo> consumers = new ArrayList<EnergyConsumerInfo>();
        for (class_2350 direction : class_2350.values()) {
            int spaceAvailable;
            EnergyPowerConsumer consumer;
            class_2338 adjacentPos = blockPos.method_10093(direction);
            class_2586 blockEntity = level.method_8321(adjacentPos);
            if (!(blockEntity instanceof EnergyPowerConsumer) || !(consumer = (EnergyPowerConsumer)blockEntity).canAcceptExternalEnergy() || (spaceAvailable = consumer.getTotalSpaceAvailable()) <= 0) continue;
            consumers.add(new EnergyConsumerInfo(consumer, spaceAvailable));
        }
        if (chargingBatterySlot >= 0 && (energyPowerGenerator2 = this) instanceof class_1263 && (batterySpace = this.getBatterySpaceAvailable(battery = (container = (class_1263)energyPowerGenerator2).method_5438(chargingBatterySlot))) > 0) {
            consumers.add(new EnergyConsumerInfo(container, chargingBatterySlot, battery, batterySpace));
        }
        if (!consumers.isEmpty()) {
            int totalSpace = consumers.stream().mapToInt(c -> c.spaceAvailable).sum();
            int energyToDistribute = Math.min(Math.min(availableEnergy, maxTransferRate), totalSpace);
            if (energyToDistribute > 0) {
                int remainingEnergy = energyToDistribute;
                for (int i = 0; i < consumers.size(); ++i) {
                    int energyForThis;
                    EnergyConsumerInfo consumer = (EnergyConsumerInfo)consumers.get(i);
                    if (i == consumers.size() - 1) {
                        energyForThis = Math.min(remainingEnergy, consumer.spaceAvailable);
                    } else {
                        energyForThis = Math.min(energyToDistribute * consumer.spaceAvailable / totalSpace, consumer.spaceAvailable);
                        energyForThis = Math.min(energyForThis, remainingEnergy);
                    }
                    if (energyForThis <= 0) continue;
                    int actualTransferred = consumer.receiveEnergy(energyForThis);
                    totalDistributed += actualTransferred;
                    remainingEnergy -= actualTransferred;
                }
                if (totalDistributed > platformDistributed) {
                    this.extractEnergy(totalDistributed - platformDistributed, false);
                    this.markDirty();
                }
            }
        }
        if ((energyPowerGenerator = this) instanceof EnergyPowerBatteryHandler) {
            EnergyPowerBatteryHandler batteryHandler = (EnergyPowerBatteryHandler)((Object)energyPowerGenerator);
            this.chargeEnergyTabBattery(batteryHandler);
        }
        this.setLastEnergyDistributeAmount(totalDistributed);
        if (totalDistributed > 0) {
            this.setExternalEnergyFlowStatus(ExternalEnergyFlowStatus.ENERGY_OUT);
            this.markDirty();
        }
        return totalDistributed;
    }

    default public void chargeEnergyTabBattery(EnergyPowerBatteryHandler handler) {
        EnergyCell cell;
        int batteryEnergy;
        class_1799 battery = handler.getBattery();
        if (battery.method_7960()) {
            return;
        }
        int capacity = this.getEnergyCapacity();
        if (battery.method_7909() instanceof EmptyEnergyCellBlockItem) {
            class_1799 chargedBattery;
            class_1792 class_17922;
            if (this.getCurrentEnergy() >= capacity && (class_17922 = (chargedBattery = new class_1799((class_1935)ModItems.ENERGY_CELL_BLOCK.get())).method_7909()) instanceof EnergyCell) {
                EnergyCell energyCell = (EnergyCell)class_17922;
                int energyToAdd = Math.min(this.getCurrentEnergy() - capacity + 1, energyCell.getCapacity());
                energyCell.setEnergy(chargedBattery, energyToAdd);
                handler.setBattery(chargedBattery);
                this.setCurrentEnergy(this.getCurrentEnergy() - energyToAdd);
                this.markDirty();
            }
            return;
        }
        if (battery.method_7909() instanceof EmptyEnergyCellItem) {
            class_1799 chargedBattery;
            class_1792 energyToAdd;
            if (this.getCurrentEnergy() >= capacity && (energyToAdd = (chargedBattery = new class_1799((class_1935)ModItems.ENERGY_CELL.get())).method_7909()) instanceof EnergyCell) {
                EnergyCell energyCell = (EnergyCell)energyToAdd;
                int energyToAdd2 = Math.min(this.getCurrentEnergy() - capacity + 1, energyCell.getCapacity());
                energyCell.setEnergy(chargedBattery, energyToAdd2);
                handler.setBattery(chargedBattery);
                this.setCurrentEnergy(this.getCurrentEnergy() - energyToAdd2);
                this.markDirty();
            }
            return;
        }
        class_1792 energyCell = battery.method_7909();
        if (energyCell instanceof EnergyCell && (batteryEnergy = (cell = (EnergyCell)energyCell).getEnergy(battery)) < cell.getCapacity()) {
            int transferred;
            int targetEnergy = capacity * handler.getChargingMode().getTargetPercentage() / 100;
            if (this.getCurrentEnergy() > targetEnergy && (transferred = cell.addEnergy(battery, this.getCurrentEnergy() - targetEnergy)) > 0) {
                this.setCurrentEnergy(this.getCurrentEnergy() - transferred);
                handler.setBattery(battery);
                this.markDirty();
            }
        }
    }

    default public int getBatterySpaceAvailable(class_1799 battery) {
        if (battery.method_7960()) {
            return 0;
        }
        if (battery.method_7909() instanceof EmptyEnergyCellBlockItem) {
            class_1799 tempCell = new class_1799((class_1935)ModItems.ENERGY_CELL_BLOCK.get());
            class_1792 class_17922 = tempCell.method_7909();
            if (class_17922 instanceof EnergyCell) {
                EnergyCell cell = (EnergyCell)class_17922;
                return cell.getCapacity();
            }
            return 10000;
        }
        if (battery.method_7909() instanceof EmptyEnergyCellItem) {
            class_1799 tempCell = new class_1799((class_1935)ModItems.ENERGY_CELL.get());
            class_1792 class_17923 = tempCell.method_7909();
            if (class_17923 instanceof EnergyCell) {
                EnergyCell cell = (EnergyCell)class_17923;
                return cell.getCapacity();
            }
            return 5000;
        }
        class_1792 cell = battery.method_7909();
        if (cell instanceof EnergyCell) {
            EnergyCell cell2 = (EnergyCell)cell;
            int currentEnergy = cell2.getEnergy(battery);
            return cell2.getCapacity() - currentEnergy;
        }
        return 0;
    }

    public static class EnergyConsumerInfo {
        private final EnergyPowerConsumer blockConsumer;
        private final class_1263 batteryContainer;
        private final int batterySlot;
        private final class_1799 battery;
        private final int spaceAvailable;

        public EnergyConsumerInfo(EnergyPowerConsumer consumer, int spaceAvailable) {
            this.blockConsumer = consumer;
            this.batteryContainer = null;
            this.batterySlot = -1;
            this.battery = null;
            this.spaceAvailable = spaceAvailable;
        }

        public EnergyConsumerInfo(class_1263 container, int slot, class_1799 battery, int spaceAvailable) {
            this.blockConsumer = null;
            this.batteryContainer = container;
            this.batterySlot = slot;
            this.battery = battery;
            this.spaceAvailable = spaceAvailable;
        }

        public int receiveEnergy(int amount) {
            if (this.blockConsumer != null) {
                return this.blockConsumer.receiveEnergy(amount, false);
            }
            if (this.battery != null && this.batteryContainer != null) {
                return this.chargeBatteryItem(this.batteryContainer, this.batterySlot, this.battery, amount);
            }
            return 0;
        }

        private int chargeBatteryItem(class_1263 container, int slot, class_1799 battery, int amount) {
            if (battery.method_7909() instanceof EmptyEnergyCellBlockItem) {
                class_1799 chargedBattery = new class_1799((class_1935)ModItems.ENERGY_CELL_BLOCK.get());
                class_1792 class_17922 = chargedBattery.method_7909();
                if (class_17922 instanceof EnergyCell) {
                    EnergyCell energyCell = (EnergyCell)class_17922;
                    int energyToAdd = Math.min(amount, energyCell.getCapacity());
                    energyCell.setEnergy(chargedBattery, energyToAdd);
                    container.method_5447(slot, chargedBattery);
                    return energyToAdd;
                }
            } else if (battery.method_7909() instanceof EmptyEnergyCellItem) {
                class_1799 chargedBattery = new class_1799((class_1935)ModItems.ENERGY_CELL.get());
                class_1792 energyToAdd = chargedBattery.method_7909();
                if (energyToAdd instanceof EnergyCell) {
                    EnergyCell energyCell = (EnergyCell)energyToAdd;
                    int energyToAdd2 = Math.min(amount, energyCell.getCapacity());
                    energyCell.setEnergy(chargedBattery, energyToAdd2);
                    container.method_5447(slot, chargedBattery);
                    return energyToAdd2;
                }
            } else {
                class_1792 chargedBattery = battery.method_7909();
                if (chargedBattery instanceof EnergyCell) {
                    EnergyCell cell = (EnergyCell)chargedBattery;
                    int energyToAdd = Math.min(amount, cell.getCapacity() - cell.getEnergy(battery));
                    cell.setEnergy(battery, cell.getEnergy(battery) + energyToAdd);
                    return energyToAdd;
                }
            }
            return 0;
        }
    }
}

