/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.environment;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;

public class WindCalculator {
    private static final int MIN_HEIGHT = 64;
    private static final int OPTIMAL_HEIGHT = 150;
    private static final int MAX_WIND_SPEED = 250;
    private static final class_2350[] HORIZONTAL_DIRECTIONS = new class_2350[]{class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039};

    public static int calculateWindSpeed(class_1937 level, class_2338 pos) {
        if (level == null || pos == null || !level.method_8311(pos)) {
            return 0;
        }
        int baseSpeed = 80;
        int height = pos.method_10264();
        if (height > 64) {
            int heightDiff = Math.min(height - 64, 86);
            int heightBonus = (int)((double)heightDiff * 0.7);
            baseSpeed += heightBonus;
        }
        float directObstructionPenalty = WindCalculator.calculateDirectObstruction(level, pos);
        baseSpeed = (int)((float)baseSpeed * (1.0f - directObstructionPenalty));
        int opennessBonus = (int)(WindCalculator.calculateOpenness(level, pos) * 40.0f);
        baseSpeed += opennessBonus;
        int chunkX = pos.method_10263() >> 4;
        int chunkZ = pos.method_10260() >> 4;
        int chunkVariation = (int)(((long)chunkX * 31L + (long)chunkZ & Integer.MAX_VALUE) % 30L) - 15;
        baseSpeed += chunkVariation;
        float timeModifier = 1.0f + 0.2f * (float)Math.sin((double)(level.method_8532() % 24000L) / 24000.0 * Math.PI * 2.0);
        baseSpeed = (int)((float)baseSpeed * timeModifier);
        return Math.max(0, Math.min(250, baseSpeed));
    }

    private static float calculateDirectObstruction(class_1937 level, class_2338 turbineBladePos) {
        int blockedDirections = 0;
        for (class_2350 direction : HORIZONTAL_DIRECTIONS) {
            class_2338 neighborPos = turbineBladePos.method_10093(direction);
            if (level.method_8320(neighborPos).method_26215()) continue;
            ++blockedDirections;
        }
        return (float)blockedDirections * 0.25f;
    }

    private static float calculateOpenness(class_1937 level, class_2338 pos) {
        int blockedCount = 0;
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (x == 0 && z == 0 || level.method_8320(pos.method_10069(x, 0, z)).method_26215()) continue;
                ++blockedCount;
            }
        }
        return 1.0f - (float)blockedCount / 8.0f;
    }

    public static int calculatePowerGeneration(int windSpeed) {
        if (windSpeed < 30) {
            return 0;
        }
        return (int)((float)windSpeed * 0.2f);
    }
}

