/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.item.component;

import de.markusbordihn.scraptechworkshop.energy.EnergyCell;
import de.markusbordihn.scraptechworkshop.item.ModItems;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;

public class EnergyCellItem
extends class_1792
implements EnergyCell {
    public static final String ID = "energy_cell";
    public static final int CAPACITY_MAH = 5000;
    public static final float VOLTAGE = 3.2f;
    public static final int DEFAULT_CHARGE_RATE = 25;
    public static final int DEFAULT_DISCHARGE_RATE = 100;
    private final int initialEnergy;
    private final int chargeRate;
    private final int dischargeRate;

    public EnergyCellItem(class_1792.class_1793 properties) {
        this(properties, 5000, 25, 100);
    }

    public EnergyCellItem(class_1792.class_1793 properties, int initialEnergy) {
        this(properties, initialEnergy, 25, 100);
    }

    public EnergyCellItem(class_1792.class_1793 properties, int initialEnergy, int chargeRate, int dischargeRate) {
        super(properties.method_7889(1).method_7895(5000).method_7894(class_1814.field_8907));
        this.initialEnergy = Math.max(1, Math.min(initialEnergy, 5000));
        this.chargeRate = Math.max(1, chargeRate);
        this.dischargeRate = Math.max(1, dischargeRate);
    }

    @Override
    public int getCapacity() {
        return 5000;
    }

    @Override
    public int getChargeRate() {
        return this.chargeRate;
    }

    @Override
    public int getDischargeRate() {
        return this.dischargeRate;
    }

    @Override
    public class_1799 createEmptyBattery() {
        return new class_1799((class_1935)ModItems.EMPTY_ENERGY_CELL.get());
    }

    public class_1799 method_7854() {
        class_1799 stack = new class_1799((class_1935)this);
        this.setEnergy(stack, this.initialEnergy);
        return stack;
    }

    public boolean method_31567(class_1799 itemStack) {
        return true;
    }

    @Override
    public int method_31571(class_1799 itemStack) {
        return EnergyCell.super.method_31571(itemStack);
    }

    public void method_7851(class_1799 itemStack, class_1937 level, List<class_2561> tooltipComponents, class_1836 isAdvanced) {
        tooltipComponents.add((class_2561)class_2561.method_43471((String)"item.scrap_tech_workshop.energy_cell.description"));
        int energy = this.getEnergy(itemStack);
        tooltipComponents.add((class_2561)class_2561.method_43470((String)(energy + " / 5000 mAh (3.2V)")).method_27694(style -> style.method_36139(this.method_31571(itemStack))));
        super.method_7851(itemStack, level, tooltipComponents, isAdvanced);
    }

    public boolean method_7878(class_1799 toRepair, class_1799 repair) {
        return false;
    }
}

