/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.menu;

import de.markusbordihn.scraptechworkshop.block.entity.collectorstation.CollectorStationBlockEntity;
import de.markusbordihn.scraptechworkshop.config.CollectorStationConfig;
import de.markusbordihn.scraptechworkshop.energy.EnergyPowerConsumer;
import de.markusbordihn.scraptechworkshop.item.component.EnergyCellItem;
import de.markusbordihn.scraptechworkshop.menu.EnergyPowerMenu;
import de.markusbordihn.scraptechworkshop.menu.slots.CollectorStationStorageSlot;
import de.markusbordihn.scraptechworkshop.menu.slots.CollectorStationUpgradeSlot;
import de.markusbordihn.scraptechworkshop.menu.slots.DummySlot;
import de.markusbordihn.scraptechworkshop.menu.slots.EnergyCellSlot;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_3913;
import net.minecraft.class_3914;
import net.minecraft.class_3917;
import net.minecraft.class_3919;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CollectorStationMenu
extends EnergyPowerMenu {
    public static final int STORAGE_GRID_START_X = 30;
    public static final int STORAGE_GRID_START_Y = 18;
    public static final int STORAGE_GRID_COLUMNS = 6;
    public static final int STORAGE_GRID_ROWS = 4;
    public static final int PROGRESS_BAR_X = 39;
    public static final int PROGRESS_BAR_Y = 96;
    public static final int UPGRADE_SLOT_START_X = 150;
    public static final int UPGRADE_SLOT_Y = 18;
    public static final int UPGRADE_SLOTS_COUNT = 4;
    public static final int PLAYER_INVENTORY_START_Y = 139;
    public static final int ADDITIONAL_CONTAINER_DATA_SIZE = 2;
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final String LOG_PREFIX = "[CollectorStationMenu]";
    public static class_3917<CollectorStationMenu> MENU_TYPE;
    private final CollectorStationBlockEntity blockEntity;
    private final class_1937 level;
    private final class_3913 additionalData;
    private final class_1277 dummyContainer;
    private final class_2338 blockPos;

    public CollectorStationMenu(int windowId, class_1661 playerInventory, class_2540 additionalData) {
        this(windowId, playerInventory, CollectorStationMenu.getBlockEntityFromData(playerInventory, additionalData), (class_3913)new class_3919(2));
    }

    public CollectorStationMenu(int windowId, class_1661 playerInventory, class_2586 entity, class_3913 additionalData) {
        class_3919 class_39192;
        if (entity instanceof EnergyPowerConsumer) {
            EnergyPowerConsumer consumer = (EnergyPowerConsumer)entity;
            class_39192 = consumer.getEnergyPowerData();
        } else {
            class_39192 = new class_3919(6);
        }
        super(MENU_TYPE, windowId, (class_3913)class_39192);
        this.level = playerInventory.field_7546.method_37908();
        this.additionalData = additionalData != null ? additionalData : new class_3919(2);
        this.dummyContainer = new class_1277(29);
        if (entity instanceof CollectorStationBlockEntity) {
            CollectorStationBlockEntity stationEntity;
            this.blockEntity = stationEntity = (CollectorStationBlockEntity)entity;
            this.blockPos = stationEntity.method_11016();
        } else {
            log.error("{} Expected CollectorStationBlockEntity but got {} at {}", (Object)LOG_PREFIX, (Object)entity, entity != null ? entity.method_11016() : "NULL");
            this.blockEntity = null;
            this.blockPos = null;
        }
        CollectorStationMenu.method_17359((class_1263)playerInventory, (int)29);
        this.addCollectorStationSlots();
        this.addPlayerInventoryAndHotbar(playerInventory, 139);
        this.method_17360(this.additionalData);
    }

    private static class_2586 getBlockEntityFromData(class_1661 playerInventory, class_2540 additionalData) {
        if (additionalData != null && additionalData.isReadable()) {
            class_2338 pos = additionalData.method_10811();
            class_1937 level = playerInventory.field_7546.method_37908();
            if (level != null) {
                return level.method_8321(pos);
            }
        }
        return null;
    }

    private void addCollectorStationSlots() {
        CollectorStationBlockEntity entityToUse = this.getValidBlockEntity();
        if (entityToUse != null) {
            this.method_7621(new EnergyCellSlot((class_1263)entityToUse, 0, -20, 6));
            int storageIndex = 1;
            for (int row = 0; row < 4; ++row) {
                for (int col = 0; col < 6; ++col) {
                    this.method_7621(new CollectorStationStorageSlot(entityToUse, storageIndex++, 30 + col * 18 + 2, 18 + row * 18));
                }
            }
            for (int i = 0; i < 4; ++i) {
                this.method_7621(new CollectorStationUpgradeSlot(entityToUse, 25 + i, 152, 18 + i * 18));
            }
        } else {
            for (int i = 0; i < 29; ++i) {
                this.method_7621(new DummySlot((class_1263)this.dummyContainer, i, -1000, -1000));
            }
        }
    }

    private CollectorStationBlockEntity getValidBlockEntity() {
        class_2586 entity;
        if (this.blockEntity != null) {
            return this.blockEntity;
        }
        if (this.blockPos != null && this.level != null && (entity = this.level.method_8321(this.blockPos)) instanceof CollectorStationBlockEntity) {
            CollectorStationBlockEntity stationEntity = (CollectorStationBlockEntity)entity;
            log.debug("{} Resolved BlockEntity on delayed lookup", (Object)LOG_PREFIX);
            return stationEntity;
        }
        return null;
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 returnStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot.method_7681()) {
            class_1799 slotStack = slot.method_7677();
            returnStack = slotStack.method_7972();
            if (index < 29 ? !this.method_7616(slotStack, 29, this.field_7761.size(), true) : (slotStack.method_7909() instanceof EnergyCellItem ? !this.method_7616(slotStack, 0, 1, false) : !this.method_7616(slotStack, 1, 25, false))) {
                return class_1799.field_8037;
            }
            if (slotStack.method_7960()) {
                slot.method_48931(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return returnStack;
    }

    public boolean method_7597(class_1657 player) {
        if (this.blockEntity == null) {
            return false;
        }
        return CollectorStationMenu.method_17695((class_3914)class_3914.method_17392((class_1937)this.level, (class_2338)this.blockEntity.method_11016()), (class_1657)player, (class_2248)this.blockEntity.method_11010().method_26204());
    }

    public int getStatus() {
        return this.additionalData.method_17390(0);
    }

    public int getStateTimer() {
        return this.additionalData.method_17390(1);
    }

    public int getCollectionProgress() {
        return this.additionalData.method_17390(1);
    }

    public int getMaxCollectionTime() {
        return switch (this.getStatus()) {
            case 0 -> CollectorStationConfig.chargingTime;
            case 1 -> CollectorStationConfig.collectingTime;
            case 2 -> CollectorStationConfig.returningTime;
            case 3 -> CollectorStationConfig.processingTime;
            default -> CollectorStationConfig.collectingTime;
        };
    }

    public CollectorStationBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    @Override
    public int getBatterySlotIndex() {
        return 0;
    }
}

