/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.menu;

import de.markusbordihn.scraptechworkshop.block.entity.rechargestation.RechargeStationBlockEntity;
import de.markusbordihn.scraptechworkshop.block.rechargestation.RechargeStationBlock;
import de.markusbordihn.scraptechworkshop.data.rechargestation.RechargeStationStatus;
import de.markusbordihn.scraptechworkshop.energy.EnergyPowerConsumer;
import de.markusbordihn.scraptechworkshop.menu.EnergyPowerMenu;
import de.markusbordihn.scraptechworkshop.menu.slots.DummySlot;
import de.markusbordihn.scraptechworkshop.menu.slots.EnergyCellSlot;
import de.markusbordihn.scraptechworkshop.menu.slots.RechargeStationInputSlot;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_3913;
import net.minecraft.class_3914;
import net.minecraft.class_3917;
import net.minecraft.class_3919;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RechargeStationMenu
extends EnergyPowerMenu {
    public static final int INPUT_SLOT_X = 80;
    public static final int INPUT_SLOT_Y = 35;
    public static final int PLAYER_INVENTORY_START_Y = 99;
    public static final int PROGRESS_BAR_X = 68;
    public static final int PROGRESS_BAR_Y = 56;
    public static final int PROGRESS_BAR_WIDTH = 40;
    public static final int PROGRESS_BAR_HEIGHT = 5;
    public static final int ADDITIONAL_CONTAINER_DATA_SIZE = 2;
    public static final int PROGRESS_DATA_INDEX = 0;
    public static final int MAX_PROGRESS_DATA_INDEX = 1;
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final String LOG_PREFIX = "[RECHARGE_STATION]";
    public static class_3917<RechargeStationMenu> MENU_TYPE;
    private final RechargeStationBlockEntity blockEntity;
    private final class_1937 level;
    private final class_3913 additionalData;
    private final class_1277 dummyContainer;
    private final class_2338 blockPos;

    public RechargeStationMenu(int windowId, class_1661 playerInventory, class_2540 additionalData) {
        this(windowId, playerInventory, RechargeStationMenu.getBlockEntityFromData(playerInventory, additionalData), (class_3913)new class_3919(2));
    }

    public RechargeStationMenu(int windowId, class_1661 playerInventory, class_2586 entity, class_3913 additionalData) {
        class_3919 class_39192;
        if (entity instanceof EnergyPowerConsumer) {
            EnergyPowerConsumer consumer = (EnergyPowerConsumer)entity;
            class_39192 = consumer.getEnergyPowerData();
        } else {
            class_39192 = new class_3919(6);
        }
        super(MENU_TYPE, windowId, (class_3913)class_39192);
        this.level = playerInventory.field_7546.method_37908();
        this.additionalData = additionalData != null ? additionalData : new class_3919(2);
        this.dummyContainer = new class_1277(2);
        if (entity instanceof RechargeStationBlockEntity) {
            RechargeStationBlockEntity rechargeStationBlockEntity;
            this.blockEntity = rechargeStationBlockEntity = (RechargeStationBlockEntity)entity;
            this.blockPos = rechargeStationBlockEntity.method_11016();
        } else {
            log.error("{} Expected RechargeStationBlockEntity but got {} at {}", (Object)LOG_PREFIX, (Object)entity, entity != null ? entity.method_11016() : "NULL");
            this.blockEntity = null;
            this.blockPos = null;
        }
        RechargeStationMenu.method_17359((class_1263)playerInventory, (int)2);
        this.addRechargeStationSlots();
        this.addPlayerInventoryAndHotbar(playerInventory, 99);
        this.method_17360(this.additionalData);
    }

    private static class_2586 getBlockEntityFromData(class_1661 playerInventory, class_2540 additionalData) {
        if (additionalData == null) {
            log.error("{} additionalData is NULL", (Object)LOG_PREFIX);
            return null;
        }
        try {
            class_2338 pos = additionalData.method_10811();
            class_1937 level = playerInventory.field_7546.method_37908();
            class_2586 blockEntity = level.method_8321(pos);
            if (blockEntity == null) {
                log.error("{} BlockEntity is NULL at {}", (Object)LOG_PREFIX, (Object)pos);
                return null;
            }
            return blockEntity;
        }
        catch (Exception e) {
            log.error("{} Error reading BlockEntity from additionalData: {}", (Object)LOG_PREFIX, (Object)e.getMessage());
            return null;
        }
    }

    private void addRechargeStationSlots() {
        RechargeStationBlockEntity entityToUse = this.getValidBlockEntity();
        if (entityToUse != null) {
            this.method_7621(new RechargeStationInputSlot((class_1263)entityToUse, 0, 80, 35));
            this.method_7621(new EnergyCellSlot((class_1263)entityToUse, 1, -20, 6));
        } else {
            for (int i = 0; i < 2; ++i) {
                this.method_7621(new DummySlot((class_1263)this.dummyContainer, i, -1000, -1000));
            }
            log.warn("{} Using dummy slots because BlockEntity is not available", (Object)LOG_PREFIX);
        }
    }

    private RechargeStationBlockEntity getValidBlockEntity() {
        class_2586 entity;
        if (this.blockEntity != null) {
            return this.blockEntity;
        }
        if (this.blockPos != null && this.level != null && (entity = this.level.method_8321(this.blockPos)) instanceof RechargeStationBlockEntity) {
            RechargeStationBlockEntity rechargeStationEntity = (RechargeStationBlockEntity)entity;
            log.debug("{} Resolved BlockEntity on delayed lookup", (Object)LOG_PREFIX);
            return rechargeStationEntity;
        }
        return null;
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 returnStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot.method_7681()) {
            class_1799 slotStack = slot.method_7677();
            returnStack = slotStack.method_7972();
            if (index < 2 ? !this.method_7616(slotStack, 2, this.field_7761.size(), true) : !this.method_7616(slotStack, 0, 2, false)) {
                return class_1799.field_8037;
            }
            if (slotStack.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return returnStack;
    }

    public boolean method_7597(class_1657 player) {
        if (this.blockEntity == null) {
            return false;
        }
        return RechargeStationMenu.method_17695((class_3914)class_3914.method_17392((class_1937)this.level, (class_2338)this.blockEntity.method_11016()), (class_1657)player, (class_2248)this.blockEntity.method_11010().method_26204());
    }

    public boolean isCharging() {
        int progress = this.additionalData.method_17390(0);
        int maxProgress = this.additionalData.method_17390(1);
        return progress > 0 && progress < maxProgress;
    }

    public int getScaledProgress() {
        int progress = this.additionalData.method_17390(0);
        int maxProgress = this.additionalData.method_17390(1);
        return maxProgress != 0 && progress != 0 ? progress * 40 / maxProgress : 0;
    }

    public RechargeStationBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public RechargeStationStatus getRechargeStationStatus() {
        if (this.blockEntity == null || this.blockEntity.method_10997() == null) {
            return RechargeStationStatus.IDLE;
        }
        return (RechargeStationStatus)((Object)this.blockEntity.method_11010().method_11654(RechargeStationBlock.STATUS));
    }

    @Override
    public int getBatterySlotIndex() {
        return 1;
    }
}

